<?php

class Dbtech {
    /**
     * Rende impossibile l'instanziazione della classe
     */
    private function __construct() { }

    /**
     * Registra l'autoloader per le classi relative al dbtech
     */
    static public function registerAutoloader() {
        spl_autoload_register(array('self', '_loader'));
    }

    /**
     * Carica il file con la classe in base al nome della classe.
     *
     * @param string $className
     */
    static public function _loader($className) {
        if (strtolower(substr($className, 0, 7)) == "dbtech_") {
            $classPath = dirname(__FILE__) .
                         DIRECTORY_SEPARATOR .
                         str_replace("_", DIRECTORY_SEPARATOR, $className);

            include $classPath . '.php';
        }
    }
}