<?php

/**
 * File di funzioni.
 *
 * @author      Agostino Pagnozzi
 * @copyright   2008 Neikos s.n.c.
 * @link        http://www.neikos.it
 * @version     1.0
 */

// Salva domini e alias:
function gestVirtualHost($virtualHost) {
    global $__server_id__, $__db__, $__server_ips__;

    // Spazio occupato dal dominio:
    $spazio = spazio_occupato($virtualHost["documentroot"]);

    // IP e porta:
    $IP_Port = $virtualHost["ip_port"];

    // Se esiste un ServerName:
    if (null !== $virtualHost["servername"]) {
        // Server Alias:
        $domini = $virtualHost["serveralias"];

        // Aggiunge il ServerName in testa alla lista degli alias:
        array_unshift($domini, $virtualHost["servername"]);

        // Resetta il parent per il ServerName che è sempre in cima alla lista:
        $parent = 0;
        $parent_project = 0;

        foreach ($domini as $nomeDominio) {
            // IP reale del dominio:
            $realIP = real_IP($nomeDominio);

            // Setta lo stato iniziale a OK:
            $stato = __STATO_OK__;
            $alert = "";

            // Controlla che l'IP appartenga a questo server:
            if ($realIP != "") {
                if (!in_array($realIP, $__server_ips__)) {
                    $stato = __STATO_ALERT__;
                    $alert .= "- L'indirizzo IP del dominio non rientra tra quelli del server\n";
                }
            } else {
                $stato = __STATO_ALERT__;
                $alert .= "- E' impossibile risolvere l'host\n";
            }

            // Stringa per settare nel db il parent:
            if ($parent == 0) {
                $parent_string = "NULL";

				// Se il progetto è un progetto padre
				// non aggiorna cliente:
				$project_string = "NULL";
				$project_update_string = "";
            } else {
                $parent_string = "'" . (int)$parent . "'";
				if ($parent_project <= 0) {
					$project_string = "NULL";
					$project_update_string = "";
				} else {
					$project_string = "'" . (int)$parent_project . "'";
					$project_update_string = "project_id = " . $project_string . ", ";
				}
            }

            // Controlla che non sia già presente (nome dominio + server).
            $query = "SELECT * FROM domains WHERE name = '" . mysql_escape_string($nomeDominio) . "' AND server_id = '" . $__server_id__ . "'";
            $ris = mysql_query($query);

            if (mysql_num_rows($ris) > 0) {
                // Controlla se è cambiato il server o il parent:
                $row = mysql_fetch_assoc($ris);

                $notifica = "";
                if ($row["server_id"] != $__server_id__) {
                        $notifica .= "- E' cambiato il server (vecchio: #" . $row["server_id"] . ")\n";
                }

                if ((int)$row["parent_id"] != (int)$parent) {
                        $notifica .= "- E' cambiata la composizione del virtualhost (ServerName, ServerAlias)\n";
                }

                if ($row["real_ip"] != $realIP) {
                        $notifica .= "- E' cambiato l'indirizzo IP (vecchio: " . $row["real_ip"] . ")\n";
                }

				if (!empty($notifica)) {
					mysql_query("INSERT INTO notice (domain_id, note, date) VALUES ('".$row["id"]."', '".mysql_escape_string($notifica)."', NOW())", $__db__);
				}

                // Aggiorna i dati:
                mysql_query("UPDATE domains SET " . $project_update_string  . " parent_id = " . $parent_string . ", last_update = NOW(),
                                        server_id = '" . $__server_id__ . "', ip_port = '" . $IP_Port . "',
                                        real_ip = '" . $realIP . "', status = '" . $stato . "',
                                        update_status = 'A', spazio = '" . $spazio . "',
                                        alert = '" . mysql_escape_string($alert) . "' WHERE
                                        id = '" . (int)$row["id"] . "'", $__db__);

                if ($parent == 0) {
                    // Setta il parent per i prossimi serveralias:
                    $parent = $row["id"];
                    $parent_project = $row["project_id"];
                }
            } else {
                // Inserisce i nuovi dati:
                mysql_query("INSERT INTO domains (name, project_id, parent_id, last_update, server_id, ip_port, real_ip, status, update_status, spazio, alert) VALUES ('" . mysql_escape_string($nomeDominio) . "', " . $project_string . ", " . $parent_string . ", NOW(), '" . $__server_id__ . "', '" . $IP_Port . "', '" . $realIP . "', '" . $stato . "', 'A', '" . $spazio  . "', '" . mysql_escape_string($alert) . "')", $__db__);

                if ($parent == 0) {
                    // Setta il parent per i prossimi serveralias:
                    $parent = mysql_insert_id($__db__);
                    $parent_project = 0;
                }
            }
        }
    }
}


/**
 * Trova l'IP del dominio:
 *
 * @param string $dominio
 *
 * @return string
 */
function real_IP($dominio) {
    $dominio = trim($dominio);

    // Nel caso di domini tipo:
    // *.test.neikos.it, sostituisce lo *
    // con una stringa qualsiasi non definita altrimenti.
    if (substr($dominio, 0, 2) == "*.") {
    	$dominio = "aasfdbvasfdbasd" . substr($dominio, 1);
    }

	$output = shell_exec("/usr/bin/dig $dominio A +short | /usr/bin/tail -1");
	$ip = trim($output);

    return $ip;
}

/**
 * Controlla la quantità di spazio occupata dalla document root:
 *
 * @param string $document_root
 *
 * @return string
 */
function spazio_occupato($document_root) {
        if ($document_root == null) return "";

        $sp = trim(`du -s -h "$document_root"`);
        $p = split("[\s\t\n\r]", $sp);

        if (count($p) > 0) return $p[0];
        return $sp;
}

/**
 * Controlla la quantità di spazio occupata da una casella mail:
 *
 * @param string $dominio
 * @param string $user
 *
 * @return string
 */
function spazio_occupato_mail($dominio, $user) {
	$sp = trim(`su root -c "du -s -h /var/qmail/mailnames/$dominio/$user/"`);
	$p = split("[\s\t\n\r]", $sp);

	if (count($p) > 0) return $p[0];
	return $sp;
}


/**
 * Funzioni per la gestione del db.
 */

function getGlobalDbPrivileges($userData, $group = null, $notAllPrivileges = false) {
	$res = array();

	// Retrieve all privileges
	$privs = array_keys(getGlobalDbPrivilegesList($group));

	// Check all privileges for this user
	foreach($privs AS $priv) {
		if ($userData[getGlobalDbPrivilegeColumn($priv)] == 'Y') {
			$res[] = $priv;
		}
	}

	// Return USAGE if user has no privileges
	if (count($res) == 0) {
		return array(
			'USAGE',
		);
	} elseif(count($res) == 1 && $res[0] == 'GRANT') {
		return array(
			'USAGE',
			'GRANT',
		);
	}

	if ($group || $notAllPrivileges) {
		// Return result if we are only looking for a group
		return $res;
	} else {
		// Remove GRANT privilege from privs array
		$resWithoutGrant = array_diff($res, array('GRANT'));

		// Compare privilege count
		if (count($resWithoutGrant) == count($privs) - 1) {
			// User has ALL PRIVILEGES
			$userPrivs = array(
				'ALL PRIVILEGES',
			);
			// Also check GRANT privilege
			if(array_search('GRANT', $res) !== false)
			{
				$userPrivs[] = 'GRANT';
			}
			return $userPrivs;
		} else {
			// User doesn't have ALL PRIVILEGES
			return $res;
		}
	}
}

function getGlobalDbPrivilegesList($group = null) {
    $privs = array(
        'data' => array(
            'SELECT' => null,
            'INSERT' => null,
            'UPDATE' => null,
            'DELETE' => null,
            'FILE' => null,
        ),
        'structure' => array(
            'CREATE' => null,
            'ALTER' => null,
            'INDEX' => null,
            'DROP' => null,
            'CREATE TEMPORARY TABLES' => null,
            'SHOW VIEW' => null,
            'CREATE ROUTINE' => null,
            'ALTER ROUTINE' => null,
            'EXECUTE' => null,
            'CREATE VIEW' => null,
        ),
        'administration' => array(
            'GRANT' => null,
            'SUPER' => null,
            'PROCESS' => null,
            'RELOAD' => null,
            'SHUTDOWN' => null,
            'SHOW DATABASES' => null,
            'LOCK TABLES' => null,
            'REFERENCES' => null,
            'REPLICATION CLIENT' => null,
            'REPLICATION SLAVE' => null,
            'CREATE USER' => null,
        ),
    );

    if ($group) {
        return $privs[$group];
    } else {
        return array_merge($privs['data'], $privs['structure'], $privs['administration']);
    }
}

function getGlobalDbPrivilegeColumn($priv) {
	switch($priv) {
		case 'SHOW DATABASES':
			return 'Show_db_priv';
		case 'CREATE TEMPORARY TABLES':
			return 'Create_tmp_table_priv';
		case 'REPLICATION SLAVE':
			return 'Repl_slave_priv';
		case 'REPLICATION CLIENT':
			return 'Repl_client_priv';
		default:
			return ucfirst(strtolower(str_replace(' ', '_', $priv))) . '_priv';
	}
}

function getDbPrivilegesList($group = null) {
	$privs = array(
		'data' => array(
			'SELECT' => null,
			'INSERT' => null,
			'UPDATE' => null,
			'DELETE' => null,
		),
		'structure' => array(
			'CREATE' => null,
			'ALTER' => null,
			'INDEX' => null,
			'DROP' => null,
			'CREATE TEMPORARY TABLES' => null,
			'SHOW VIEW' => null,
			'CREATE ROUTINE' => null,
			'ALTER ROUTINE' => null,
			'EXECUTE' => null,
			'CREATE VIEW' => null,
		),
		'administration' => array(
			'GRANT' => null,
			'LOCK TABLES' => null,
			'REFERENCES' => null,
		),
	);

	if ($group) {
		return $privs[$group];
	} else {
		return array_merge($privs['data'], $privs['structure'], $privs['administration']);
	}
}

function getDbPrivileges($userData, $group = null) {
	$res = array();

	$privs = array_keys(getDbPrivilegesList($group));

	foreach($privs AS $priv) {
		if ($userData[getDbPrivilegeColumn($priv)] == 'Y') {
			$res[] = $priv;
		}
	}

	if (count($res) == count($privs)) {
		return array(
			'ALL PRIVILEGES',
		);
	} else {
		return $res;
	}
}

function getDbPrivilegeColumn($priv) {
	switch($priv) {
		case 'CREATE TEMPORARY TABLES':
			return 'Create_tmp_table_priv';
		default:
			return ucfirst(strtolower(str_replace(' ', '_', $priv))) . '_priv';
	}
}


function getDomainFileConf() {
	$skipEntry = array('chroot', 'default', 'fs', 'fs-passwd', '.skel');

	$substr = '_httpd.include' ;
	$dir_vhosts = '/var/www/vhosts/';

	if ($handle = opendir($dir_vhosts)) {
		while (false !== ($entry = readdir($handle))) {
		    if ($entry != "." && $entry != ".." && !in_array($entry, $skipEntry) && @is_dir($dir_vhosts . $entry)) {
  		      	if ($handle_conf = opendir($dir_vhosts . $entry . '/conf/')) {
   		           $data_primo_file = 0;

	     		   while (false !== ($entry_conf = readdir($handle_conf))) {
	          	        if (strpos($entry_conf, $substr)) {
	                       if($data_primo_file < filectime($dir_vhosts . $entry . '/conf/' . $entry_conf)) {
	                           $file_conf = $dir_vhosts . $entry . '/conf/' . $entry_conf;
        	               }
	          	        }
            	   }
                   $output[] = $file_conf;
                }
            }
        }
		closedir($handle);
	}
	return $output;
}
