<?php

class Dbtech_Software {
    /**
     * Tipi di software da analizzare
     * @var array
     */
    static protected $_types = array("Wordpress");


    /**
     * Legge sul server i dati dei software
     */
    static public function loadSoftwareData() {
        $ret = array();

        foreach (self::$_types as $type) {
            // Software:
            $software = self::factory($type);
            $ret += (array)$software->loadSoftwareData();
        }

        return $ret;
    }


    /**
     * Instanzia un software
     *
     * @param string $softwareName
     *
     * return Dbtech_Software_Abstract|null
     */
    static public function factory($softwareName) {
        if (@in_array($softwareName, self::$_types)) {
            // Nome della classe:
            $className = "Dbtech_Software_" . $softwareName;

            return new $className;
        }

        return null;
    }
}