<?php

class Dbtech_Software_Wordpress extends Dbtech_Software_Abstract {
    /**
     * Id del tipo software sul dbtech
     * @var int
     */
    const TIPO = 73;

    /**
     * Cerca sul server tutte le instanze del software.
     *
     * @return array|null|false
     */
    public function findInstances() {
        // Specifiche per i flussi di input, ouput e error:
        $descriptorSpecs = array(
            0 => array("pipe", "r"),  // stdin
            1 => array("pipe", "w"),  // stdout
            2 => array('pipe', 'a')   // sterr
        );

        // Comando da eseguire:
        $cmd = 'find / -name wp-config.php';

        // Esegue il comando:
        $process = proc_open($cmd, $descriptorSpecs, $pipes);
        if (is_resource($process)) {
            // Standard output:
            $stdOutut = stream_get_contents($pipes[1]);
            fclose($pipes[1]);

            // Valore di ritorno:
            $exitCode = proc_close($process);

            // Se il comando non è terminato correttamente:
            if ($exitCode == -1) {
                return false;
            }

            // File trovati:
            $files = array_filter(explode("\n", $stdOutut));

            // Variabile di ritorno:
            $ret = array();

            if (count($files) > 0) {
                foreach ($files as $file) {
                    if (@is_file($file) && strtolower(@substr($file, -13)) == "wp-config.php") {
                        $ret[] = @substr($file, 0, -13);
                    }
                }
            }

            return $ret;
        }

        return null;
    }


    /**
     * Prende i dati che servono per riconoscere l'instanza del software sul dbtech
     *
     * @return array
     */
    public function getDataByPath($installPath) {
        /**
         * Esegue lo script per la determinazione dei dati del wp e ne raccoglie i risultati
         */
        $pathScript = dirname(__FILE__) . "/Wordpress/load_wp_instance.php";

        $output = null;
        $exitCode = null;
        @exec("php " . $pathScript . " " . $installPath, $output, $exitCode);

        if ($exitCode == 0 && !empty($output)) {
            return @json_decode(implode("\n", $output), true);
        }

        return false;
    }


    /**
     * Prende i dati relativi ai WP
     */
    public function loadSoftwareData() {
        $ret = array();

        // Cicla sulle installazioni del software:
        $paths = $this->findInstances();

        if (count($paths) > 0) {
            foreach ($paths as $path) {
                $data = $this->getDataByPath($path);

                if ($data !== false) {
                    // Normalizza i dati dei wp multisite:
                    if ($data['is_multisite']) {
                        $mData = $data['multisite_data'];

                        if (is_array($mData) && count($mData) > 0) {
                            foreach ($mData as $m) {
                                // Info sul dominio nel multisite:
                                // ATTENZIONE: questa nota funge da identificativo per i domini nel multisite, i quali hanno path sul server uguale.
                                // E' stata scelta questa soluzione per mantenere generica l'implementazione della gestione software, e non introdurre
                                // particolarità proprio del solo WP.
                                $info = 'WP Multisite - Blog id: #' . $m['blog_id'];

                                $ret[] = array(
                                    "path"      => $data['path'],
                                    "version"   => $data['version'],
                                    "users"     => $m['users'],
                                    "domain"    => $m['domain'],
                                    "login_url" => $m['login_url'],
                                    "plugins"   => $m['plugins'],
                                    "tipo"      => self::TIPO,
                                    "info"      => $info
                                );
                            }
                        }
                    } else {
                        $data["tipo"] = self::TIPO;
                        $ret[] = $data;
                    }
                }
            }
        }

        return $ret;
    }
}