<?php

/**
 * Script usato dalla classe Dbtech_Software_Wordpress per instanziare un ambiente
 * WP e prendere i dati che occorroono.
 */

// Innalza i limiti per evitare problemi:
ini_set("memory_limit", "512M");
set_time_limit(3600);

// Librerie:
require_once(dirname(__FILE__) . "/includes/functions.php");

// Percorso del file di installazione di WP:
$path = $argv[1];

// Aggiunge lo slash finale (se manca):
$path = rtrim($path, "/") . "/";

// Controlla il path:
if (!is_dir($path)) {
    echo "Percorso non valido.\n";
    exit(10);
}

// Alcune costanti:
define('ABSPATH', $path);

// Cambia la directory corrente:
chdir(ABSPATH);

// Controlla che ci sia il wp-config:
$configFilePath = ABSPATH . "/wp-config.php";
if (!is_file($configFilePath)) {
    echo "Config non trovato.\n";
    exit(50);
}

// Legge il config:
$newConfigPhp = get_rewritten_wpconfig($configFilePath);
if ($newConfigPhp === false) {
    echo "Errore: impossibile manipolare il wp-config.php\n";
    exit(60);
}

// Include il config modificato:
eval($newConfigPhp);

// Inclusione dei file necessari:
include_once(ABSPATH . "/wp-admin/includes/admin.php");

// Verifica se si tratta di una installazione multisite:
$isMultisite = is_multisite();

// Variabile di ritorno:
$ret = array(
    "is_multisite"   => $isMultisite,
    "path"           => ABSPATH,
    "version"        => get_real_wp_version()
);

// Ulteriori dati:
if ($isMultisite) {
    $multisiteData = array();

    // Prende i blog del multisite:
    $blogs = _getBlogs();

    // Per ognuno dei blog prende i dati sui plugin:
    if (count($blogs) > 0) {
        foreach ($blogs as $blog_id => $blog) {
            // Admin:
            $users = _getAdminUser($blog_id);

            // Dati dei plugin:
            $pluginData = _getPluginData($blog_id);

            $multisiteData[$blog_id] = array(
                'blog_id'   => $blog_id,
                'domain'    => $blog['domain'],
                'login_url' => $blog['login_url'],
                'users'     => $users,
                'plugins'   => $pluginData
            );
        }
    }

    $ret["multisite_data"] = $multisiteData;
} else {
    // Dominio su cui il sito è installato:
    $ret["domain"] = site_url();

    // Admin url:
    $ret["login_url"] = wp_login_url();

    // Admin:
    $ret["users"] = _getAdminUser();

    // Prende i dati sui plugin:
    $ret["plugins"] = _getPluginData();
}

// Stampa la risposta in formato JSON:
echo json_encode($ret);

// Esecuzione terminata con successo:
exit(0);