<?php

/**
 * Chiede a MySql la lista dei database e degli utenti presenti.
 *
 * @author      Agostino Pagnozzi
 * @copyright   2015 Neikos s.n.c.
 * @link        http://www.neikos.it
 * @version     1.1
 */

// Libreria:
include_once("./scripts/functions.php");

// Prende in carico l'aggiornamento:
mysqli_query($__db__, "UPDATE updates SET status = 'X' WHERE server_id = '" . (int)$__server_id__ . "' AND modulo='Db' AND status='A'");

// Setta tutti i record in aggiornamento:
mysqli_query($__db__, "UPDATE `database` SET `update_status` = 'X' WHERE `server_id` = '" . (int)$__server_id__ . "'");
mysqli_query($__db__, "UPDATE `database_user` SET `update_status` = 'X' WHERE `server_id` = '" . (int)$__server_id__ . "'");

// Si connette al DBMS locale:
$__db_local__ = @mysqli_connect($__db_local_host__, $__db_local_user__, $__db_local_pw__) or die();
mysqli_select_db($__db_local__, "mysql");

// Prende la lista dei database presenti:
$risDatabase = mysqli_query($__db_local__, "SHOW DATABASES");

while (list($nomeDb) = mysqli_fetch_row($risDatabase)) {
    // Prende la dimensione del db scelto:
    $risDiskUsage = mysqli_query($__db_local__, "SELECT SUM(`data_length` + `index_length`) AS `total` FROM `information_schema`.`tables` WHERE `table_schema` = \"" . mysqli_real_escape_string($__db_local__, $nomeDb) . "\" GROUP BY `table_schema`");
    list($diskUsage) = mysqli_fetch_row($risDiskUsage);

    // Cerca il database:
	$risDb = mysqli_query($__db__, "SELECT `id` FROM `database` WHERE `nome` = '" . mysqli_real_escape_string($__db__, $nomeDb) . "' AND `server_id` = '" . (int)$__server_id__ . "'");
	if (mysqli_num_rows($risDb) > 0) {
		// Id del database:
		list($dbId) = mysqli_fetch_array($risDb);

		// Aggiorna i dati del db:
		$queryUpdate = "UPDATE `database` SET `spazio_occ` = " . ($diskUsage > 0 ? "'" . $diskUsage . "'" : "NULL") . ", `immesso` = 'A', `last_update` = NOW(), `update_status` = 'A' WHERE id = '" . $dbId . "'";
		mysqli_query($__db__, $queryUpdate);
	} else {
		// Inserisce i dati del db:
		$queryInsert = "INSERT INTO `database` (`id`, `project_id`, `server_id`, `nome`, `software_id`, `spazio_occ`, `immesso`, `last_update`, `update_status`, `note`) VALUES
						(NULL, NULL, '" . (int)$__server_id__ . "', '" . mysqli_real_escape_string($__db__, $nomeDb) . "', NULL, " . ($diskUsage > 0 ? "'" . $diskUsage . "'" : "NULL") . ", 'A', NOW(), 'A', '')";
		mysqli_query($__db__, $queryInsert);
	}
}

// Prende la lista degli utenti:
$risUtenti = mysqli_query($__db_local__, "SELECT * FROM `user`");
while ($rowUtente = mysqli_fetch_assoc($risUtenti)) {
	// Calcola i privilegi globali:
	$privilegiGlobali = implode(", ", getGlobalDbPrivileges($rowUtente));

	// Azzera la variabile per sicurezza:
	$uId = 0;

	// Verifica se l'utente è già presente:
	$r = mysqli_query($__db__, "SELECT `id` FROM `database_user` WHERE `user` = '" . mysqli_real_escape_string($__db__, $rowUtente["User"]) . "' AND `host` = '" . mysqli_real_escape_string($__db__, $rowUtente["Host"]) . "' AND `server_id` = '" . (int)$__server_id__ . "'");
	if (mysqli_num_rows($r) > 0) {
		// Prende l'id dell'utente:
		list($uId) = mysqli_fetch_array($r);

		// Modifica l'utente:
		$queryUpdate = "UPDATE `database_user` SET `privilegi` = '" . $privilegiGlobali . "', `immesso` = 'A', `last_update` = NOW(), `update_status` = 'A' WHERE id = '" . $uId . "'";
		mysqli_query($__db__, $queryUpdate);
	} else {
		// Inserisce il nuovo utente:
		$queryInsert = "INSERT INTO `database_user` (`id`, `host`, `user`, `pw`, `server_id`, `privilegi`, `immesso`, `last_update`, `update_status`, `note`) VALUES
						(NULL , '" . mysqli_real_escape_string($__db__, $rowUtente["Host"]) . "', '" . mysqli_real_escape_string($__db__, $rowUtente["User"]) . "',
						'', '" . (int)$__server_id__ . "', '" . $privilegiGlobali . "', 'A', NOW(), 'A', '')";
		mysqli_query($__db__, $queryInsert);

		// Prende l'id:
		$uId = mysqli_insert_id($__db__);
	}

	$uId = (int)$uId;

	if ($uId > 0) {
		// Elimina le vecchie associazioni con i database:
		mysqli_query($__db__, "DELETE FROM `database_to_database_user` WHERE `database_user_id` = '" . $uId . "'");

		// Per ogni coppia user/host verifica i privilegi sui db:
		$risUtenteDb = mysqli_query($__db_local__, "SELECT * FROM `db` WHERE Host = '" . mysqli_real_escape_string($__db_local__, $rowUtente["Host"]) . "' AND
									User = '" . mysqli_real_escape_string($__db_local__, $rowUtente["User"]) . "'");

		while ($rowUtenteDb = mysqli_fetch_assoc($risUtenteDb)) {
			// Calcola i privilegi relativi al db:
			$privilegiDb = implode(", ", getDbPrivileges($rowUtenteDb));

			// Cerca il db:
			$risDb = mysqli_query($__db__, "SELECT `id` FROM `database` WHERE `nome` = '" . stripslashes($rowUtenteDb["Db"]) . "' AND `server_id` = '" . (int)$__server_id__ . "'");
			if (mysqli_num_rows($risDb) > 0) {
				list($dbId) = mysqli_fetch_array($risDb);

				// Inserisce l'associazione:
				mysqli_query($__db__, "INSERT INTO `database_to_database_user` (`database_id`, `database_user_id`, `privilegi`) VALUES
							('" . $dbId . "', '" . $uId . "', '" . $privilegiDb . "')");
			}
		}
	}

	// TODO: privilegi sulle tabelle...
}


// "Spegne" l'aggiornamento manuale (aggiornamento richiamato tramite interfaccia):
mysqli_query($__db__, "UPDATE updates SET status = 'D' WHERE server_id = '" . (int)$__server_id__ . "' AND modulo = 'Db' AND status = 'X'");
if (mysqli_affected_rows($__db__) == 0) {
	// Inserisce l'aggiornamento effettuato (aggiornamento non richiamato tramite interfaccia):
	mysqli_query($__db__, "INSERT INTO updates (id, server_id, modulo, status, data_ins) VALUES ('', '" . (int)$__server_id__ . "', 'Db', 'D', NOW())");
}

// Setta i record ancora in aggiornamento come non aggiornati:
mysqli_query($__db__, "UPDATE `database` SET `update_status` = 'D' WHERE `server_id` = '" . (int)$__server_id__ . "' AND `update_status` = 'X'");
mysqli_query($__db__, "UPDATE `database_user` SET `update_status` = 'D' WHERE `server_id` = '" . (int)$__server_id__ . "' AND `update_status` = 'X'");

