<?php

/**
 * Legge il file httpd.conf per ricavare le informazioni che riguardano
 * i domini.
 *
 * @author      Agostino Pagnozzi
 * @copyright   2008 Neikos s.n.c.
 * @link        http://www.neikos.it
 * @version     1.0
 */

// Libreria:
include_once("./scripts/functions.php");

// Prende in carico l'aggiornamento:
mysqli_query($__db__, "UPDATE updates SET status = 'X' WHERE server_id = '" . (int)$__server_id__ . "' AND modulo='D' AND status='A'");

// Setta tutti i record in aggiornamento:
mysqli_query($__db__, "UPDATE domains SET update_status = 'X' WHERE server_id = '" . (int)$__server_id__ . "'");

// Legge tutti i file della directory:
if ($handleDir = opendir($dirSitesEnabled)) {
	while (false !== ($siteEnabled = readdir($handleDir))) {
		$source = $dirSitesEnabled . "/" . $siteEnabled;

		if (is_file($source)) {
			$data = explode("\n", implode('', file($source)));
			$vthost = false;

			foreach ($data as $dati) {
				$dati = str_replace(array("\n,\t"), " ", $dati);
				$dati = preg_replace("/\s+/i", " ", trim($dati));

				if (strpos($dati, "#") === false) { // salta i commenti.
					if (strpos(strtolower($dati), "<virtualhost ") !== false) {
						// Inizio vhost:
						$vthost = true;

						// Aggiusta i dati:
						$datiVHost = explode(" ", str_replace(array("<", ">"), "", $dati), 3);

						// IP_Port:
						$IP_Port = "*:80";
						if (isset($datiVHost[1])) {
							$IP_Port = trim($datiVHost[1]);
						}

						// Azzera la variabile:
						$virtualHost = array(
	                                                        "ip_port"       => $IP_Port,
	                                                        "servername"    => null,
	                                                        "serveralias"   => array(),
	                                                        "documentroot"  => null
						);
					} else if (strpos(strtolower($dati), "</virtualhost>") !== false) {
						// fine vhost.
						$vthost = false;

						// Gestisce i dati acquisiti:
						gestVirtualHost($virtualHost);
					}

					// Se ci troviamo tra i tag di apertura e chiusura virtualhost:
					if ($vthost) {
						if (strpos(strtolower($dati), "servername ") !== false) {
							$server = explode(" ", $dati, 3);
							$server = explode(":", $server[1]);

							$virtualHost["servername"] = $server[0];
						} else if (strpos(strtolower($dati), "serveralias ") !== false) {
							$alias = explode(" ", $dati);
							if (is_array($alias)) {
								// Piu' serveralias sulla stessa riga:
								for ($a=1;$a<count($alias);$a++) {
									$als = explode(":", $alias[$a]);
									$al = trim($als[0]);
									if ($al != "") {
										$virtualHost["serveralias"][] = $al;
									}
								}
							}
						} else if (strpos(strtolower($dati), "documentroot ") !== false) {
							$documentroot = explode(" ", $dati, 3);
							$virtualHost["documentroot"] = $documentroot[1];
						}
					}
				}
			}
		}
	}

	closedir($handleDir);
} else {
	$errore = "Impossibile aprire la directory '" . $dirSitesEnabled . "'";
	echo $errore;
}

// "Spegne" l'aggiornamento manuale (aggiornamento richiamato tramite interfaccia):
mysqli_query($__db__, "UPDATE updates SET status = 'D' WHERE server_id = '" . (int)$__server_id__ . "' AND modulo='D' AND status='X'");
if (mysqli_affected_rows($__db__) == 0) {
	// Inserisce l'aggiornamento effettuato (aggiornamento non richiamato tramite interfaccia):
	mysqli_query($__db__, "INSERT INTO updates (id, server_id, modulo, status, data_ins) VALUES ('', '" . (int)$__server_id__ . "', 'D', 'D', NOW())");
}

// Setta i record ancora in aggiornamento come non aggiornati:
mysqli_query($__db__, "UPDATE domains SET update_status = 'D' WHERE server_id = '" . (int)$__server_id__ . "' AND update_status = 'X'");

