<?php

/**
 * File di funzioni.
 *
 * @author      Agostino Pagnozzi
 * @copyright   2015 Neikos s.n.c.
 * @link        http://www.neikos.it
 * @version     1.0
 */

// Salva domini e alias:
function gestVirtualHost($virtualHost) {
        global $__server_id__, $__db__, $__server_ips__;

        // Spazio occupato dal dominio:
        $spazio = spazio_occupato($virtualHost["documentroot"]);

        // IP e porta:
        $IP_Port = $virtualHost["ip_port"];

        // Se esiste un ServerName:
        if (null !== $virtualHost["servername"]) {
                // Server Alias:
                $domini = $virtualHost["serveralias"];

                // Aggiunge il ServerName in testa alla lista degli alias:
                array_unshift($domini, $virtualHost["servername"]);

                // Resetta il parent per il ServerName che è sempre in cima alla lista:
                $parent = 0;
                $parent_project = 0;

                foreach ($domini as $nomeDominio) {
                        // IP reale del dominio:
                        $realIP = real_IP($nomeDominio);

                        // Setta lo stato iniziale a OK:
                        $stato = __STATO_OK__;
                        $alert = "";

                        // Controlla che l'IP appartenga a questo server:
                        if ($realIP != "") {
                                if (!in_array($realIP, $__server_ips__)) {
                                        $stato = __STATO_ALERT__;
                                        $alert .= "- L'indirizzo IP del dominio non rientra tra quelli del server\n";
                                }
                        } else {
                                $stato = __STATO_ALERT__;
                                $alert .= "- E' impossibile risolvere l'host\n";
                        }

                        // Stringa per settare nel db il parent:
                        if ($parent == 0) {
                                $parent_string = "NULL";

                                // Se il progetto è un progetto padre
                                // non aggiorna cliente:
                                $project_string = "NULL";
                                $project_update_string = "";
                        } else {
                                $parent_string = "'" . (int)$parent . "'";
                                if ($parent_project <= 0) {
                                        $project_string = "NULL";
                                        $project_update_string = "";
                                } else {
                                        $project_string = "'" . (int)$parent_project . "'";
                                        $project_update_string = "project_id = " . $project_string . ", ";
                                }
                        }

                        // Controlla che non sia già presente (nome dominio + server).
                        $query = "SELECT * FROM domains WHERE name = '" . mysqli_real_escape_string($__db__, $nomeDominio) . "' AND server_id = '" . $__server_id__ . "'";
                        $ris = mysqli_query($__db__, $query);

                        if (mysqli_num_rows($ris)>0) {
                                // Controlla se è cambiato il server o il parent:
                                $row = mysqli_fetch_assoc($ris);
                                $notifica = "";
                                if ($row["server_id"] != $__server_id__) {
                                        $notifica .= "- E' cambiato il server (vecchio: #" . $row["server_id"] . ")\n";
                                }
                                if ((int)$row["parent_id"] != (int)$parent) {
                                        $notifica .= "- E' cambiata la composizione del virtualhost (ServerName, ServerAlias)\n";
                                }
                                if ($row["real_ip"] != $realIP) {
                                        $notifica .= "- E' cambiato l'indirizzo IP (vecchio: " . $row["real_ip"] . ")\n";
                                }
                                if (!empty($notifica)) {
                                        mysqli_query($__db__, "INSERT INTO notice (domain_id, note, date) VALUES ('".$row["id"]."', '".mysqli_real_escape_string($__db__, $notifica)."', NOW())");
                                }


                                // Aggiorna i dati:
                                mysqli_query($__db__, "UPDATE domains SET " . $project_update_string  . " parent_id = " . $parent_string . ", last_update = NOW(),
                                                        server_id = '" . $__server_id__ . "', ip_port = '" . $IP_Port . "',
                                                        real_ip = '" . $realIP . "', status = '" . $stato . "',
                                                        update_status = 'A', spazio = '" . $spazio . "',
                                                        alert = '" . mysqli_real_escape_string($__db__, $alert) . "' WHERE
                                                        id = '" . (int)$row["id"] . "'");

                                if ($parent == 0) {
                                        // Setta il parent per i prossimi serveralias:
                                        $parent = $row["id"];
                                        $parent_project = $row["project_id"];
                                }
                        } else {
                                // Inserisce i nuovi dati:
                                mysqli_query($__db__, "INSERT INTO domains (name, project_id, parent_id, last_update, server_id, ip_port, real_ip, status, update_status, spazio, alert) VALUES ('" . mysqli_real_escape_string($__db__, $nomeDominio) . "', " . $project_string . ", " . $parent_string . ", NOW(), '" . $__server_id__ . "', '" . $IP_Port . "', '" . $realIP . "', '" . $stato . "', 'A', '" . $spazio  . "', '" . mysqli_real_escape_string($__db__, $alert) . "')");

                                if ($parent == 0) {
                                        // Setta il parent per i prossimi serveralias:
                                        $parent = mysqli_insert_id($__db__);
                                        $parent_project = 0;
                                }
                        }
                }
        }
}


/**
 * Trova l'IP del dominio
 *
 * @param string $dominio
 *
 * @return string
 */
function real_IP($dominio) {
        $dominio = trim($dominio);

        // Nel caso di domini tipo:
        // *.test.neikos.it, sostituisce lo *
        // con una stringa qualsiasi non definita altrimenti.
        if (substr($dominio, 0, 2) == "*.") {
            $dominio = "aasfdbvasfdbasd" . substr($dominio, 1);
        }

        $res = @dns_get_record($dominio, DNS_A);
        if ($res === FALSE || !is_array($res) || empty($res)) {
            return '';
        }

        $ip = $res[0]['ip'];
        return $ip;
}

/**
 * Controlla la quantità di spazio occupata dalla document root
 */
function spazio_occupato($document_root) {
        if ($document_root == null) {
            return "";
        }

        $sp = trim(`du -s -h "$document_root"`);
        $p = preg_split("/[\s\t\n\r]+/", $sp);

        if (count($p) > 0) {
            return $p[0];
        }

        return $sp;
}

/**
 * Funzioni per la gestione del db.
 */
function getGlobalDbPrivilegesList($group = null) {
    $privs = array(
        'data' => array(
            'SELECT' => null,
            'INSERT' => null,
            'UPDATE' => null,
            'DELETE' => null,
            'FILE' => null,
        ),
        'structure' => array(
            'CREATE' => null,
            'ALTER' => null,
            'INDEX' => null,
            'DROP' => null,
            'CREATE TEMPORARY TABLES' => null,
            'SHOW VIEW' => null,
            'CREATE ROUTINE' => null,
            'ALTER ROUTINE' => null,
            'EXECUTE' => null,
            'CREATE VIEW' => null,
        ),
        'administration' => array(
            'GRANT' => null,
            'SUPER' => null,
            'PROCESS' => null,
            'RELOAD' => null,
            'SHUTDOWN' => null,
            'SHOW DATABASES' => null,
            'LOCK TABLES' => null,
            'REFERENCES' => null,
            'REPLICATION CLIENT' => null,
            'REPLICATION SLAVE' => null,
            'CREATE USER' => null,
        )
    );

    if ($group) {
        return $privs[$group];
    } else {
        return array_merge($privs['data'], $privs['structure'], $privs['administration']);
    }
}


function getGlobalDbPrivileges($userData, $group = null, $notAllPrivileges = false) {
    $res = array();

    // Retrieve all privileges
    $privs = array_keys(getGlobalDbPrivilegesList($group));

    // Check all privileges for this user
    foreach($privs AS $priv) {
        if ($userData[getGlobalDbPrivilegeColumn($priv)] == 'Y') {
            $res[] = $priv;
        }
    }

    // Return USAGE if user has no privileges
    if (count($res) == 0) {
        return array(
                'USAGE',
        );
    } elseif(count($res) == 1 && $res[0] == 'GRANT') {
        return array(
            'USAGE',
            'GRANT'
        );
    }

    if ($group || $notAllPrivileges) {
            // Return result if we are only looking for a group
            return $res;
    } else {
        // Remove GRANT privilege from privs array
        $resWithoutGrant = array_diff($res, array('GRANT'));

        // Compare privilege count
        if (count($resWithoutGrant) == count($privs) - 1) {
            // User has ALL PRIVILEGES
            $userPrivs = array(
                    'ALL PRIVILEGES',
            );

            // Also check GRANT privilege
            if(array_search('GRANT', $res) !== false) {
                    $userPrivs[] = 'GRANT';
            }

            return $userPrivs;
        } else {
            // User doesn't have ALL PRIVILEGES
            return $res;
        }
    }
}

function getGlobalDbPrivilegeColumn($priv) {
        switch($priv) {
                case 'SHOW DATABASES':
                        return 'Show_db_priv';
                case 'CREATE TEMPORARY TABLES':
                        return 'Create_tmp_table_priv';
                case 'REPLICATION SLAVE':
                        return 'Repl_slave_priv';
                case 'REPLICATION CLIENT':
                        return 'Repl_client_priv';
                default:
                        return ucfirst(strtolower(str_replace(' ', '_', $priv))) . '_priv';
        }
}

function getDbPrivilegesList($group = null) {
        $privs = array(
            'data' => array(
                'SELECT' => null,
                'INSERT' => null,
                'UPDATE' => null,
                'DELETE' => null,
            ),
            'structure' => array(
                'CREATE' => null,
                'ALTER' => null,
                'INDEX' => null,
                'DROP' => null,
                'CREATE TEMPORARY TABLES' => null,
                'SHOW VIEW' => null,
                'CREATE ROUTINE' => null,
                'ALTER ROUTINE' => null,
                'EXECUTE' => null,
                'CREATE VIEW' => null,
            ),
            'administration' => array(
                'GRANT' => null,
                'LOCK TABLES' => null,
                'REFERENCES' => null,
            )
        );

        if ($group) {
                return $privs[$group];
        } else {
                return array_merge($privs['data'], $privs['structure'], $privs['administration']);
        }
}

function getDbPrivileges($userData, $group = null) {
        $res = array();

        $privs = array_keys(getDbPrivilegesList($group));

        foreach($privs AS $priv) {
                if ($userData[getDbPrivilegeColumn($priv)] == 'Y') {
                        $res[] = $priv;
                }
        }

        if (count($res) == count($privs)) {
                return array(
                        'ALL PRIVILEGES',
                );
        } else {
                return $res;
        }
}

function getDbPrivilegeColumn($priv) {
        switch($priv) {
                case 'CREATE TEMPORARY TABLES':
                        return 'Create_tmp_table_priv';
                default:
                        return ucfirst(strtolower(str_replace(' ', '_', $priv))) . '_priv';
        }
}
