<?php

class Dbtech_Neikos_Google_Client extends Google_Client {
    protected $_base_path = 'https://apps-apis.google.com/a/feeds';

    public function getBasePath()
    {
        return $this->_base_path;
    }

    public function execute($request)
    {
        if ($request instanceof Google_Http_Request) {
            $request->setUserAgent(
                $this->getApplicationName()
                . " " . self::USER_AGENT_SUFFIX
                . $this->getLibraryVersion()
            );
            if (!$this->getClassConfig("Google_Http_Request", "disable_gzip")) {
                $request->enableGzip();
            }
            $request->maybeMoveParametersToBody();

            return Dbtech_Neikos_Google_Http_REST::execute($this, $request);
        } else if ($request instanceof Google_Http_Batch) {
            return $request->execute();
        } else {
            throw new Google_Exception("Do not know how to execute this type of object.");
        }
    }
}