<?php

class Dbtech_Neikos_Google_Http_REST extends Google_Http_REST {
    /**
     * Metodo copiato per esigenze di funzionamento.
     *
     * @param Google_Client $client
     * @param Google_Http_Request $req
     * @return mixed
     */
    public static function execute(Google_Client $client, Google_Http_Request $req)
    {
        $runner = new Google_Task_Runner(
            $client,
            sprintf('%s %s', $req->getRequestMethod(), $req->getUrl()),
            array(get_class(), 'doExecute'),
            array($client, $req)
        );

        return $runner->run();
    }

    /**
     * Metodo copiato per esigenze di funzionamento.
     *
     * @param Google_Client $client
     * @param Google_Http_Request $req
     * @return NULL
     */
    public static function doExecute(Google_Client $client, Google_Http_Request $req)
    {
        $httpRequest = $client->getIo()->makeRequest($req);
        $httpRequest->setExpectedClass($req->getExpectedClass());
        return self::decodeHttpResponse($httpRequest, $client);
    }


    public static function decodeHttpResponse($response, Google_Client $client = null)
    {
        $code = $response->getResponseHttpCode();
        $body = $response->getResponseBody();
        $decoded = null;

        if ((intVal($code)) >= 300) {
            $ris = preg_match("/<H1>(.*)<\/H1>/i", $body, $matches);
            if ($ris != false) {
                $err = $matches[1];
            } else {
                $err = "Errore";
            }
            $errors = $body;

            $map = null;
            if ($client) {
                $client->getLogger()->error(
                    $err,
                    array('code' => $code, 'errors' => $errors)
                );

                $map = $client->getClassConfig(
                    'Google_Service_Exception',
                    'retry_map'
                );
            }
            throw new Google_Service_Exception($err, $code, null, $errors, $map);
        }

        if ($code != '204') {
            if ($response->getExpectedRaw()) {
                return $body;
            }

            $decoded = self::_decodeXML($body);
            if ($decoded === null || $decoded === "") {
                $error = "Invalid XML in service response: $body";
                if ($client) {
                    $client->getLogger()->error($error);
                }
                throw new Google_Service_Exception($error);
            }

            if ($response->getExpectedClass()) {
                $class = $response->getExpectedClass();
                $decoded = new $class($decoded);
            }
        }

        return $decoded;
    }

    protected static function _decodeXML($xml) {
        $ret = array();

        $dom = new DOMDocument();
        $dom->loadXML($xml);

        $properties = $dom->getElementsByTagName("property");
        if ($properties instanceof DOMNodeList) {
            foreach ($properties as $property) {
                $name = $property->getAttribute("name");
                $value = $property->getAttribute("value");

                $ret[$name] = $value;
            }
        }

        return $ret;
    }
}