<?php

/**
 * Classe per le chiamate alle Admin Settings API.
 * https://developers.google.com/admin-sdk/admin-settings/
 *
 * ATTENZIONE: la classe non contiene tutti i metodi possibili per le API, ma solo quelli usati
 *
 * @author Agostino Pagnozzi
 */
class Dbtech_Neikos_Google_Service_AdminSettings extends Google_Service {
    const DOMAIN = 'https://apps-apis.google.com/a/feeds/domain/';

    public $emailrouting;
    public $emailgateway;

    public function __construct($client) {
        parent::__construct($client);

        $this->servicePath = 'domain/2.0/';
        $this->version = '2.0';
        $this->serviceName = 'emailrouting';

        // Email routing:
        $this->emailrouting = new Dbtech_Neikos_Google_Service_AdminSettings_EmailRouting_Resource(
            $this,
            $this->serviceName,
            'emailrouting',
            array(
                'methods' => array(
                    'get' => array(
                        'path' => '{domainName}/emailrouting',
                        'httpMethod' => 'GET',
                        'parameters' => array(
                            'domainName' => array(
                                'location' => 'path',
                                'type' => 'string',
                                'required' => true,
                            )
                        ),
                    ),
                )
            )
        );

        $this->emailgateway = new Dbtech_Neikos_Google_Service_AdminSettings_EmailGateway_Resource(
            $this,
            $this->serviceName,
            'emailgateway',
            array(
                'methods' => array(
                    'get' => array(
                        'path' => '{domainName}/email/gateway',
                        'httpMethod' => 'GET',
                        'parameters' => array(
                            'domainName' => array(
                                'location' => 'path',
                                'type' => 'string',
                                'required' => true,
                            )
                        ),
                    ),
                )
            )
        );
    }
}


class Dbtech_Neikos_Google_Service_AdminSettings_EmailRouting_Resource extends Google_Service_Resource {
    public function get($domainName) {
        $params = array('domainName' => $domainName, $optParams = array());
        $params = array_merge($params, $optParams);
        return $this->call('get', array($params), "Dbtech_Neikos_Google_Service_AdminSettings_EmailRouting");
    }
}


class Dbtech_Neikos_Google_Service_AdminSettings_EmailGateway_Resource extends Google_Service_Resource {
    public function get($domainName) {
        $params = array('domainName' => $domainName, $optParams = array());
        $params = array_merge($params, $optParams);
        return $this->call('get', array($params), "Dbtech_Neikos_Google_Service_AdminSettings_EmailGateway");
    }
}


class Dbtech_Neikos_Google_Service_AdminSettings_EmailRouting extends Dbtech_Neikos_Google_Model {
    /**
     * @var boolean
     */
    public $routeDestination;

    /**
     * @var boolean
     */
    public $routeRewriteTo;

    /**
     * @var boolean
     */
    public $routeEnabled;

    /**
     * @var boolean
     */
    public $bounceNotifications;

    /**
     * Valori possibili:
     *      allAccounts
     *      provisionedAccounts
     *      unknownAccounts
     *
     * @var string
     */
    public $accountHandling;

    /**
     * Variabili booleane
     * @var array
     */
    protected $_boolean_property_name = array(
        "routeDestination", "routeRewriteTo", "routeEnabled", "bounceNotifications"
    );
}


class Dbtech_Neikos_Google_Service_AdminSettings_EmailGateway extends Dbtech_Neikos_Google_Model {
    /**
     * L'indirizzo IP o il nome host di un server SMTP esterno, a cui
     * Google Apps gira le email in uscita.
     *
     * @var string
     */
    public $smartHost;

    /**
     * Valori possibili:
     *      SMTP
     *      SMTP_TLS
     *
     * @var string
     */
    public $smtpMode;
}
