<?php

/**
 * Classe per le chiamate alle Email Settings API.
 * https://developers.google.com/admin-sdk/email-settings/
 *
 * ATTENZIONE: la classe non contiene tutti i metodi possibili per le API, ma solo quelli usati
 *
 * @author Agostino Pagnozzi
 */
class Dbtech_Neikos_Google_Service_EmailSettings extends Google_Service {
    const EMAILSETTINGS = 'https://apps-apis.google.com/a/feeds/emailsettings/2.0/';

    public $forwarding;
    public $vacation;
    public $sendas;

    public function __construct($client) {
        parent::__construct($client);

        $this->servicePath = 'emailsettings/2.0/';
        $this->version = '2.0';
        $this->serviceName = 'emailsettings';

        // Forwarding:
        $this->forwarding = new Dbtech_Neikos_Google_Service_EmailSettings_Forwarding_Resource(
            $this,
            $this->serviceName,
            'forwarding',
            array(
                'methods' => array(
                    'get' => array(
                        'path' => '{domainName}/{username}/forwarding',
                        'httpMethod' => 'GET',
                        'parameters' => array(
                            'domainName' => array(
                                'location' => 'path',
                                'type' => 'string',
                                'required' => true,
                            ),
                            'username' => array(
                                'location' => 'path',
                                'type' => 'string',
                                'required' => true,
                            )
                        ),
                    ),
                )
            )
        );

        // Vacation-Responder:
        $this->vacation = new Dbtech_Neikos_Google_Service_EmailSettings_Vacation_Resource(
            $this,
            $this->serviceName,
            'vacation',
            array(
                'methods' => array(
                    'get' => array(
                        'path' => '{domainName}/{username}/vacation',
                        'httpMethod' => 'GET',
                        'parameters' => array(
                            'domainName' => array(
                                'location' => 'path',
                                'type' => 'string',
                                'required' => true,
                            ),
                            'username' => array(
                                'location' => 'path',
                                'type' => 'string',
                                'required' => true,
                            )
                        ),
                    ),
                )
            )
        );

        // Sand-as:
        $this->sandas = new Dbtech_Neikos_Google_Service_EmailSettings_Sandas_Resource(
            $this,
            $this->serviceName,
            'sendas',
            array(
                'methods' => array(
                    'listSandas' => array(
                        'path' => '{domainName}/{username}/sendas',
                        'httpMethod' => 'GET',
                        'parameters' => array(
                            'domainName' => array(
                                'location' => 'path',
                                'type' => 'string',
                                'required' => true,
                            ),
                            'username' => array(
                                'location' => 'path',
                                'type' => 'string',
                                'required' => true,
                            )
                        ),
                    ),
                )
            )
        );
    }
}


class Dbtech_Neikos_Google_Service_EmailSettings_Forwarding_Resource extends Google_Service_Resource {
    public function get($domainName, $username) {
        $params = array('domainName' => $domainName, 'username' => $username, $optParams = array());
        $params = array_merge($params, $optParams);
        return $this->call('get', array($params), "Dbtech_Neikos_Google_Service_EmailSettings_Forwarding");
    }
}


class Dbtech_Neikos_Google_Service_EmailSettings_Vacation_Resource extends Google_Service_Resource {
    public function get($domainName, $username) {
        $params = array('domainName' => $domainName, 'username' => $username, $optParams = array());
        $params = array_merge($params, $optParams);
        return $this->call('get', array($params), "Dbtech_Neikos_Google_Service_EmailSettings_Vacation");
    }
}


class Dbtech_Neikos_Google_Service_EmailSettings_Sandas_Resource extends Google_Service_Resource {
    public function get($domainName, $username) {
        $params = array('domainName' => $domainName, 'username' => $username, $optParams = array());
        $params = array_merge($params, $optParams);
        return $this->call('get', array($params), "Dbtech_Neikos_Google_Service_EmailSettings_Sandas");
    }
}


class Dbtech_Neikos_Google_Service_EmailSettings_Forwarding extends Google_Model {
    public $enable;
    public $forwardTo;

    /**
     * Azione da eseguire
     *
     * Possibili valori:
     *      KEEP - Emails are left in the inbox.
     *      ARCHIVE - Emails are archived, and, by default, are not visible in the inbox.
     *      DELETE - When deleted, emails are moved to the Spam folder.
     *      MARK_READ - Emails are marked as read in the inbox.
     *
     * @var string
     */
    public $action;

    protected function gapiInit() {
        if ($this->enable == "true") {
            $this->enable = true;
        } elseif ($this->enable == "false") {
            $this->enable = false;
        }
    }
}


class Dbtech_Neikos_Google_Service_EmailSettings_Vacation extends Dbtech_Neikos_Google_Model {
    /**
     * @var boolean
     */
    public $enable;

    /**
     * @var string
     */
    public $subject;

    /**
     * @var string
     */
    public $message;

    /**
     * @var boolean
     */
    public $contactsOnly;

    /**
     * @var boolean
     */
    public $domainOnly;

    /**
     * Data di inizio nel formato Y-m-d
     * @var string
     */
    public $startDate;

    /**
     * Data di fine nel formato Y-m-d
     * @var string
     */
    public $endDate;

    /**
     * Variabili booleane
     * @var array
     */
    protected $_boolean_property_name = array(
        "enable", "contactsOnly", "domainOnly"
    );
}


class Dbtech_Neikos_Google_Service_EmailSettings_Sandas extends Dbtech_Neikos_Google_Model {
    /**
     * TODO: questo model deve essere ancora sviluppato...
     */
    protected function _gapiInit() {
        throw new Exception("Not implemented yet.");
    }
}


