<?php

/**
 * Legge i dati per ricavare le informazioni che riguardano
 * gli account di posta su Google Apps di Neikos come reseller.
 *
 * @author      Agostino Pagnozzi
 * @copyright   2015 Neikos s.n.c.
 * @link        http://www.neikos.it
 * @version     1.0
 */

/**
 * L'app creata sulla console developer di Google (con l'account support@reseller.neikos.it)
 * deve avere le seguenti API attive:
 *      Google Apps Reseller API
 *      Drive API
 *      Admin SDK
 *
 * Sull'account reseller occorre impostare le seguenti autorizzazioni all'app:
 *      https://www.googleapis.com/auth/apps.order
 *      https://www.googleapis.com/auth/apps.order.readonly
 *      https://www.googleapis.com/auth/admin.directory.user.readonly
 *      https://www.googleapis.com/auth/admin.directory.group.readonly
 *      https://www.googleapis.com/auth/admin.directory.group.member.readonly
 *
 * Sul singolo dominio occorre andare in:
 *      Sicurezza > Riferimento API > Accesso API
 * e spuntare "Attiva accesso API".
 *
 * Inoltre in:
 *      Sicurezza > Impostazioni avanzate > Gestisci accesso client API
 * occorre specificare per il clientId dell'app (nome client) le seguenti autorizzazioni
 * separate da virgola:
 *
 *      https://www.googleapis.com/auth/drive.metadata.readonly
 *      https://apps-apis.google.com/a/feeds/emailsettings/2.0/
 */

// --------------------------------------------------------------------------------------------------
// Attiva il debugging a video:
// --------------------------------------------------------------------------------------------------
$debug = false;
// --------------------------------------------------------------------------------------------------

// Librerie:
require_once(realpath(dirname(__FILE__) . "/functions.php"));
require_once(realpath(dirname(__FILE__) . "/../class/Google/autoload.php"));
require_once(realpath(dirname(__FILE__) . "/../class/Dbtech.php"));

// Autoloader delle classi del dbtech:
Dbtech::registerAutoloader();

// Prende in carico l'aggiornamento:
mysql_query("UPDATE updates SET status = 'X' WHERE server_id = '" . (int)$__server_id__ . "' AND modulo='M' AND status='A'", $__db__);

// Prepara le tabelle all'aggionamento:
mysql_query("UPDATE mail SET update_status = 'X' WHERE server_id = '" . (int)$__server_id__ . "'", $__db__);
mysql_query("UPDATE mail_domains SET update_status = 'X' WHERE server_id = '$__server_id__'", $__db__);

// Elimina gli alias dei domini di posta:
mysql_query("DELETE FROM mail_domains_aliases WHERE server_id = '$__server_id__'");

// Legge la chiave privata dell'app:
$privateKey = file_get_contents(realpath(dirname(__FILE__) . "/../pk/" . $__mail_private_key_file__));

// Messaggi di errore:
$errorMsg = array();

// Scopes:
$scopes = array(
    Google_Service_Reseller::APPS_ORDER,
    Google_Service_Reseller::APPS_ORDER_READONLY,
    Google_Service_Directory::ADMIN_DIRECTORY_USER_READONLY,
    Google_Service_Directory::ADMIN_DIRECTORY_GROUP_READONLY,
    Google_Service_Directory::ADMIN_DIRECTORY_GROUP_MEMBER_READONLY
);

// Credenziali di accesso:
$credentials = new Google_Auth_AssertionCredentials(
    $__mail_client_email__,
    $scopes,
    $privateKey,
    'notasecret',
    'http://oauth.net/grant_type/jwt/1.0/bearer',
    $__mail_super_admin_account__
);

// Client:
$client = new Google_Client();
$client->setAssertionCredentials($credentials);
if ($client->getAuth()->isAccessTokenExpired()) {
    $client->getAuth()->refreshTokenWithAssertion();
}

// Api:
$resellerApi = new Google_Service_Reseller($client);
$directoryApi = new Google_Service_Directory($client);

// Page token iniziale:
$subscriptionPageToken = null;

// Customer trovati:
$customerDataArray = array();

if ($debug) {
    echo str_repeat("-", 80) . "\n";
    echo "NEIKOS - GOOGLE APPS RESELLER DATA\n";
    echo str_repeat("-", 80) . "\n\n";
}

// A partire dalla subscriptions prende tutti i customer associati
// al reseller.
do {
    // Lista delle subscriptions:
    try {
        $request = $resellerApi->subscriptions->listSubscriptions(array(
            "maxResults"    => 100,
            "pageToken"     => $subscriptionPageToken
        ));
    } catch(Google_Service_Exception $ex) {
        break;
    }

    $subscriptionList = $request->subscriptions;
    $subscriptionPageToken = $request->nextPageToken;

    if (count($subscriptionList) > 0) {
        foreach ($subscriptionList as $subscriptionData) {
            // Dati della subscription:
            $subscriptionStatus = $subscriptionData->status;
            $customerId = $subscriptionData->customerId;

            // Cliente relativo alla subscription:
            if (!isset($customerDataArray[$customerId])) {
                try {
                    $customerData = $resellerApi->customers->get($customerId);
                    $customerDataArray[$customerId] = $customerData;
                } catch(Google_Service_Exception $ex) {
                    // ERRORE: richiesta dati del customer non riuscita:
                    $errorMsg[] = sprintf("CUSTOMER '%s': impossibile accedere ai dati", $customerId);
                }
            }
        }
    } else {
        break;
    }
} while ($subscriptionPageToken != null);


// Prende la lista dei customer e per ogni customer prende i dati
// degli utenti associati:
if (count($customerDataArray) > 0) {
    foreach ($customerDataArray as $customerData) {
        // Dati del customer:
        $customerDomain = $customerData->customerDomain;
        $customerKind   = $customerData->kind;

        // Verifica che il dominio di posta esista:
        $risDom = mysql_query("SELECT `id` FROM `mail_domains` WHERE `name` = '" . mysql_real_escape_string($customerDomain) . "' AND `server_id` = '" . (int)$__server_id__ . "'", $__db__);
        if (mysql_num_rows($risDom) > 0) {
            // Id del dominio:
            list($mail_domains_id) = mysql_fetch_row($risDom);
        } else {
            // Inserisce il dominio:
            mysql_query("INSERT INTO `mail_domains` (`name`, `server_id`)
                         VALUES ('" . mysql_real_escape_string($customerDomain) . "', '" . (int)$__server_id__ . "')", $__db__);

            // Prende l'id del dominio di posta appena inserito:
            $mail_domains_id = mysql_insert_id();
        }

        // Aggiorna il dominio:
        mysql_query("UPDATE `mail_domains` SET `last_update` = NOW(), `update_status` = 'A' WHERE `id` = '" . (int)$mail_domains_id  . "'", $__db__);

        if ($debug) {
            echo "\t- " . $customerDomain . "\n";
        }

        // UTENTI:
        $dirPageToken = null;
        do {
            try {
                $usersList = $directoryApi->users->listUsers(array(
                    "domain"        => $customerDomain,
                    "maxResults"    => 100,
                    "pageToken"     => $dirPageToken
                ));
            } catch (Google_Service_Exception $ex) {
                // ERRORE: Accesso alle Directory API non riuscito:
                $errorMsg[] = sprintf("DOMAIN '%s': autorizzazioni API necessarie.", $customerDomain);

                continue 2;
            }

            // Token:
            $dirPageToken = $usersList->nextPageToken;

            if (count($usersList->users) > 0) {
                foreach ($usersList->users as $userData) {
                    // Dati dell'utente:
                    $userEmail      = $userData['primaryEmail'];
                    $userAliases    = $userData['aliases'];
                    $userIsAdmin    = $userData['isAdmin'];

                    // Stato dell'utente:
                    $userIsSuspended = $userData['suspended'];
                    $isMailboxSetup  = $userData['isMailboxSetup'];

                    $userStatus = "A";
                    if ($userIsSuspended) {
                        $userStatus = "S";
                    } elseif (!$isMailboxSetup) {
                        $userStatus = "N";
                    }

                    // Nota automatica:
                    $info = null;
                    if ($userIsAdmin) {
                        $info = "Admin di dominio";
                    }

                    if ($debug) {
                        echo "\t\t- (EMAIL) " . $userEmail . "\n";
                        echo $userIsAdmin ? "\t\t\t- Admin\n" : "";
                    }

                    // Alias:
                    if (!empty($userAliases)) {
                        if ($debug) {
                            echo (is_array($userAliases) ? "\t\t\t- Alias: " . implode(", ", $userAliases) . "\n" : "");
                        }
                    }

                    // Per ogni utente prende i dati di forward e autorisponditore dalle Google Apps Email Settings API:
                    $settings = getUserAccountSettings($userEmail, $__mail_client_email__, $privateKey, $errorMsg);
                    if ($settings !== false) {
                        if (!empty($settings['forward'])) {
                            if ($debug) {
                                echo "\t\t\t- Forward: " . $settings['forward'] . "\n";
                            }
                        }
                        if ($settings['autoresponder']) {
                            if ($debug) {
                                echo "\t\t\t- Autorisponditore attivo\n";
                            }
                        }
                    }

                    // Per ogni utente prende i dati statistici dalle Drive API:
                    $quota = getUserAccountQuota($userEmail, $__mail_client_email__, $privateKey, $errorMsg);
                    if ($quota !== false) {
                        if ($debug) {
                            echo "\t\t\t- Quota: " . round($quota["usata"] / 1024 / 1024 / 1024, 2) . " / " . round($quota["totale"] / 1024 / 1024 / 1024, 2) . " Gb\n";
                        }
                    }

                    // Esplode l'email in utente e dominio:
                    list($userEmailUser, $userEmailDomain) = explode("@", $userEmail, 2);

                    // Verifica se l'utente è già presente:
                    $risMail = mysql_query("SELECT `id` FROM `mail` WHERE `user` = '" . mysql_real_escape_string($userEmailUser) . "' AND `server_id` = '" . (int)$__server_id__ . "' AND mail_domains_id = '" . (int)$mail_domains_id . "'", $__db__);
                    if (mysql_num_rows($risMail) > 0) {
                        // Id dell'utente:
                        list($mail_id) = mysql_fetch_row($risMail);
                    } else {
                        // Inserisce l'utente:
                        mysql_query("INSERT INTO `mail` (`user`, `pw`, `server_id`, `mail_domains_id`)
                                     VALUES ('" . mysql_real_escape_string($userEmailUser) . "', '*****', '" . (int)$__server_id__ . "', '" . (int)$mail_domains_id . "')", $__db__);

                        // Prende l'id del dominio di posta appena inserito:
                        $mail_id = mysql_insert_id();
                    }

                    // Aggiorna i dati dell'utente:
                    mysql_query("UPDATE `mail` SET `type` = 'A',
                                                   `alias` = '" . (count($userAliases) > 0 ? mysql_real_escape_string(implode(", ", $userAliases)) : "") . "',
                                                   `forward` = '" . mysql_real_escape_string($settings['forward']) . "',
                                                   `quota_ass` = '" . $quota["totale"] . "',
                                                   `quota_occ` = '" . (($quota["usata"] > 0) ? round($quota["usata"] / 1024 / 1024 / 1024, 2) . " Gb": "") . "',
                                                   `autoresponder` = '" . ($settings['autoresponder'] ? "A" : "D") . "',
                                                   `status` = '" . $userStatus . "',
                                                   `info` = " . (empty($info) ? "NULL" : "'" . mysql_real_escape_string($info) . "'") . ",
                                                   `last_update` = NOW(),
                                                   `update_status` = 'A'
                                 WHERE `id` = '" . (int)$mail_id . "'", $__db__);
                }
            }
        } while ($dirPageToken != null);


        // GRUPPI:
        $dirPageToken = null;
        do {
            $groupsList = $directoryApi->groups->listGroups(array(
                "domain"        => $customerDomain,
                "maxResults"    => 100,
                "pageToken"     => $dirPageToken
            ));

            // Token:
            $dirPageToken = $groupsList->nextPageToken;

            if (count($groupsList->groups) > 0) {
                foreach ($groupsList->groups as $groupData) {
                    // Dati dell'utente:
                    $groupId         = $groupData['id'];
                    $groupEmail      = $groupData['email'];
                    $groupAliases    = $groupData['aliases'];
                    $groupForwards   = array();

                    // Membri del gruppo (forward):
                    do {
                        $membersList = $directoryApi->members->listMembers($groupId, array(
                            "maxResults" => 100,
                            "pageToken"  => $dirPageToken
                        ));

                        // Token:
                        $groupPageToken = $membersList->nextPageToken;

                        if (count($membersList) > 0) {
                            foreach ($membersList as $memberData) {
                                $groupForwards[] = $memberData['email'];
                            }
                        } else {
                            break;
                        }
                    } while ($groupPageToken != null);

                    if ($debug) {
                        echo "\t\t- (GRUPPO) " . $groupEmail . "\n";
                        echo (is_array($groupAliases) ? "\t\t\t- Alias: " . implode(", ", $groupAliases) . "\n" : "");
                        echo (is_array($groupForwards) ? "\t\t\t- Forward: " . implode(", ", $groupForwards) . "\n" : "");
                    }

                    // Esplode l'email in utente e dominio:
                    list($groupEmailUser, $groupEmailDomain) = explode("@", $groupEmail, 2);

                    // Verifica se la lista è già presente:
                    $risMail = mysql_query("SELECT `id` FROM `mail` WHERE `user` = '" . mysql_real_escape_string($groupEmailUser) . "' AND `server_id` = '" . (int)$__server_id__ . "' AND mail_domains_id = '" . (int)$mail_domains_id . "'", $__db__);
                    if (mysql_num_rows($risMail) > 0) {
                        // Id dell'utente:
                        list($mail_id) = mysql_fetch_row($risMail);
                    } else {
                        // Inserisce l'utente:
                        mysql_query("INSERT INTO `mail` (`user`, `pw`, `server_id`, `mail_domains_id`)
                                     VALUES ('" . mysql_real_escape_string($groupEmailUser) . "', '*****', '" . (int)$__server_id__ . "', '" . (int)$mail_domains_id . "')", $__db__);

                        // Prende l'id del dominio di posta appena inserito:
                        $mail_id = mysql_insert_id();
                    }

                    // Aggiorna i dati dell'utente:
                    mysql_query("UPDATE `mail` SET `type` = 'L',
                                                   `alias` = '" . (count($groupAliases) > 0 ? mysql_real_escape_string(implode(", ", $groupAliases)) : "") . "',
                                                   `forward` = '" . (count($groupForwards) > 0 ? mysql_real_escape_string(implode(", ", $groupForwards)) : "") . "',
                                                   `quota_ass` = '',
                                                   `quota_occ` = '',
                                                   `autoresponder` = 'D',
                                                   `status` = 'A',
                                                   `last_update` = NOW(),
                                                   `update_status` = 'A'
                                 WHERE `id` = '" . (int)$mail_id . "'", $__db__);
                }
            }
        } while ($dirPageToken != null);
    }
}

// Richiesta completata:
if ($debug) {
    echo "\nRichiesta completata\n\n";
}

// Messaggi di errori univoci (rimuove i duplicati):
$errorMsg = array_unique($errorMsg);

if (count($errorMsg) > 0) {
    // Invia l'email con i dati dell'errore:
    sendErrorEmail($__mail_error_reporting_email__, $errorMsg, $__mail_client_id__);

    if ($debug) {
        echo str_repeat("-", 40) . "\n";
        echo "ERRORI:\n";
        echo str_repeat("-", 40) . "\n";
        foreach ($errorMsg as $e) {
            echo "\t- " . $e . "\n";
        }
        echo "\n";
    }
}

// Elimina i record non aggiornati:
mysql_query("DELETE FROM mail WHERE update_status = 'X' AND server_id = '$__server_id__'", $__db__);
mysql_query("DELETE FROM mail_domains WHERE update_status = 'X' AND server_id = '$__server_id__'", $__db__);

// "Spegne" l'aggiornamento manuale (aggiornamento richiamato tramite interfaccia):
mysql_query("UPDATE updates SET status = 'D' WHERE server_id = '" . (int)$__server_id__ . "' AND modulo='M' AND status='X'", $__db__);

if (mysql_affected_rows($__db__) == 0) {
    // Inserisce l'aggiornamento effettuato (aggiornamento non richiamato tramite interfaccia):
    mysql_query("INSERT INTO updates (id, server_id, modulo, status, data_ins) VALUES ('', '" . (int)$__server_id__ . "', 'M', 'D', NOW())", $__db__);
}
