<?php

/**
 * File di funzioni.
 *
 * @author      Agostino Pagnozzi
 * @copyright   2008 Neikos s.n.c.
 * @link        http://www.neikos.it
 * @version     1.0
 */

// Salva domini e alias:
function gestVirtualHost($virtualHost) {
        global $__server_id__, $__db__, $__server_ips__;

        // Spazio occupato dal dominio:
        $spazio = spazio_occupato($virtualHost["documentroot"]);

        // IP e porta:
        $IP_Port = $virtualHost["ip_port"];

        // Se esiste un ServerName:
        if (null !== $virtualHost["servername"]) {
                // Server Alias:
                $domini = $virtualHost["serveralias"];

                // Aggiunge il ServerName in testa alla lista degli alias:
                array_unshift($domini, $virtualHost["servername"]);

                // Resetta il parent per il ServerName che  sempre in cima alla lista:
                $parent = 0;
                $parent_project = 0;

                foreach ($domini as $nomeDominio) {
                        // IP reale del dominio:
                        $realIP = real_IP($nomeDominio);

                        // Setta lo stato iniziale a OK:
                        $stato = __STATO_OK__;
                        $alert = "";

                        // Controlla che l'IP appartenga a questo server:
                        if ($realIP != "") {
                                if (!in_array($realIP, $__server_ips__)) {
                                        $stato = __STATO_ALERT__;
                                        $alert .= "- L'indirizzo IP del dominio non rientra tra quelli del server\n";
                                }
                        } else {
                                $stato = __STATO_ALERT__;
                                $alert .= "- E' impossibile risolvere l'host\n";
                        }

                        // Stringa per settare nel db il parent:
                        if ($parent == 0) {
                                $parent_string = "NULL";

                                // se il progetto  un progetto padre
                                // non aggiorna cliente:
                                $project_string = "NULL";
                                $project_update_string = "";
                        } else {
                                $parent_string = "'" . (int)$parent . "'";
                                if ($parent_project <= 0) {
                                        $project_string = "NULL";
                                        $project_update_string = "";
                                } else {
                                        $project_string = "'" . (int)$parent_project . "'";
                                        $project_update_string = "project_id = " . $project_string . ", ";
                                }
                        }

                        // Controlla che non sia gi presente (nome dominio + server).
                        $query = "SELECT * FROM domains WHERE name = '" . mysql_escape_string($nomeDominio) . "' AND server_id = '" . $__server_id__ . "'";
                        $ris = mysql_query($query);

                        if (mysql_num_rows($ris)>0) {
                                // Controlla se  cambiato il server o il parent:
				$row = mysql_fetch_assoc($ris);
				$notifica = "";
                                if ($row["server_id"] != $__server_id__) {
                                        $notifica .= "- E' cambiato il server (vecchio: #" . $row["server_id"] . ")\n";
                                }
                                if ((int)$row["parent_id"] != (int)$parent) {
                                        $notifica .= "- E' cambiata la composizione del virtualhost (ServerName, ServerAlias)\n";
                                }
                                if ($row["real_ip"] != $realIP) {
                                        $notifica .= "- E' cambiato l'indirizzo IP (vecchio: " . $row["real_ip"] . ")\n";
                                }
				if (!empty($notifica))
				{
					mysql_query("INSERT INTO notice (domain_id, note, date) VALUES ('".$row["id"]."', '".mysql_escape_string($notifica)."', NOW())", $__db__);
				}

                                // Aggiorna i dati:
                                mysql_query("UPDATE domains SET " . $project_update_string  . " parent_id = " . $parent_string . ", last_update = NOW(),
                                                        server_id = '" . $__server_id__ . "', ip_port = '" . $IP_Port . "',
                                                        real_ip = '" . $realIP . "', status = '" . $stato . "',
                                                        update_status = 'A', spazio = '" . $spazio . "',
                                                        alert = '" . mysql_escape_string($alert) . "' WHERE
                                                        id = '" . (int)$row["id"] . "'", $__db__);

                                if ($parent == 0) {
                                        // Setta il parent per i prossimi serveralias:
                                        $parent = $row["id"];
                                        $parent_project = $row["project_id"];
                                }
                        } else {
                                // Inserisce i nuovi dati:
                                mysql_query("INSERT INTO domains (name, project_id, parent_id, last_update, server_id, ip_port, real_ip, status, update_status, spazio, alert) VALUES ('" . mysql_escape_string($nomeDominio) . "', " . $project_string . ", " . $parent_string . ", NOW(), '" . $__server_id__ . "', '" . $IP_Port . "', '" . $realIP . "', '" . $stato . "', 'A', '" . $spazio  . "', '" . mysql_escape_string($alert) . "')", $__db__);

                                if ($parent == 0) {
                                        // Setta il parent per i prossimi serveralias:
                                        $parent = mysql_insert_id($__db__);
                                        $parent_project = 0;
                                }
                        }
                }
        }
}


// Trova l'IP del dominio:
function real_IP($dominio) {
    $dominio = trim($dominio);
       
    // Nel caso di domini tipo:
    // *.test.neikos.it, sostituisce lo * 
    // con una stringa qualsiasi non definita altrimenti.
    if (substr($dominio, 0, 2) == "*.") {
    	$dominio = "aasfdbvasfdbasd" . substr($dominio, 1);    
    }
	$ip = trim(`/usr/bin/dig $dominio A +short | /usr/bin/tail -1`);
    return $ip;
}

// Controlla la quantit di spazio occupata dalla document root:
function spazio_occupato($document_root) {
        if ($document_root == null) return "";

        $sp = trim(`du -s -h "$document_root"`);
        $p = split("[\s\t\n\r]", $sp);

        if (count($p) > 0) return $p[0];
        return $sp;
}

/**
 * Funzioni per la gestione del db.
 */
function getGlobalDbPrivilegesList($group = null) {
	$privs = array(
		'data' => array(
			'SELECT' => null,
			'INSERT' => null,
			'UPDATE' => null,
			'DELETE' => null,
			'FILE' => null,
		),
		'structure' => array(
			'CREATE' => null,
			'ALTER' => null,
			'INDEX' => null,
			'DROP' => null,
			'CREATE TEMPORARY TABLES' => null,
			'SHOW VIEW' => null,
			'CREATE ROUTINE' => null,
			'ALTER ROUTINE' => null,
			'EXECUTE' => null,
			'CREATE VIEW' => null,
		),
		'administration' => array(
			'GRANT' => null,
			'SUPER' => null,
			'PROCESS' => null,
			'RELOAD' => null,
			'SHUTDOWN' => null,
			'SHOW DATABASES' => null,
			'LOCK TABLES' => null,
			'REFERENCES' => null,
			'REPLICATION CLIENT' => null,
			'REPLICATION SLAVE' => null,
			'CREATE USER' => null,
		),
	);

	if ($group) {
		return $privs[$group];
	} else {
		return array_merge($privs['data'], $privs['structure'], $privs['administration']);
	}
}


function getGlobalDbPrivileges($userData, $group = null, $notAllPrivileges = false) {
	$res = array();

	// Retrieve all privileges
	$privs = array_keys(getGlobalDbPrivilegesList($group));

	// Check all privileges for this user
	foreach($privs AS $priv) {
		if ($userData[getGlobalDbPrivilegeColumn($priv)] == 'Y') {
			$res[] = $priv;
		}
	}

	// Return USAGE if user has no privileges
	if (count($res) == 0) {
		return array(
			'USAGE',
		);
	} elseif(count($res) == 1 && $res[0] == 'GRANT') {
		return array(
			'USAGE',
			'GRANT',
		);
	}

	if ($group || $notAllPrivileges) {
		// Return result if we are only looking for a group
		return $res;
	} else {
		// Remove GRANT privilege from privs array
		$resWithoutGrant = array_diff($res, array('GRANT'));

		// Compare privilege count
		if (count($resWithoutGrant) == count($privs) - 1) {
			// User has ALL PRIVILEGES
			$userPrivs = array(
				'ALL PRIVILEGES',
			);
			// Also check GRANT privilege
			if(array_search('GRANT', $res) !== false)
			{
				$userPrivs[] = 'GRANT';
			}
			return $userPrivs;
		} else {
			// User doesn't have ALL PRIVILEGES
			return $res;
		}
	}
}

function getGlobalDbPrivilegeColumn($priv) {
	switch($priv) {
		case 'SHOW DATABASES':
			return 'Show_db_priv';
		case 'CREATE TEMPORARY TABLES':
			return 'Create_tmp_table_priv';
		case 'REPLICATION SLAVE':
			return 'Repl_slave_priv';
		case 'REPLICATION CLIENT':
			return 'Repl_client_priv';
		default:
			return ucfirst(strtolower(str_replace(' ', '_', $priv))) . '_priv';
	}
}



function getDbPrivilegesList($group = null) {
	$privs = array(
		'data' => array(
			'SELECT' => null,
			'INSERT' => null,
			'UPDATE' => null,
			'DELETE' => null,
		),
		'structure' => array(
			'CREATE' => null,
			'ALTER' => null,
			'INDEX' => null,
			'DROP' => null,
			'CREATE TEMPORARY TABLES' => null,
			'SHOW VIEW' => null,
			'CREATE ROUTINE' => null,
			'ALTER ROUTINE' => null,
			'EXECUTE' => null,
			'CREATE VIEW' => null,
		),
		'administration' => array(
			'GRANT' => null,
			'LOCK TABLES' => null,
			'REFERENCES' => null,
		),
	);

	if($group) {
		return $privs[$group];
	} else {
		return array_merge($privs['data'], $privs['structure'], $privs['administration']);
	}
}

function getDbPrivileges($userData, $group = null) {
	$res = array();

	$privs = array_keys(getDbPrivilegesList($group));

	foreach($privs AS $priv) {
		if ($userData[getDbPrivilegeColumn($priv)] == 'Y') {
			$res[] = $priv;
		}
	}

	if (count($res) == count($privs)) {
		return array(
			'ALL PRIVILEGES',
		);
	} else {
		return $res;
	}
}

function getDbPrivilegeColumn($priv) {
	switch($priv) {
		case 'CREATE TEMPORARY TABLES':
			return 'Create_tmp_table_priv';
		default:
			return ucfirst(strtolower(str_replace(' ', '_', $priv))) . '_priv';
	}
}


if (!function_exists('str_getcsv')) {
    function str_getcsv($input, $delimiter = ',', $enclosure = '"', $escape = '\\', $eol = '\n') {
        if (is_string($input) && !empty($input)) {
            $output = array();
            $tmp    = preg_split("/".$eol."/",$input);
            if (is_array($tmp) && !empty($tmp)) {
                while (list($line_num, $line) = each($tmp)) {
                    if (preg_match("/".$escape.$enclosure."/",$line)) {
                        while ($strlen = strlen($line)) {
                            $pos_delimiter       = strpos($line,$delimiter);
                            $pos_enclosure_start = strpos($line,$enclosure);
                            if (
                                is_int($pos_delimiter) && is_int($pos_enclosure_start)
                                && ($pos_enclosure_start < $pos_delimiter)
                                ) {
                                $enclosed_str = substr($line,1);
                                $pos_enclosure_end = strpos($enclosed_str,$enclosure);
                                $enclosed_str = substr($enclosed_str,0,$pos_enclosure_end);
                                $output[$line_num][] = $enclosed_str;
                                $offset = $pos_enclosure_end+3;
                            } else {
                                if (empty($pos_delimiter) && empty($pos_enclosure_start)) {
                                    $output[$line_num][] = substr($line,0);
                                    $offset = strlen($line);
                                } else {
                                    $output[$line_num][] = substr($line,0,$pos_delimiter);
                                    $offset = (
                                                !empty($pos_enclosure_start)
                                                && ($pos_enclosure_start < $pos_delimiter)
                                                )
                                                ?$pos_enclosure_start
                                                :$pos_delimiter+1;
                                }
                            }
                            $line = substr($line,$offset);
                        }
                    } else {
                        $line = preg_split("/".$delimiter."/",$line);
   
                        /*
                         * Validating against pesky extra line breaks creating false rows.
                         */
                        if (is_array($line) && !empty($line[0])) {
                            $output[$line_num] = $line;
                        } 
                    }
                }
                return $output;
            } else {
                return false;
            }
        } else {
            return false;
        }
    }
} 


if (!function_exists("gzdecode")) {
   function gzdecode($gzdata, $maxlen=NULL) {
      #-- decode header
      $len = strlen($gzdata);
      if ($len < 20) {
         return;
      }
      $head = substr($gzdata, 0, 10);
      $head = unpack("n1id/C1cm/C1flg/V1mtime/C1xfl/C1os", $head);
      list($ID, $CM, $FLG, $MTIME, $XFL, $OS) = array_values($head);
      $FTEXT = 1<<0;
      $FHCRC = 1<<1;
      $FEXTRA = 1<<2;
      $FNAME = 1<<3;
      $FCOMMENT = 1<<4;
      $head = unpack("V1crc/V1isize", substr($gzdata, $len-8, 8));
      list($CRC32, $ISIZE) = array_values($head);
      #-- check gzip stream identifier
      if ($ID != 0x1f8b) {
         trigger_error("gzdecode: not in gzip format", E_USER_WARNING);
         return;
      }
      #-- check for deflate algorithm
      if ($CM != 8) {
         trigger_error("gzdecode: cannot decode anything but deflated streams", E_USER_WARNING);
         return;
      }
      #-- start of data, skip bonus fields
      $s = 10;
      if ($FLG & $FEXTRA) {
         $s += $XFL;
      }
      if ($FLG & $FNAME) {
         $s = strpos($gzdata, "\000", $s) + 1;
      }
      if ($FLG & $FCOMMENT) {
         $s = strpos($gzdata, "\000", $s) + 1;
      }
      if ($FLG & $FHCRC) {
         $s += 2; // cannot check
      }
      
      #-- get data, uncompress
      $gzdata = substr($gzdata, $s, $len-$s);
      if ($maxlen) {
         $gzdata = gzinflate($gzdata, $maxlen);
         return($gzdata); // no checks(?!)
      }
      else {
         $gzdata = gzinflate($gzdata);
      }
      
      #-- check+fin
      $chk = crc32($gzdata);
      if ($CRC32 != $chk) {
         trigger_error("gzdecode: checksum failed (real$chk != comp$CRC32)", E_USER_WARNING);
      }
      elseif ($ISIZE != strlen($gzdata)) {
         trigger_error("gzdecode: stream size mismatch", E_USER_WARNING);
      }
      else {
         return($gzdata);
      }
   }
}
