<?php

/**
 * Legge il file named.conf per ricavare le informazioni che riguardano
 * i dns.
 *
 * @author      Agostino Pagnozzi
 * @copyright   2008 Neikos s.n.c.
 * @link        http://www.neikos.it
 * @version     1.0
 */

// Named.conf
$source = "/var/named/run-root/etc/named.conf";

// Prende in carico l'aggiornamento:
mysqli_query($__db__, "UPDATE updates SET status = 'X' WHERE server_id = '" . (int)$__server_id__ . "' AND modulo='Dns' AND status='A'");

// Setta tutti i record in aggiornamento:
mysqli_query($__db__, sprintf("UPDATE dns SET update_status = 'X' WHERE server_id = '%d'", $__server_id__));

if (is_file($source)) {
        $handle = @fopen($source, "r");
        while (!feof($handle)) {
                 $line = fgets($handle, 2048);
                 $line = trim($line);
                 $parts = split("[ ]+", $line, 3);

                 if (count($parts) > 1) {
                        // Controlla se stiamo in una zona:
                        if ($parts[0] == "zone") {
                                // Prende il nome del dominio:
                                $nomeDominio = $parts[1];
                                $nomeDominio = str_replace(array('"', "'"), "", $nomeDominio);

                                // Salva il dominio:
                                mysqli_query($__db__, sprintf("UPDATE dns SET update_status = 'A' WHERE name = '%s' AND server_id = '%d'", $nomeDominio, $__server_id__));
                                if (mysqli_affected_rows($__db__) == 0) {
                                        @mysqli_query($__db__, sprintf("INSERT INTO dns (id, name, server_id, update_status) VALUES ('', '%s', '%d', 'A')", $nomeDominio, $__server_id__));
                                }
                        }
                 }
        }
}

// Elimina tutti quelli non trovati:
mysqli_query($__db__, sprintf("DELETE FROM dns WHERE update_status = 'X' AND server_id = '%d'", $__server_id__));

// "Spegne" l'aggiornamento manuale (aggiornamento richiamato tramite interfaccia):
mysqli_query($__db__, "UPDATE updates SET status = 'D' WHERE server_id = '" . (int)$__server_id__ . "' AND modulo = 'Dns' AND status = 'X'");
if (mysqli_affected_rows($__db__) == 0) {
	// Inserisce l'aggiornamento effettuato (aggiornamento non richiamato tramite interfaccia):
	mysqli_query($__db__, "INSERT INTO updates (id, server_id, modulo, status, data_ins) VALUES ('', '" . (int)$__server_id__ . "', 'Dns', 'D', NOW())");
}

