<?php

/**
 * Cerca una lista di software conosciuti per leggere dati sui
 * plugin installati
 *
 * @author      Agostino Pagnozzi
 * @copyright   2015 Neikos s.n.c.
 * @link        http://www.neikos.it
 * @version     1.0
 */

// Libreria:
include_once("./scripts/functions.php");
include_once("./class/Dbtech.php");

// Prende in carico l'aggiornamento:
mysqli_query($__db__, "UPDATE updates SET status = 'X' WHERE server_id = '" . (int)$__server_id__ . "' AND modulo='S' AND status='A'");

// Setta tutti i record in aggiornamento:
mysqli_query($__db__, "UPDATE `software` SET `update_status` = 'X' WHERE `server_id` = '" . (int)$__server_id__ . "' AND immesso = 'A'");


// Registra l'autoloader delle classi necessarie:
Dbtech::registerAutoloader();

// Dati dai software:
$softwareData = Dbtech_Software::loadSoftwareData();


// Scrive i dati sul dbtech:
if (count($softwareData) > 0) {
    foreach ($softwareData as $data) {
        // Dati del software:
        $users = $data['users'];
        $path = $data['path'];
        $info = $data['info'];
        $software_tipo_id = $data['tipo'];
        $plugins = $data['plugins'];

        // Cicla sugli utenti trovati:
        if (count($users) > 0) {
            foreach ($users as $user) {
                // Cerca il software sul db in base al path sul server, al tipo di software e all'utente:
                $risSoftware = mysqli_query(
                    $__db__,
                    "SELECT `id` FROM `software` WHERE
                        `server_id` = '" . (int)$__server_id__ . "' AND
                        `path` = '" . mysqli_real_escape_string($__db__, $path) . "' AND
                        `software_tipo_id`  = '" . (int)$software_tipo_id . "' AND
                        `user` = '" . mysqli_real_escape_string($__db__, $user) . "' AND
                        `info` = '" . mysqli_real_escape_string($__db__, $info) . "'"
                );

                if (mysqli_num_rows($risSoftware) > 0) {
                    // Modifica il software:
                    $rowSoftware = mysqli_fetch_assoc($risSoftware);
                    $softwareId = $rowSoftware['id'];

                    mysqli_query(
                        $__db__,
                        "UPDATE `software`
                            SET
                                `versione` = '" . mysqli_real_escape_string($__db__, $data['version']) . "',
                                `url` = '" . mysqli_real_escape_string($__db__, $data['login_url']) . "',
                                `info` = '" . mysqli_real_escape_string($__db__, $info) . "',
                                `immesso` = 'A',
                                `last_update` = '" . date("Y-m-d H:i:s") . "',
                                `update_status` = 'A',
                                `data_mod` = '" . date("Y-m-d H:i:s") . "'
                            WHERE id = '" . (int)$softwareId . "'"
                    );
                } else {
                    // Inserisce il software:
                    mysqli_query(
                        $__db__,
                        "INSERT INTO `software`
                            (`software_tipo_id`, `versione`, `user`, `server_id`, `path`, `url`, `info`, `immesso`, `last_update`, `update_status`, `data_ins`, `data_mod`)
                            VALUES
                            (
                                '" . (int)$software_tipo_id . "', '" . mysqli_real_escape_string($__db__, $data['version']) . "', '" . mysqli_real_escape_string($__db__, $user) . "',
                                '" . (int)$__server_id__ . "', '" . mysqli_real_escape_string($__db__, $path) . "', '" . mysqli_real_escape_string($__db__, $data['login_url']) . "',
                                '" . mysqli_real_escape_string($__db__, $info) . "', 'A', '" . date("Y-m-d H:i:s") . "', 'A',
                                '" . date("Y-m-d H:i:s") . "', '" . date("Y-m-d H:i:s") . "'
                            )"
                    );

                    // Prende l'id del software immesso:
                    $softwareId = mysqli_insert_id($__db__);
                }

                // Segnala le associazioni tra software e plugin in aggiornamento per quel software:
                mysqli_query($__db__, "UPDATE * FROM `software_to_plugin` SET `update_status` = 'X' WHERE `software_id` = '" . (int)$softwareId . "'");

                // Cicla sui plugin associati:
                if (count($plugins) > 0) {
                    foreach ($plugins as $plugin) {
                        $pluginId = null;

                        $risPlugins = mysqli_query(
                            $__db__,
                            "SELECT `id` FROM `software_plugin` WHERE
                                `software_tipo_id` = '" . (int)$software_tipo_id . "' AND
                                `identifier` = '" . mysqli_real_escape_string($__db__, $plugin['id']) . "'"
                        );

                        if (mysqli_num_rows($risPlugins) > 0) {
                            // Plugin trovato:
                            $rowPlugins = mysqli_fetch_assoc($risPlugins);
                            $pluginId = $rowPlugins['id'];
                        } else {
                            // Inserisce il plugin:
                            mysqli_query(
                                $__db__,
                                "INSERT INTO `software_plugin` (`software_tipo_id`, `name`, `identifier`, `data_ins`, `data_mod`)
                                    VALUES
                                    (
                                        '" . (int)$software_tipo_id . "', '" . mysqli_real_escape_string($__db__, $plugin['name']) . "',
                                        '" . mysqli_real_escape_string($__db__, $plugin['id']) . "', '" . date("Y-m-d H:i:s") . "', '" . date("Y-m-d H:i:s") . "'
                                    )"
                            );

                            // Prende l'id del plugin immesso:
                            $pluginId = mysqli_insert_id($__db__);
                        }

                        // Dati dei plugin:
                        $pluginVersion = $plugin['version'];
                        $pluginStatus = ($plugin['is_active'] ? "A" : "D");

                        // Cerca l'associazione tra plugin e software:
                        $risAssoc = mysqli_query($__db__, "SELECT * FROM `software_to_plugin` WHERE `software_id` = '" . (int)$softwareId . "' AND `software_plugin_id` = '" . (int)$pluginId . "'");
                        if (mysqli_num_rows($risAssoc) > 0) {
                            // Aggiorna l'associazione:
                            mysqli_query(
                                $__db__,
                                "UPDATE `software_to_plugin` SET
                                        `versione` = '" . mysqli_real_escape_string($__db__, $pluginVersion) . "',
                                        `status` = '" . $pluginStatus . "',
                                        `update_status` = 'A'
                                    WHERE
                                        `software_id` = '" . (int)$softwareId . "' AND
                                        `software_plugin_id` = '" . (int)$pluginId . "'"
                            );
                        } else {
                            // Inserisce l'associazione:
                            mysqli_query(
                                $__db__,
                                "INSERT INTO `software_to_plugin` (`software_id`, `software_plugin_id`, `versione`, `note`, `status`, `update_status`, `data_ins`)
                                    VALUES (
                                        '" . (int)$softwareId . "', '" . (int)$pluginId . "', '" . mysqli_real_escape_string($__db__, $pluginVersion) . "', '',
                                        '" . $pluginStatus . "', 'A','" . date("Y-m-d H:i:s") . "'
                                    )
                                "
                            );
                        }
                    }
                }

                // Cancella le associazioni tra plugin e software non trovate per quel software:
                mysqli_query($__db__, "DELETE FROM `software_to_plugin` WHERE `software_id` = '" . (int)$softwareId . "' AND `update_status` = 'X'");
            }
        } else {
            // TODO: segnala l'errore, wp senza utenti trovati...
        }
    }
}


// "Spegne" l'aggiornamento manuale (aggiornamento richiamato tramite interfaccia):
mysqli_query($__db__, "UPDATE updates SET status = 'D' WHERE server_id = '" . (int)$__server_id__ . "' AND modulo = 'S' AND status = 'X'");
if (mysqli_affected_rows($__db__) == 0) {
    // Inserisce l'aggiornamento effettuato (aggiornamento non richiamato tramite interfaccia):
    mysqli_query($__db__, "INSERT INTO updates (id, server_id, modulo, status, data_ins) VALUES ('', '" . (int)$__server_id__ . "', 'S', 'D', NOW())");
}

// Setta i record ancora in aggiornamento come non aggiornati:
mysqli_query($__db__, "UPDATE `software` SET `update_status` = 'D' WHERE `server_id` = '" . (int)$__server_id__ . "' AND `update_status` = 'X'");

