<?php

/**
 * File di funzioni.
 *
 * @author      Agostino Pagnozzi
 * @copyright   2010 Neikos s.n.c.
 * @link        http://www.neikos.it
 * @version     1.0
 */

/**
 * Trova l'IP del dominio
 *
 * @param string $dominio
 *
 * @return string
 */
function real_IP($dominio) {
    $dominio = trim($dominio);

    // Nel caso di domini tipo:
    // *.test.neikos.it, sostituisce lo *
    // con una stringa qualsiasi non definita altrimenti.
    if (substr($dominio, 0, 2) == "*.") {
        $dominio = "aasfdbvasfdbasd" . substr($dominio, 1);
    }
        $ip = trim(`/usr/bin/dig $dominio A +short | /usr/bin/tail -1`);
    return $ip;
}

/**
 * Controlla la quantità di spazio occupata dalla document root
 *
 * @param string $document_root
 *
 * @return string
 */
function spazio_occupato($document_root) {
    if ($document_root == null) return "";

    $sp = trim(`du -s -h "$document_root"`);
    $p = split("[\s\t\n\r]", $sp);

    if (count($p) > 0) return $p[0];

    return $sp;
}

/**
 * Controlla la quantita' di spazio occupata da una casella mail
 */
function spazio_occupato_mail($dominio, $user) {
    $sp = trim(`/opt/zimbra/bin/zmmailbox -z -m $user@$dominio gms -v`);
    $p = split("[\s\t\n\r]", $sp);

    if (count($p) > 0) {
        $ris = $p[0];
    } else {
        $ris = $sp;
    }

    return formatDimByte($ris);
}

/**
 * Questa funzione prende una grandezza in byte e
 * la converte formattata nella maniera più opportuna.
 */
function formatDimByte($dimensione, $formatta = true, $dec = -1) {
    if ($dec == -1) {
        $decimali = 0;
    }

    if ($formatta) {
        if ($dimensione >= 1073741824) {
            if ($dec == -1) $decimali = 2;
            return number_format($dimensione/1073741824, (int)$decimali, '.', ' ') . " GB";
        } else if ($dimensione >= 1048576) {
            if ($dec == -1) $decimali = 2;
            return number_format($dimensione/1048576, (int)$decimali, '.', ' ') . " MB";
        } else if ($dimensione >= 1024) {
            return number_format($dimensione/1024, (int)$decimali, '.', ' ') . " kB";
        } else {
            return (int)$dimensione . " B";
        }
    } else {
        return (int)$dimensione;
    }
}

