<?php

// Zend Controller Action
require_once 'Zend/Controller/Action.php';

class ClientsController extends Neikos_Controller_AdminAction {
	/**
	 * Visualizza il riepilogo dei dati di un cliente.
	 */
	public function summaryAction() {
		// Cliente:
		$client_id = $this->getRequest()->getParam('client_id');

		// Dati del cliente:
		$clients = new Clients();
		$cliente = $clients->find($client_id)->current();

		// Se il cliente non esiste...
		if ($cliente == null) {
			// ...rimanda alla home:
			return $this->_helper->redirector("index", "index");
		}

		// Dati della pagina:
		$titolo = sprintf("Riepilogo Cliente #%d", $client_id);
		$this->view->title = $titolo;
		$this->view->headTitle($titolo);
		$this->view->modulo = "Clienti";
		$this->view->cliente = $cliente;
		$this->view->editMode = false;

		// Server:
		$servers = new Servers();
		$this->view->listServers = $servers->getLista("project_id = '" . (int)$client_id . "'");

		// Domini:
		$domains = new Domains();
		$listaDomini = $domains->select()->where("project_id = ?", $client_id)->where("parent_id IS NULL OR parent_id = '0'")->order("name ASC");
		$this->view->listDomains = $domains->fetchAll($listaDomini);

		// Dns:
		$dns = new Dns();
		$listaDns = $dns->select()->where("project_id = ?", $client_id)->order("name ASC");
		$this->view->listDns = $dns->fetchAll($listaDns);

		// Mail:
		$mail = new Mail();
		$listaMail = $mail->select()->from($mail)->joinleft(array("md"=>"mail_domains"), "md.id=mail.mail_domains_id", array())
						  ->where("md.project_id = ?", $client_id)
						  ->order(array("md.name", "mail.user"));
		$this->view->listMail = $mail->fetchAll($listaMail);

		// Database:
		$database = new Database();
		$listaDatabase = $database->select()->from($database)
								  ->where("project_id = ?", $client_id)
								  ->order(array("nome"));
		$this->view->listDatabase = $database->fetchAll($listaDatabase);
		//$this->view->headScript()->appendFile("/scripts/js/database/view.js", "text/javascript");

		// FTP:
		$ftp = new Ftp();
		$listaFtp = $ftp->select()->from($ftp)
						  ->where("project_id = ?", $client_id)
						  ->order(array("user"));
		$this->view->listaFtp = $ftp->fetchAll($listaFtp);

		// Software:
		$software = new Software();
		$listaSoftware = $software->select()->where("project_id = ?", $client_id)->order("id DESC");
		$this->view->listSoftware = $software->fetchAll($listaSoftware);

		// ID del cliente:
		$this->view->id = $client_id;
	}

	/**
	 * Redirige sull'azione "view".
	 */
	public function indexAction() {
		return $this->_helper->redirector("index", "index");
	}
}

