<?php

// Zend Controller Action
require_once 'Zend/Controller/Action.php';

class DatabaseController extends Neikos_Controller_AdminAction {
	const DEF_NUM_ITEM_PER_PAGE = 25;

	protected $_filtriRicerca;
	protected $_filtriRicercaUser;
	protected $_page;
	protected $_item_per_page = self::DEF_NUM_ITEM_PER_PAGE;

	const DB_SESSION = "dbtech_db";
	const DB_USER_SESSION = "dbtech_user_db";


	protected function _getSession() {
		// Gestisce la sessione:
		$dbSession = new Zend_Session_Namespace(self::DB_SESSION);
		$dbSession->setExpirationSeconds(3600);

		return $dbSession;
	}


	protected function _getUserSession() {
		// Gestisce la sessione:
		$dbUserSession = new Zend_Session_Namespace(self::DB_USER_SESSION);
		$dbUserSession->setExpirationSeconds(3600);

		return $dbUserSession;
	}


	/**
	 * Setta i filtri di ricerca in base al POST o alla
	 * variabili contenute nella sessione.
	 */
	protected function _setFiltri() {
		$dbSession = $this->_getSession();

		// Sblocca la sessione per il suo utilizzo:
		if ($dbSession->isLocked()) {
	    	$dbSession->unLock();
		}

		// Pagina di visualizzazione:
    	$this->_page = (int)$this->getRequest()->getParam('page');

    	// Record per pagina:
    	$ipp = (int)$this->getRequest()->getParam('ipp');
    	if ($ipp > 0) {
    		$this->_item_per_page = $dbSession->item_per_page = $ipp;
    	} else {
    		if ($dbSession->item_per_page > 0) {
    			$this->_item_per_page = $dbSession->item_per_page;
    		} else {
    			$this->_item_per_page = $dbSession->item_per_page = self::DEF_NUM_ITEM_PER_PAGE;
    		}
    	}

    	// Azione da intraprendere:
		$cercaButton = $this->getRequest()->getParam('cercaButton');
    	$azzeraButton = $this->getRequest()->getParam('azzeraButton');

		if (isset($cercaButton)) { // Prende i filtri dal POST:
			// Catena di filtri per eliminare l'HTML e togliere
			// gli spazi vuoti:
			$generalFilter = new Zend_Filter();
			$generalFilter->addFilter(new Zend_Filter_StripTags())
						  ->addFilter(new Zend_Filter_StringTrim());

			$filters = array(
				"*"     	 => $generalFilter,
				"client_id"  => "Int",
				"server_id"  => "Int",
				"nome"		 => "BaseName",
			);

			$this->_filtriRicerca = new Zend_Filter_Input($filters, null, $this->getRequest()->getPost());
			$dbSession->filtriRicerca = $this->_filtriRicerca;
			$this->page = 1;
		} else if (isset($azzeraButton)) {
			// Azzera i filtri di ricerca:
			$this->_filtriRicerca = $dbSession->filtriRicerca = new Zend_Filter_Input(null, null, null);
			$this->_page = 1;
		} else {
			// Prende i filtri dalla sessione:
			if (!isset($dbSession->filtriRicerca)) {
				$dbSession->filtriRicerca = new Zend_Filter_Input(null, null, null);
			}

			$this->_filtriRicerca = $dbSession->filtriRicerca;
		}

		// Blocca l'utilizzo della sessione:
		$dbSession->lock();
	}


	protected function _setFiltriUser() {
		$dbUserSession = $this->_getUserSession();

		// Sblocca la sessione per il suo utilizzo:
		if ($dbUserSession->isLocked()) {
	    	$dbUserSession->unLock();
		}

		// Pagina di visualizzazione:
    	$this->_page = (int)$this->getRequest()->getParam('page');

    	// Record per pagina:
    	$ipp = (int)$this->getRequest()->getParam('ipp');
    	if ($ipp > 0) {
    		$this->_item_per_page = $dbUserSession->item_per_page = $ipp;
    	} else {
    		if ($dbUserSession->item_per_page > 0) {
    			$this->_item_per_page = $dbUserSession->item_per_page;
    		} else {
    			$this->_item_per_page = $dbUserSession->item_per_page = self::DEF_NUM_ITEM_PER_PAGE;
    		}
    	}

    	// Azione da intraprendere:
		$cercaButton = $this->getRequest()->getParam('cercaButton');
    	$azzeraButton = $this->getRequest()->getParam('azzeraButton');

		if (isset($cercaButton)) { // Prende i filtri dal POST:
			// Catena di filtri per eliminare l'HTML e togliere
			// gli spazi vuoti:
			$generalFilter = new Zend_Filter();
			$generalFilter->addFilter(new Zend_Filter_StripTags())
						  ->addFilter(new Zend_Filter_StringTrim());

			$filters = array(
				"*"     	  => $generalFilter,
				"database_id" => "Int",
				"server_id"   => "Int",
				"user"		  => "BaseName"
			);

			$this->_filtriRicercaUser = new Zend_Filter_Input($filters, null, $this->getRequest()->getPost());
			$dbUserSession->filtriRicerca = $this->_filtriRicercaUser;
			$this->_page = 1;
		} else if (isset($azzeraButton)) {
			// Azzera i filtri di ricerca:
			$this->_filtriRicercaUser = $dbUserSession->filtriRicerca = new Zend_Filter_Input(null, null, null);
			$this->_page = 1;
		} else {
			// Prende i filtri dalla sessione:
			if (!isset($dbUserSession->filtriRicerca)) {
				$dbUserSession->filtriRicerca = new Zend_Filter_Input(null, null, null);
			}

			$this->_filtriRicercaUser = $dbUserSession->filtriRicerca;
		}

		// Prende tutti i database associati ad un certo server:
		$this->_filtriRicercaUser->selectDatabase = Database::getListaDbForSelect(array(
			"server_id" => $this->_filtriRicercaUser->server_id
		));

		// Blocca l'utilizzo della sessione:
		$dbUserSession->lock();
	}


	/**
	 * Redirige sull'azione "view".
	 */
	public function indexAction() {
		$this->_forward("view");
	}


	public function viewAction() {
		// Setta i filtri di ricerca:
    	$this->_setFiltri();

		// Classe dei domini gestiti:
    	$database = new Database();
		$database->setFiltri($this->_filtriRicerca);

		// Clienti:
		$clients = new Clients();

		// Server:
		$servers = new Servers();

		// Dati della pagina:
		$this->view->title = "Lista database";
		$this->view->headTitle("Lista database");
		$this->view->headScript()->appendFile("/scripts/js/scriptaculous/scriptaculous.js", "text/javascript")
								 ->appendFile("/scripts/js/database/view.js", "text/javascript")
								 ->appendFile("/scripts/js/view.js", "text/javascript");

		$this->view->modulo = "Database";

		$this->view->database = $database->getPage($this->_page, $this->_item_per_page);
		$this->view->filtriRicerca = $this->_filtriRicerca;
		$this->view->listaClientiAttivi = $clients->fetchAll($clients->select()->from($clients, array("ID", "name"))->where("kategorie != 5")->where("parent = '0'")->order("name ASC"));
		$this->view->listaClientiFermati = $clients->fetchAll($clients->select()->from($clients, array("ID", "name"))->where("kategorie = 5")->where("parent = '0'")->order("name ASC"));
		$this->view->listaServerForSelect = $database->listaServerForSelect();

		// Helper per il paginatore:
		$this->view->pagination_config = array(
		    'total_items'    => $database->count(),
            'items_per_page' => $this->_item_per_page,
            'style'          => 'default'
       	);
	}


	/**
     * Salva il cliente associato ad un database.
     */
    public function saveclientsAction() {
    	// Disattiva il layout in questa azione:
    	$this->_helper->layout()->disableLayout();

    	// Fa passare solo le richiesta asincrone.
    	if (!$this->getRequest()->isXmlHttpRequest()) {
    		return $this->_helper->redirector('index', 'index');
        }

    	// Dati del cliente e del database:
    	$database_id = (int)$this->getRequest()->getParam('database_id', null);
    	$client_id 	= $this->getRequest()->getParam('client_id', null);

    	// Istanzia l'oggetto database:
    	$database = new Database();

    	// Prende il database corrente:
    	$rowset = $database->find($database_id);
    	if ($rowset > 0) {
    		$row = $rowset->current();
    		$row->project_id = ($client_id>0) ? $client_id : null;
    		$row->save();
    	}

    	$this->_helper->AjaxContext();
    }


	/**
     * Salva il software associato ad un database.
     */
    public function savesoftwareAction() {
    	// Disattiva il layout in questa azione:
    	$this->_helper->layout()->disableLayout();

    	// Fa passare solo le richiesta asincrone.
    	if (!$this->getRequest()->isXmlHttpRequest()) {
    		return $this->_helper->redirector('index', 'index');
        }

    	// Dati del cliente e del database:
    	$database_id = (int)$this->getRequest()->getParam('database_id', null);
    	$software_id = $this->getRequest()->getParam('software_id', null);

    	// Istanzia l'oggetto database:
    	$database = new Database();

    	// Prende il database corrente:
    	$rowset = $database->find($database_id);
    	if ($rowset > 0) {
    		$row = $rowset->current();
    		$row->software_id = ($software_id>0) ? $software_id : null;
    		$row->save();
    	}

    	$this->_helper->AjaxContext();
    }


    public function loadnoteAction() {
    	// Disattiva il layout in questa azione:
    	$this->_helper->layout()->disableLayout();

    	// Fa passare solo le richiesta asincrone.
    	if (!$this->getRequest()->isXmlHttpRequest()) {
    		return $this->_helper->redirector('index', 'index');
        }

    	// Dati del db:
    	$database_id = (int)$this->getRequest()->getParam('database_id', null);

    	// Istanzia l'oggetto Domains:
    	$database = new Database();

    	// A quale dominio corrisponde la nota:
    	$rowset = $database->find($database_id);

    	// Dati da passare alla view:
    	$this->view->database_id	= $database_id;
    	$this->view->database 		= $rowset->current();
    }


    public function savenoteAction() {
    	// Disattiva il layout in questa azione:
    	$this->_helper->layout()->disableLayout();

    	// Fa passare solo le richiesta asincrone.
    	if (!$this->getRequest()->isXmlHttpRequest()) {
    		return $this->_helper->redirector('index', 'index');
        }

    	// Dati del dominio:
    	$database_id = (int)$this->getRequest()->getParam('database_id', null);
		$note	   = stripslashes($this->getRequest()->getParam('note', null));

    	// Istanzia l'oggetto Domains:
    	$database = new Database();

    	$rowset = $database->find($database_id);
    	if (count($rowset) > 0) {
    		$row = $rowset->current();
    		$row->note = $note;
    		$row->save();
    	}

    	$this->_helper->AjaxContext();
    }


	/**
	 * Eliminazione di una lista di database.
	 */
	public function deleteAction() {
		if ($this->getRequest()->isPost()) {
			$delete = $this->getRequest()->getParam('delete');
			if (is_array($delete)) {
				// Casta a int tutti i record dell'array:
				foreach ($delete as $k=>$v) {
					$delete[$k] = (int)$v;
				}
				$dDelete = "'" . implode("', '", $delete) . "'";

				$database = new Database();
				$database->delete(sprintf("id IN (%s)", $dDelete));
			}
		}

		$this->_helper->redirector('view', 'database');
	}


	/**
     * Mostra i dettagli degli utenti relativi ad un db.
     */
    public function showUserDetailsAction() {
    	// Disattiva il layout in questa azione:
    	$this->_helper->layout()->disableLayout();

    	// Fa passare solo le richiesta asincrone.
    	if (!$this->getRequest()->isXmlHttpRequest()) {
    		return $this->_helper->redirector('index', 'index');
        }

        // Model:
        $database = new Database();

    	// Dati del cliente e del database:
    	$database_id = (int)$this->getRequest()->getParam('database_id', null);

    	// Prende gli utenti associati al db:
    	$rowset = $database->find($database_id);
    	$database = null;

    	$rowsetUser = null;
    	if (count($rowset)>0) {
    		$database = $rowset->current();
    		$rowsetUser = $database->findManyToManyRowset("DatabaseUser", "DatabaseToDatabaseUser");
    	}

    	$this->view->users = $rowsetUser;
    	$this->view->database = $database;
    	$this->view->database_id = $database_id;
    	$this->_helper->AjaxContext();
    }


    /**
	 * Azione per l'aggiunta manuale di un database.
	 */
    public function addAction() {
		// Model:
    	$database = new Database();

    	// Form:
    	$form = new Default_Form_Database();

    	// Request:
    	$request = $this->getRequest();

    	// In caso di POST sulla pagina:
    	if ($request->isPost()) {
	    	if ($form->isValid($request->getPost())) {
	    		// Inserisce il nuovo record:
				$newRow = $database->createRow($form->getValues());
				$newRow->save();

				// Messaggio di ok:
				Neikos_Systemmessage::push("Database aggiunto con successo.", Neikos_Systemmessage::MSG_OK);

				// Redirige alla lista dei domini:
            	$this->_helper->redirector('view', 'database');
            	exit;
	        }
    	}

    	// Dati generali della vista:
		$this->view->title = "Aggiungi database";
		$this->view->modulo = "Database";
    	$this->view->headTitle("Aggiungi database");
		$this->view->headScript()->appendFile("/scripts/js/database/form.js", "text/javascript");
		$this->view->form = $form;
    }


	public function modifyAction() {
		// Model:
    	$database = new Database();

    	// Form:
    	$form = new Default_Form_Database();

    	// Request:
    	$request = $this->getRequest();

    	// Id del record da modificare:
    	$id = (int)$request->getParam("id", 0);

    	// Prende il record:
    	$rowset = $database->find($id);

    	if (count($rowset) == 0) {
    		// Record non trovato:
			Neikos_Systemmessage::push("Il record #" . $id . " non &egrave; stato trovato.", Neikos_Systemmessage::MSG_ERRORE);

    		$this->_helper->redirector('view', 'database');
    		exit;
    	}

    	// Record:
    	$row = $rowset->current();

    	// In caso di POST sulla pagina:
    	if ($request->isPost()) {
	    	if ($form->isValid($request->getPost())) {
	    		// Modifica il record:
				$row->setFromArray($form->getValues());
				$row->save();

				// Messaggio di ok:
				Neikos_Systemmessage::push("Database modificato con successo.", Neikos_Systemmessage::MSG_OK);

				// Redirige alla lista dei domini:
            	$this->_helper->redirector('view', 'database');
            	exit;
	        }
    	} else {
    		// Precarica i dati del record:
    		$form->populate($row->toArray());
    	}

    	// Dati generali della vista:
		$this->view->title = "Modifica database";
		$this->view->modulo = "Database";
    	$this->view->headTitle("Modifica database");
		$this->view->headScript()->appendFile("/scripts/js/database/form.js", "text/javascript");
		$this->view->form = $form;
    }


	public function ajaxListaSoftwareAction() {
    	// Disattiva il layout in questa azione:
    	$this->_helper->layout()->disableLayout();

    	// Fa passare solo le richiesta asincrone.
    	if (!$this->getRequest()->isXmlHttpRequest()) {
    		return $this->_helper->redirector('index', 'index');
        }

        // Dati della request:
    	$client_id = (int)$this->_request->getParam("client_id", 0);

    	// Istanzia l'oggetto Software:
    	$software = new Software();

    	// Form:
    	$form = new Default_Form_Database();

    	// Cerca in base al cliente passato:
		$this->view->selectSoftware = $form->getSelectSoftware($client_id);

		// Ajax context:
    	$this->_helper->AjaxContext();
    }


	public function viewUserAction() {
		// Setta i filtri di ricerca:
    	$this->_setFiltriUser();

		// Classe dei domini gestiti:
    	$databaseUser = new DatabaseUser();
		$databaseUser->setFiltri($this->_filtriRicercaUser);

		// Server:
		$servers = new Servers();

		// Dati della pagina:
		$this->view->title = "Lista utenti database";
		$this->view->headTitle("Lista utenti database");
		$this->view->headScript()->appendFile("/scripts/js/scriptaculous/scriptaculous.js", "text/javascript")
								 ->appendFile("/scripts/js/database/view-user.js", "text/javascript")
								 ->appendFile("/scripts/js/view.js", "text/javascript");

		$this->view->modulo = "Database";
		$this->view->databaseUser = $databaseUser->getPage($this->_page, $this->_item_per_page);
		$this->view->filtriRicerca = $this->_filtriRicercaUser;
		$this->view->listaServerForSelect = $databaseUser->listaServerForSelect();

		// Helper per il paginatore:
		$this->view->pagination_config = array(
		    'total_items'    => $databaseUser->count(),
            'items_per_page' => $this->_item_per_page,
            'style'          => 'default'
       	);
	}


	public function addUserAction() {
		// Model:
    	$databaseUser = new DatabaseUser();
    	$databaseToDatabaseUser = new DatabaseToDatabaseUser();

    	// Form:
    	$form = new Default_Form_DatabaseUser();
    	$form->setAction("/database/add-user");

    	// Request:
    	$request = $this->getRequest();

    	// In caso di POST sulla pagina:
    	if ($request->isPost()) {
	    	if ($form->isValid($request->getPost())) {
	    		// Verifica che non sia presente un utente con lo stesso nome host, user e server:
	    		$sel = $databaseUser->select()
	    					 ->where("host = ?", $form->getValue("host"))
	    					 ->where("user = ?", $form->getValue("user"))
	    					 ->where("server_id = ?", $form->getValue("server_id"));
	    		$ris = $databaseUser->fetchAll($sel);

	    		if (count($ris) > 0) {
					// Aggiunge l'errore al form:
					$msgErrore = "Esiste gi&agrave; un record con questo nome utente, hostname e server.";
					$form->getElement("user")->addError($msgErrore);
					$form->getElement("host")->addError($msgErrore);
					$form->getElement("server_id")->addError($msgErrore);
	       		} else {
		    		// Inserisce il nuovo record:
		    		$newRow = $databaseUser->createRow($form->getValues());
					$newRow->save();

					// Salva le associazioni con i database:
					$databases = $form->getElement("database_id")->getValue();
					if (count($databases)) {
						foreach ($databases as $database) {
							// TODO: controllare che il database esista.

							if ($database > 0) {
								$databaseToDatabaseUser->insert(
									array(
										"database_id"		=> (int)$database,
										"database_user_id"	=> $newRow->id,
										"privilegi"			=> ""
									)
								);
							}
						}
					}

					// Messaggio di ok:
					Neikos_Systemmessage::push("Utente database aggiunto con successo.", Neikos_Systemmessage::MSG_OK);

					$this->_helper->redirector('view-user', 'database');
	            	exit;
	    		}
	        }
    	} else {
    		// Eventuali dati del GET:
    		$form->populate($request->getParams());
    	}

    	// Dati generali della vista:
		$this->view->title = "Aggiungi utente database";
		$this->view->modulo = "Database";
    	$this->view->headTitle("Aggiungi utente database");
		$this->view->headScript()->appendFile("/scripts/js/database/form-user.js", "text/javascript");
		$this->view->form = $form;
	}


	public function modifyUserAction() {
	    // Model:
	    $databaseUser = new DatabaseUser();
	    $databaseToDatabaseUser = new DatabaseToDatabaseUser();

	    // Form:
	    $form = new Default_Form_DatabaseUser();
	    // $form->setAction("/database/modify-user");

	    // Request:
	    $request = $this->getRequest();

	    // Id del record da modificare:
	    $id = (int)$request->getParam("id", 0);

	    // Prende il record:
	    $rowset = $databaseUser->find($id);

	    if (count($rowset) == 0) {
	        // Record non trovato:
	        Neikos_Systemmessage::push("Il record #" . $id . " non &egrave; stato trovato.", Neikos_Systemmessage::MSG_ERRORE);

	        $this->_helper->redirector('view-user', 'database');
	        exit;
	    }

	    // Record:
	    $row = $rowset->current();

	    // In caso di POST sulla pagina:
	    if ($request->isPost()) {
	        if ($form->isValid($request->getPost())) {
	            // Verifica che non sia presente un utente con lo stesso nome host, user e server:
	            $sel = $databaseUser->select()
                    	            ->where("host = ?", $form->getValue("host"))
                    	            ->where("user = ?", $form->getValue("user"))
                    	            ->where("server_id = ?", $form->getValue("server_id"))
	                                ->where("id <> ?", $id);
	            $ris = $databaseUser->fetchAll($sel);

	            if (count($ris) > 0) {
	                // Aggiunge l'errore al form:
	                $msgErrore = "Esiste gi&agrave; un record con questo nome utente, hostname e server.";
	                $form->getElement("user")->addError($msgErrore);
	                $form->getElement("host")->addError($msgErrore);
	                $form->getElement("server_id")->addError($msgErrore);
	            } else {
	                // Modifica il record:
	                $row->setFromArray($form->getValues());
	                $row->save();

	                // Elimina le vecchie associazioni con i database:
	                $databaseToDatabaseUser->delete(sprintf("database_user_id IN (%s)", $id));

	                // Salva le nuove associazioni con i database:
	                $databases = $form->getElement("database_id")->getValue();
	                if (count($databases)) {
	                    foreach ($databases as $database) {
	                        // TODO: controllare che il database esista.

	                        if ($database > 0) {
	                            $databaseToDatabaseUser->insert(
	                                array(
	                                    "database_id"		=> (int)$database,
	                                    "database_user_id"	=> $row->id,
	                                    "privilegi"			=> ""
	                                )
	                            );
	                        }
	                    }
	                }

	                // Messaggio di ok:
	                Neikos_Systemmessage::push("Utente database aggiunto con successo.", Neikos_Systemmessage::MSG_OK);

	                $this->_helper->redirector('view-user', 'database');
	                exit;
	            }
	        }
	    } else {
	        // Eventuali dati del GET:
	        $form->populate($row->toArray());
	    }

	    // Dati generali della vista:
	    $this->view->title = "Modifica utente database";
	    $this->view->modulo = "Database";
	    $this->view->headTitle("Modifica utente database");
	    $this->view->headScript()->appendFile("/scripts/js/database/form-user.js", "text/javascript");
	    $this->view->form = $form;
	}


	/**
	 * Eliminazione di una lista di utenti database.
	 */
	public function deleteUserAction() {
		if ($this->getRequest()->isPost()) {
			$delete = $this->getRequest()->getParam('delete');
			if (is_array($delete)) {
				// Casta a int tutti i record dell'array:
				foreach ($delete as $k=>$v) {
					$delete[$k] = (int)$v;
				}
				$dDelete = "'" . implode("', '", $delete) . "'";

				$databaseUser = new DatabaseUser();
				$databaseUser->delete(sprintf("id IN (%s)", $dDelete));
			}
		}

		$this->_helper->redirector('view-user', 'database');
	}


 	public function loadnoteUserAction() {
    	// Disattiva il layout in questa azione:
    	$this->_helper->layout()->disableLayout();

    	// Fa passare solo le richiesta asincrone.
    	if (!$this->getRequest()->isXmlHttpRequest()) {
    		return $this->_helper->redirector('index', 'index');
        }

    	// Dati del db:
    	$database_user_id = (int)$this->getRequest()->getParam('database_user_id', null);

    	// Istanzia l'oggetto Domains:
    	$databaseUser = new DatabaseUser();

    	// A quale dominio corrisponde la nota:
    	$rowset = $databaseUser->find($database_user_id);

    	// Dati da passare alla view:
    	$this->view->database_user_id	= $database_user_id;
    	$this->view->databaseUser 		= $rowset->current();
    }


    public function savenoteUserAction() {
    	// Disattiva il layout in questa azione:
    	$this->_helper->layout()->disableLayout();

    	// Fa passare solo le richiesta asincrone.
    	if (!$this->getRequest()->isXmlHttpRequest()) {
    		return $this->_helper->redirector('index', 'index');
        }

    	// Dati del dominio:
    	$database_user_id 	= (int)$this->getRequest()->getParam('database_user_id', null);
		$note	   			= stripslashes($this->getRequest()->getParam('note', null));

    	// Istanzia l'oggetto Domains:
    	$databaseUser = new DatabaseUser();

    	$rowset = $databaseUser->find($database_user_id);
    	if (count($rowset) > 0) {
    		$row = $rowset->current();
    		$row->note = $note;
    		$row->save();
    	}

    	$this->_helper->AjaxContext();
    }


    public function ajaxListaDatabaseAction() {
		// Disattiva il layout in questa azione:
    	$this->_helper->layout()->disableLayout();

    	// Fa passare solo le richiesta asincrone.
    	if (!$this->getRequest()->isXmlHttpRequest()) {
    		return $this->_helper->redirector('index', 'index');
        }

        // Dati della request:
    	$server_id = (int)$this->_request->getParam("server_id", 0);

    	// Form:
    	$form = new Default_Form_DatabaseUser();

    	// Cerca in base al cliente passato:
		$this->view->selectDatabase = $form->getSelectDatabase($server_id);

		// Ajax context:
    	$this->_helper->AjaxContext();
    }


    public function ajaxSaveUserPwAction() {
		// Disattiva il layout in questa azione:
    	$this->_helper->layout()->disableLayout();

    	// Fa passare solo le richiesta asincrone.
    	if (!$this->getRequest()->isXmlHttpRequest()) {
    		return $this->_helper->redirector('index', 'index');
        }

    	// Dati del cliente e del database:
    	$database_user_id = (int)$this->getRequest()->getParam('database_user_id', 0);
    	$pw = $this->getRequest()->getParam('pw', "");

    	// Istanzia l'oggetto dell'utente db:
    	$databaseUser = new DatabaseUser();

    	// Prende l'utente corrente:
    	$rowset = $databaseUser->find($database_user_id);
    	if ($rowset > 0) {
    		$row = $rowset->current();
    		$row->pw = $pw;
    		$row->save();
    	}

    	$this->_helper->AjaxContext();
    }


    public function ajaxGetFiltroRicercaDbAction() {
    	// Disattiva il layout in questa azione:
    	$this->_helper->layout()->disableLayout();

    	// Fa passare solo le richiesta asincrone.
    	if (!$this->getRequest()->isXmlHttpRequest()) {
    		return $this->_helper->redirector('index', 'index');
        }

        // Request:
        $request = $this->getRequest();
        $server_id = (int)$request->getParam("server_id", 0);

        // Prende tutti i database associati ad un certo server:
		$selectDatabase = Database::getListaDbForSelect(array(
			"server_id" => $server_id
		));

        // Dati della view:
        $f = new stdClass();
        $f->server_id = $server_id;
        $f->database_id = 0;
        $f->selectDatabase = $selectDatabase;

		$this->view->filtriRicerca = $f;
    }
}

