<?php

// Zend Controller Action
require_once 'Zend/Controller/Action.php';

class DnsController extends Neikos_Controller_AdminAction {
	const DEF_NUM_ITEM_PER_PAGE = 50;

	protected $_page;
	protected $_item_per_page = self::DEF_NUM_ITEM_PER_PAGE;
	protected $_filtriRicerca;


	/**
	 * Nome della sessione utilizzata per i domini.
	 */
	const DNS_SESSION = "dbtech_dns";

	private function _getSession() {
		// Gestisce la sessione:
		$dnsSession = new Zend_Session_Namespace(self::DNS_SESSION);
		$dnsSession->setExpirationSeconds(3600);

		return $dnsSession;
	}

	/**
	 * Setta i filtri di ricerca in base al POST o alla
	 * variabili contenute nella sessione.
	 */
	protected function _setFiltri() {
		$dnsSession = $this->_getSession();

		// Sblocca la sessione per il suo utilizzo:
		if ($dnsSession->isLocked()) {
	    	$dnsSession->unLock();
		}

		// Pagina di visualizzazione:
    	$this->_page = (int)$this->getRequest()->getParam('page');

    	// Record per pagina:
    	$ipp = (int)$this->getRequest()->getParam('ipp');
    	if ($ipp > 0) {
    		$this->_item_per_page = $dnsSession->item_per_page = $ipp;
    	} else {
    		if ($dnsSession->item_per_page > 0) {
    			$this->_item_per_page = $dnsSession->item_per_page;
    		} else {
    			$this->_item_per_page = $dnsSession->item_per_page = self::DEF_NUM_ITEM_PER_PAGE;
    		}
    	}

    	// Azione da intraprendere:
		$cercaButton = $this->getRequest()->getParam('cercaButton');
    	$azzeraButton = $this->getRequest()->getParam('azzeraButton');


		if (isset($cercaButton)) { // Prende i filtri dal POST:
			// Catena di filtri per eliminare l'HTML e togliere
			// gli spazi vuoti:
			$generalFilter = new Zend_Filter();
			$generalFilter->addFilter(new Zend_Filter_StripTags())
						  ->addFilter(new Zend_Filter_StringTrim());

			$filters = array(
				"*"     	 => $generalFilter,
				"client_id"  => "Int",
				"server_id"  => "Int",
				"name"		 => "BaseName",
			);

			$this->_filtriRicerca = new Zend_Filter_Input($filters, null, $this->getRequest()->getPost());
			$dnsSession->filtriRicerca = $this->_filtriRicerca;
			$this->_page = 1;
		} else if (isset($azzeraButton)) {
			// Azzera i filtri di ricerca:
			$this->_filtriRicerca = $dnsSession->filtriRicerca = new Zend_Filter_Input(null, null, null);
			$this->_page = 1;
		} else {
			// Prende i filtri dalla sessione:
			if (!isset($dnsSession->filtriRicerca)) {
				$dnsSession->filtriRicerca = new Zend_Filter_Input(null, null, null);
			}

			$this->_filtriRicerca = $dnsSession->filtriRicerca;
		}

		// Blocca l'utilizzo della sessione:
		$dnsSession->lock();
	}


	public function viewAction() {
		// Setta i filtri di ricerca:
    	$this->_setFiltri();

		// Classe dei domini gestiti:
    	$dns = new Dns();
		$dns->setFiltri($this->_filtriRicerca);

		// Clienti:
		$clients = new Clients();

		// Server:
		$servers = new Servers();
    	$selServers = $dns->select()->from($dns, array("server_id"))->distinct();

		// Dati della pagina:
		$this->view->title = "Lista domini gestiti";
		$this->view->headTitle("Lista domini gestiti");
		$this->view->headScript()->appendFile("/scripts/js/scriptaculous/scriptaculous.js", "text/javascript")
								 ->appendFile("/scripts/js/dns/view.js", "text/javascript")
		                         ->appendFile("/scripts/js/view.js", "text/javascript");

		$this->view->modulo = "Dns";

		$this->view->listDns = $dns->getPage($this->_page, $this->_item_per_page);
		$this->view->editMode = true;
		$this->view->filtriRicerca = $this->_filtriRicerca;
		$this->view->listaClientiAttivi = $clients->fetchAll($clients->select()->from($clients, array("ID", "name"))->where("kategorie != 5")->where("parent = '0'")->order("name ASC"));
		$this->view->listaClientiFermati = $clients->fetchAll($clients->select()->from($clients, array("ID", "name"))->where("kategorie = 5")->where("parent = '0'")->order("name ASC"));
		$this->view->listaServer = $servers->fetchAll($servers->select()->where("id IN (" . $selServers->__toString() . ")")->order(array("is_neikos ASC", "name ASC")));

		// Helper per il paginatore:
		$this->view->pagination_config = array(
		    'total_items'    => $dns->count(),
            'items_per_page' => $this->_item_per_page,
            'style'          => 'default'
       	);
	}

	/**
	 * Azione "export": esporta la lista corrente di dns.
	 */
    public function exportAction() {
    	// Disattiva il layout:
		$this->_helper->layout->disableLayout();

    	// Setta i filtri di ricerca:
    	$this->_setFiltri();

    	// Classe dei domini:
    	$dns = new Dns();
		$dns->setFiltri($this->_filtriRicerca);

		// Dati della pagina:
		$this->view->dns = $dns->getPage(1, null);
    }


    /**
     * Salva il cliente associato ad un sito.
     */
    public function saveclientsAction() {
    	// Disattiva il layout in questa azione:
    	$this->_helper->layout()->disableLayout();

    	// Fa passare solo le richiesta asincrone.
    	if (!$this->getRequest()->isXmlHttpRequest()) {
    		return $this->_helper->redirector('index', 'index');
        }

    	// Dati del cliente e del dominio:
    	$dns_id 	= (int)$this->getRequest()->getParam('dns_id', null);
    	$client_id 	= (int)$this->getRequest()->getParam('client_id', null);

    	$set = array(
    		"project_id" => ($client_id>0) ? $client_id : null
    	);

    	// Istanzia l'oggetto Domains:
    	$dns = new Dns();

    	// Di quali domini modificare il cliente:
    	$where = $dns->getAdapter()->quoteInto("id = ?", $dns_id);

    	// Effettua la modifica:
    	$updateSuccess = $dns->update($set, $where);

    	$this->_helper->AjaxContext();
    }


    public function addAction() {
        $form = new Default_Form_Dns();
        $dns = new Dns();

        // In caso di POST sulla pagina:
        if ($this->getRequest()->isPost()) {
            if ($form->isValid($this->getRequest()->getPost())) {
                // Aggiunge il dns:
                $newRow = $dns->createRow($form->getValues());
                $newRow->immesso = Dns::IMMESSO_MANUALE;
                $newRow->last_update = date("Y-m-d H:i:s");
                $newRow->update_status = "A";
                $newRow->save();

                // Redirige alla lista dei dns:
                $this->_helper->redirector('view', 'dns');
            }
        }

        // Dati generali della vista:
        $this->view->title = "Aggiungi dominio gestito su server privo di aggiornamenti automatici";
        $this->view->modulo = "Dns";
        $this->view->headTitle("Aggiungi dominio gestito su server privo di aggiornamenti automatici");
        $this->view->form = $form;
    }

    public function modifyAction() {
        // Model:
        $dns = new Dns();

        // Form:
        $form = new Default_Form_Dns();

        // Request:
        $request = $this->getRequest();

        // Id del record da modificare:
        $id = (int)$request->getParam("id", 0);

        // Prende il record:
        $rowset = $dns->find($id);

        if (count($rowset) == 0) {
            // Record non trovato:
            Neikos_Systemmessage::push("Il record #" . $id . " non &egrave; stato trovato.", Neikos_Systemmessage::MSG_ERRORE);

            return $this->_helper->redirector('view', 'dns');
        }

        // Record:
        $row = $rowset->current();

        // In caso di POST sulla pagina:
    	if ($request->isPost()) {
	    	if ($form->isValid($request->getPost())) {
	    		// Modifica il record:
				$row->setFromArray($form->getValues());
				$row->immesso = Dns::IMMESSO_MANUALE;
				$row->last_update = date("Y-m-d H:i:s");
                $row->update_status = "A";
				$row->save();

				// Redirige alla lista dei dns:
            	return $this->_helper->redirector('view', 'dns');
	        }
    	} else {
    		// Precarica i dati del record:
    		$form->populate($row->toArray());
    	}

        // Dati generali della vista:
        $this->view->title = "Modifica dominio gestito su server privo di aggiornamenti automatici";
        $this->view->modulo = "Dns";
        $this->view->headTitle("Modifica dominio gestito su server privo di aggiornamenti automatici");
        $this->view->form = $form;
    }

    public function deleteAction() {
        if ($this->getRequest()->isPost()) {
			$delete = $this->getRequest()->getParam('delete');
			if (is_array($delete)) {
				// Casta a int tutti i record dell'array:
				foreach ($delete as $k=>$v) {
					$delete[$k] = (int)$v;
				}
				$dDelete = "'" . implode("', '", $delete) . "'";

				$dns = new Dns();
				$dns->delete(sprintf("id IN (%s)", $dDelete));
			}
		}

		$this->_helper->redirector('view', 'dns');
    }

	/**
	 * Redirige sull'azione "view".
	 */
	public function indexAction() {
		return $this->_helper->redirector("view", $this->getRequest()->getControllerName());
	}
}

?>