<?php

// Zend Controller Action
require_once 'Zend/Controller/Action.php';

class DomainsController extends Neikos_Controller_AdminAction {
	protected $_filtriRicerca;
	protected $_page;
	protected $_item_per_page = 25;


	/**
	 * Nome della sessione utilizzata per i domini.
	 */
	const DOMAINS_SESSION = "dbtech_domains";

	protected function _getSession() {
		// Gestisce la sessione:
		$domainsSession = new Zend_Session_Namespace(self::DOMAINS_SESSION);
		$domainsSession->setExpirationSeconds(3600);

		return $domainsSession;
	}


	/**
	 * Setta i filtri di ricerca in base al POST o alla
	 * variabili contenute nella sessione.
	 */
	protected function _setFiltri() {
		$domainsSession = $this->_getSession();

		// Sblocca la sessione per il suo utilizzo:
		if ($domainsSession->isLocked()) {
	    	$domainsSession->unLock();
		}

		// Pagina di visualizzazione:
    	$this->_page = (int)$this->getRequest()->getParam('page');

    	// Record per pagina:
    	$ipp = (int)$this->getRequest()->getParam('ipp');
    	if ($ipp > 0) {
    		$this->_item_per_page = $domainsSession->item_per_page = $ipp;
    	} else {
    		if ($domainsSession->item_per_page > 0) {
    			$this->_item_per_page = $domainsSession->item_per_page;
    		} else {
    			$this->_item_per_page = $domainsSession->item_per_page = 25;
    		}
    	}

    	// Azione da intraprendere:
		$cercaButton = $this->getRequest()->getParam('cercaButton');
    	$azzeraButton = $this->getRequest()->getParam('azzeraButton');


		if (isset($cercaButton)) { // Prende i filtri dal POST:
			// Catena di filtri per eliminare l'HTML e togliere
			// gli spazi vuoti:
			$generalFilter = new Zend_Filter();
			$generalFilter->addFilter(new Zend_Filter_StripTags())
						  ->addFilter(new Zend_Filter_StringTrim());

			// Filtro customizzato per lo stato:
			$setStato = new Neikos_Filter_IsInSet(array("A", "X", "XA", "XD"), "");

			// Filtro customizzato per lo stato dell'ultimo update:
			$setStatoUpdate = new Neikos_Filter_IsInSet(array("A", "D", "X"), "");

			// Filtro customizzato per le note:
			$setNota = new Neikos_Filter_IsInSet(array("A", "D"), "");

			// Filtro customizzato per mostra solo siti oppure no:
			$setOnly = new Neikos_Filter_IsInSet(array("S", ""), "");

			$filters = array(
				"*"     	 => $generalFilter,
				"ID"		 => "Int",
				"client_id"  => "Int",
				"server_id"  => "Int",
				"name"		 => "BaseName",
				"stato"		 => $setStato,
				"nota"		 => $setNota,
				"stato_update" => $setStatoUpdate,
				"mostra"	 => $setOnly
			);
			$this->_filtriRicerca = new Zend_Filter_Input($filters, null, $this->getRequest()->getPost());
			$domainsSession->filtriRicerca = $this->_filtriRicerca;
			$this->_page = 1;
		} else if (isset($azzeraButton)) {
			// Azzera i filtri di ricerca:
			$this->_filtriRicerca = $domainsSession->filtriRicerca = new Zend_Filter_Input(null, null, null);
			$this->_page = 1;
		} else {
			// Prende i filtri dalla sessione:
			if (!isset($domainsSession->filtriRicerca)) {
				$domainsSession->filtriRicerca = new Zend_Filter_Input(null, null, null);
			}

			$this->_filtriRicerca = $domainsSession->filtriRicerca;
		}

		// Blocca l'utilizzo della sessione:
		$domainsSession->lock();
	}


	/**
	 * Redirige sull'azione "view".
	 */
	public function indexAction() {
		$this->_forward("view");
	}


	/**
	 * Azione "view": quella che riguarda la lista
	 * dei domini presenti.
	 */
    public function viewAction() {
    	// Setta i filtri di ricerca:
    	$this->_setFiltri();

    	// Classe dei domini:
    	$domains = new Domains();
		$domains->setFiltri($this->_filtriRicerca);

		// Clienti:
		$clients = new Clients();

		// Server:
		$servers = new Servers();
		$selServers = $domains->select()->from($domains, array("server_id"))->distinct();

		// Dati della pagina:
		$this->view->title = "Lista hosting presenti";
		$this->view->headTitle("Lista hosting presenti");
		$this->view->headScript()->appendFile("/scripts/js/scriptaculous/scriptaculous.js", "text/javascript")
								 ->appendFile("/scripts/js/domains/view.js", "text/javascript")
								 ->appendFile("/scripts/js/view.js", "text/javascript");

    	$this->view->modulo = "Hosting";
		$this->view->listDomains = $domains->getPage($this->_page, $this->_item_per_page);
		$this->view->editMode = true;
		$this->view->filtriRicerca = $this->_filtriRicerca;
		$this->view->listaClientiAttivi = $clients->getAttivi();
		$this->view->listaClientiFermati = $clients->getFermati();
		$this->view->listaServer = $servers->fetchAll($servers->select()->where("id IN (" . $selServers->__toString() . ")")->order(array("is_neikos ASC", "name ASC")));

		// Helper per il paginatore:
		$this->view->pagination_config = array( 'total_items'    => $domains->count(),
                                               	'items_per_page' => $this->_item_per_page,
                                               	'style'          => 'default'
       	);
    }


	/**
	 * Azione "export": esporta la lista corrente di domini.
	 */
    public function exportAction() {
    	// Disattiva il layout:
		$this->_helper->layout->disableLayout();

    	// Setta i filtri di ricerca:
    	$this->_setFiltri();

    	// Classe dei domini:
    	$domains = new Domains();
		$domains->setFiltri($this->_filtriRicerca);

		// Dati della pagina:
		$this->view->domains = $domains->getPage(1, null);
    }


    /**
     * Aggiunge un nuovo dominio esterno al db.
     *
     * TODO: Rifare sfuttando la validazione nel form
     *
     * @param array $data
     * @param Domains $row
     *
     * @return bool - segnala la buona riuscita della fase di salvataggio.
     */
    protected function _saveDomain($data, $row) {
    	// Altri Dati:
    	$dataAttuale = date("Y-m-d H:i:s");
    	$real_IP = $this->_realIP($data["name"]);

	    // Controlla che l'IP del dominio sia corretto:
    	$alert = "";
    	$stato = __STATO_OK__;
    	$servers = new Servers();
    	$selServer = $servers->select()
    	                     ->from($servers, array("ip"))
    	                     ->where("id = ?", $data["server_id"]);
    	$risServer = $servers->fetchAll($selServer);
	   	if (count($risServer) > 0) {
	   		if ($real_IP != "") {
	        	if (!in_array($real_IP, $server_ips)) {
	            	$stato = __STATO_ALERT__;
	                $alert .= "- L'indirizzo IP del dominio non rientra tra quelli del server\n";
	        	}
	        	if ($real_IP != $data["ip_port"]) {
	            	$stato = __STATO_ALERT__;
	                $alert .= "- L'indirizzo IP specificato non coincide con quello reale\n";
	            }
	    	}
	   	} else {
	   		$stato = __STATO_ALERT__;
	        $alert .= "- Il server non è corretto\n";
	   	}

	   	// Dati da inserire:
    	$newData = array(
    		"name"			=> $data["name"],
    		"project_id"	=> ($data["project_id"] > 0) ? $data["project_id"] : null,
    		"parent_id"		=> ($data["parent_id"] > 0) ? $data["parent_id"] : null,
    		"last_update"	=> $dataAttuale,
    		"server_id"		=> $data["server_id"],
    		"real_ip"		=> $real_IP,
    		"ip_port"		=> $data["ip_port"],
    		"mantainer"		=> "",
    		"immesso"		=> "M",
    		"status"		=> $stato,
    		"update_status"	=> "A",
    		"note"			=> "",
    		"spazio"		=> "",
    		"alert"			=> $alert
    	);

    	try {
    	    $row->setFromArray($newData);
    	    $row->save();
    	} catch (Exception $ex) {
    		// In caso di errore:
    		return false;
    	}

    	return true;
    }


	/**
	 * Azione per l'aggiunta di un nuovo dominio manuale.
	 */
    public function addAction() {
    	$form = new Default_Form_Domain();
    	$domains = new Domains();

    	// In caso di POST sulla pagina:
    	if ($this->getRequest()->isPost()) {
	    	if ($form->isValid($this->getRequest()->getPost())) {
	    	    // Salva il dato:
	    	    $row = $domains->createRow();
	            $this->_saveDomain($form->getValues(), $row);

	            // Redirige alla lista dei domini:
	            return $this->_helper->redirector('view', 'domains');
	        }
    	}

    	// Dati generali della vista:
		$this->view->title = "Aggiungi hosting";
		$this->view->modulo = "Hosting";
    	$this->view->headTitle("Aggiungi hosting");
		$this->view->form = $form;
    }


    public function modifyAction() {
        // Model:
        $domains = new Domains();

        // Form:
        $form = new Default_Form_Domain();

        // Request:
        $request = $this->getRequest();

        // Id del record da modificare:
        $id = (int)$request->getParam("id", 0);

        // Prende il record:
        $rowset = $domains->find($id);

        if (count($rowset) == 0) {
            // Record non trovato:
            Neikos_Systemmessage::push("Il record #" . $id . " non &egrave; stato trovato.", Neikos_Systemmessage::MSG_ERRORE);

            return $this->_helper->redirector('view', 'domains');
        }

        // Record:
        $row = $rowset->current();

        // In caso di POST sulla pagina:
        if ($request->isPost()) {
            if ($form->isValid($request->getPost())) {
                // Salva il dato:
                $this->_saveDomain($form->getValues(), $row);

                // Redirige alla lista dei domini:
                return $this->_helper->redirector('view', 'domains');
            }
        } else {
            // Precarica i dati del record:
            $form->populate($row->toArray());
        }

        // Dati generali della vista:
		$this->view->title = "Modifica hosting";
		$this->view->modulo = "Hosting";
    	$this->view->headTitle("Modifica hosting");
		$this->view->form = $form;
    }


	/**
	 * Eliminazione di una lista di domini.
	 */
	public function deleteAction() {
		if ($this->getRequest()->isPost()) {
			$delete = $this->getRequest()->getParam('delete');
			if (is_array($delete)) {
				// Casta a int tutti i record dell'array:
				foreach ($delete as $k=>$v) {
					$delete[$k] = (int)$v;
				}
				$dDelete = "'" . implode("', '", $delete) . "'";

				$domains = new Domains();
				$domains->delete(sprintf("id IN (%s)", $dDelete));
			}
		}

		$this->_helper->redirector('view', 'domains');
	}


    /**
     * Salva il cliente associato ad un sito.
     */
    public function saveclientsAction() {
    	// Disattiva il layout in questa azione:
    	$this->_helper->layout()->disableLayout();

    	// Fa passare solo le richiesta asincrone.
    	if (!$this->getRequest()->isXmlHttpRequest()) {
    		return $this->_helper->redirector('index', 'index');
        }

    	// Dati del cliente e del dominio:
    	$domain_id = (int)$this->getRequest()->getParam('domain_id', null);
    	$client_id = (int)$this->getRequest()->getParam('client_id', null);

    	$set = array(
    		"project_id" => ($client_id>0) ? $client_id : null
    	);

    	// Istanzia l'oggetto Domains:
    	$domains = new Domains();

    	// Di quali domini modificare il cliente:
    	$where = $domains->getAdapter()->quoteInto("id = ?", $domain_id) . " OR "
    			.$domains->getAdapter()->quoteInto("parent_id = ?", $domain_id);

    	// Effettua la modifica:
    	$updateSuccess = $domains->update($set, $where);

    	$this->_helper->AjaxContext();
    }


	/**
     * Salva la nota associata ad un sito.
     */
    public function savenoteAction() {
    	// Disattiva il layout in questa azione:
    	$this->_helper->layout()->disableLayout();

    	// Fa passare solo le richiesta asincrone.
    	if (!$this->getRequest()->isXmlHttpRequest()) {
    		return $this->_helper->redirector('index', 'index');
        }

    	// Dati del dominio:
    	$domain_id = (int)$this->getRequest()->getParam('domain_id', null);
		$note	   = stripslashes($this->getRequest()->getParam('note', null));

    	// Istanzia l'oggetto Domains:
    	$domains = new Domains();

    	// A quale dominio corrisponde la nota:
    	$where = $domains->getAdapter()->quoteInto("id = ?", $domain_id);

    	// Dati:
    	$set = array("note" => $note);

    	// Effettua la modifica:
    	$updateSuccess = $domains->update($set, $where);

    	$this->_helper->AjaxContext();
    }


    public function loadnoteAction() {
    	// Disattiva il layout in questa azione:
    	$this->_helper->layout()->disableLayout();

    	// Fa passare solo le richiesta asincrone.
    	if (!$this->getRequest()->isXmlHttpRequest()) {
    		return $this->_helper->redirector('index', 'index');
        }

    	// Dati del dominio:
    	$domain_id = (int)$this->getRequest()->getParam('domain_id', null);

    	// Istanzia l'oggetto Domains:
    	$domains = new Domains();

    	// A quale dominio corrisponde la nota:
    	$domain = $domains->find($domain_id);

    	// Dati da passare alla view:
    	$this->view->domain_id 	= $domain_id;
    	$this->view->domain 	= $domain->current();
    }


    public function towarningAction() {
    	// Disattiva il layout in questa azione:
    	$this->_helper->layout()->disableLayout();

    	// Fa passare solo le richiesta asincrone.
    	if (!$this->getRequest()->isXmlHttpRequest()) {
    		return $this->_helper->redirector('index', 'index');
        }

    	// Dati del dominio:
    	$domain_id = (int)$this->getRequest()->getParam('domain_id', null);

    	// Istanzia l'oggetto Domains:
    	$domains = new Domains();
    	$domain = $domains->find($domain_id);

    	if (null !== $domain) {
    		// A quale dominio corrisponde la nota:
	    	$where = $domains->getAdapter()->quoteInto("status='X' AND id = ?", $domain_id);

	    	// Dati:
	    	if ($domain->current()->alert_disabled == "A") {
	    		$set = array("alert_disabled" => "D");
	    	} else {
	    		$set = array("alert_disabled" => "A");
	    	}

	    	// Effettua la modifica:
	    	$updateSuccess = $domains->update($set, $where);
    	}

    	$this->_helper->AjaxContext();
    }


	/**
	 * Mostra tutte le informazioni possibili sui domini eseguendo dei comandi.
	 */
	public function monitorAction() {
		// Titolo della pagina:
		$this->view->headTitle("Monitor Domini");

		// Comandi da eseguire sul server:
		$command = array(
			"ping -c2 %s",
			"dig %s",
			"nmap -p80 %s",
			"whois %s"
		);

		// ID del dominio da controllare:
		$domain_id = (int)$this->getRequest()->getParam("id");

		// Oggetto Domains:
		$domains = new Domains();
		$rowset = $domains->find($domain_id);
		$retCmd = "";

		if (count($rowset) > 0) {
			$domain = $rowset->current();
			$domainName = $domain->name;

			if (count($command)>0) {
				foreach ($command as $c) {
					$cmdline = sprintf($c, $domainName);

					$retCmd .= "<h2>" . $cmdline . "</h2>"
							  ."<pre>"
							  .trim(shell_exec($cmdline))
							  ."</pre>";
				}
			}
		} else {
			// TODO: inserire un messaggio di errore (stack dei msg di errore???)...
		}

		$this->view->retCmd = $retCmd;
	}


	/**
	 * Azione "summary": mostra i sottodomini di un certo
	 * dominio.
	 */
	public function summaryAction() {
		// ID del dominio da riepilogare:
    	$id = (int)$this->getRequest()->getParam("id");

    	// Controlla che esista il dominio:
    	$domains = new Domains();
    	$domain = $domains->find($id)->current();

    	// Se il dominio richiesto non esiste, redirege all'azione di default:
    	if (null === $domain) {
    		return $this->_helper->redirector("index", $this->getRequest()->getControllerName());
    	}

    	// Dati della pagina:
    	$this->view->title = sprintf("Hosting collegati a '%s'", stripslashes($domain->name));
    	$this->view->headTitle($this->view->title);
		$this->view->modulo = "Hosting";

    	// Id del dominio principale da cercare:
    	$findId = (null === $domain->parent_id) ? $id : $domain->parent_id;

    	// Domini collegati al dominio principale:
    	$query = $domains->select()
    	                 ->from($domains)
    	                 ->where("parent_id = ?", $findId)
    	                 ->orWhere("id = ?", $findId);
     	$this->view->listDomains = $domains->fetchAll($query);
	}


	/**
	 * Trova l'IP reale di un dominio.
	 *
	 * @param string $dominio
	 * @return string
	 */
	protected function _realIP($dominio) {
	    $dominio = trim($dominio);

	    // Nel caso di domini tipo:
	    // *.test.neikos.it, sostituisce lo *
	    // con una stringa qualsiasi non definita altrimenti.
	    if (substr($dominio, 0, 2) == "*.") {
	    	$dominio = "aasfdbvasfdbasd" . substr($dominio, 1);
	    }
		$ip = trim(`/usr/bin/dig $dominio A +short | /usr/bin/tail -1`);
	    return $ip;
	}
}
