<?php

// Zend Controller Action
require_once 'Zend/Controller/Action.php';

class FtpController extends Neikos_Controller_AdminAction {
	protected $_filtriRicerca;
	protected $_page;
	protected $_item_per_page = 25;

	/**
	 * Nome della sessione utilizzata per i domini.
	 */
	const FTP_SESSION = "dbtech_ftp_session";

	protected function _getSession() {
		// Gestisce la sessione:
		$ftpSession = new Zend_Session_Namespace(self::FTP_SESSION);
		$ftpSession->setExpirationSeconds(3600);

		return $ftpSession;
	}

	/**
	 * Setta i filtri di ricerca in base al POST o alla
	 * variabili contenute nella sessione.
	 */
	protected function _setFiltri() {
		$ftpSession = $this->_getSession();

		// Sblocca la sessione per il suo utilizzo:
		if ($ftpSession->isLocked()) {
	    	$ftpSession->unLock();
		}

		// Pagina di visualizzazione:
    	$this->_page = (int)$this->getRequest()->getParam('page');

    	// Record per pagina:
    	$ipp = (int)$this->getRequest()->getParam('ipp');
    	if ($ipp > 0) {
    		$this->_item_per_page = $ftpSession->item_per_page = $ipp;
    	} else {
    		if ($ftpSession->item_per_page > 0) {
    			$this->_item_per_page = $ftpSession->item_per_page;
    		} else {
    			$this->_item_per_page = $ftpSession->item_per_page = 25;
    		}
    	}

    	// Azione da intraprendere:
		$cercaButton = $this->getRequest()->getParam('cercaButton');
    	$azzeraButton = $this->getRequest()->getParam('azzeraButton');

		if (isset($cercaButton)) { // Prende i filtri dal POST:
			// Catena di filtri per eliminare l'HTML e togliere
			// gli spazi vuoti:
			$generalFilter = new Zend_Filter();
			$generalFilter->addFilter(new Zend_Filter_StripTags())
						  ->addFilter(new Zend_Filter_StringTrim());

			$filters = array(
				"*"     	 => $generalFilter,
				"client_id"  => "Int",
				"server_id"  => "Int",
				"name"		 => "BaseName",
				"user"		 => "BaseName"
			);
			$this->_filtriRicerca = new Zend_Filter_Input($filters, null, $this->getRequest()->getPost());
			$ftpSession->filtriRicerca = $this->_filtriRicerca;
			$this->page = 1;
		} else if (isset($azzeraButton)) {
			// Azzera i filtri di ricerca:
			$this->_filtriRicerca = $ftpSession->filtriRicerca = new Zend_Filter_Input(null, null, null);
			$this->_page = 1;
		} else {
			// Prende i filtri dalla sessione:
			if (!isset($ftpSession->filtriRicerca)) {
				$ftpSession->filtriRicerca = new Zend_Filter_Input(null, null, null);
			}

			$this->_filtriRicerca = $ftpSession->filtriRicerca;
		}

		// Blocca l'utilizzo della sessione:
		$ftpSession->lock();
	}

	/**
	 * Redirige sull'azione "view".
	 */
	public function indexAction() {
		$this->_forward("view");
	}

	/**
	 * Lista degli account ftp presenti
	 * paginati in base alle impostazioni specificate.
	 */
	public function viewAction() {
		// Setta i filtri di ricerca:
    	$this->_setFiltri();

    	// Classe degli account di posta:
    	$ftp = new Ftp();
    	$ftp->setFiltri($this->_filtriRicerca);

    	// Clienti:
		$clients = new Clients();

		// Server:
		$servers = new Servers();
    	$selServers = $ftp->select()->from($ftp, array("server_id"))->distinct();

		// Dati della pagina:
		$this->view->title = "Lista utenti FTP";
		$this->view->headTitle("Lista utenti FTP");
		$this->view->headScript()->appendFile("/scripts/js/view.js", "text/javascript");

		$this->view->modulo = "FTP";
		$this->view->filtriRicerca = $this->_filtriRicerca;
		$this->view->listaClientiAttivi = $clients->fetchAll($clients->select()->from($clients, array("ID", "name"))->where("kategorie != 5")->where("parent = '0'")->order("name ASC"));
		$this->view->listaClientiFermati = $clients->fetchAll($clients->select()->from($clients, array("ID", "name"))->where("kategorie = 5")->where("parent = '0'")->order("name ASC"));
		$this->view->listaServer = $servers->fetchAll($servers->select()->where("id IN (" . $selServers->__toString() . ")")->order(array("is_neikos ASC", "name ASC")));

		// Dati della pagina:
		$this->view->ftp = $ftp->getPage($this->_page, $this->_item_per_page);

		// Helper per il paginatore:
		$this->view->pagination_config = array( 'total_items'    => $ftp->count(),
                                               	'items_per_page' => $this->_item_per_page,
                                               	'style'          => 'default'
       	);
	}


	/**
	 * Azione per l'aggiunta manuale di un utente FTP.
	 */
    public function addAction() {
		// Model:
    	$ftp = new Ftp();

    	// Form:
    	$form = new Default_Form_Ftp();

    	// Request:
    	$request = $this->getRequest();

    	// In caso di POST sulla pagina:
    	if ($request->isPost()) {
	    	if ($form->isValid($request->getPost())) {
	    		// Inserisce il nuovo record:
				$newRow = $ftp->createRow($form->getValues());
				$newRow->save();

				// Redirige alla lista dei domini:
            	$this->_helper->redirector('view', 'ftp');
            	exit;
	        }
    	}

    	// Dati generali della vista:
		$this->view->title = "Aggiungi account FTP";
		$this->view->modulo = "FTP";
    	$this->view->headTitle("Aggiungi account FTP");
		$this->view->form = $form;
    }


    public function modifyAction() {
		// Model:
    	$ftp = new Ftp();

    	// Form:
    	$form = new Default_Form_Ftp();

    	// Request:
    	$request = $this->getRequest();

    	// Id del record da modificare:
    	$id = (int)$request->getParam("id", 0);

    	// Prende il record:
    	$rowset = $ftp->find($id);

    	if (count($rowset) == 0) {
    		// Record non trovato:
			Neikos_Systemmessage::push("Il record #" . $id . " non &egrave; stato trovato.", Neikos_Systemmessage::MSG_ERRORE);

    		$this->_helper->redirector('view', 'ftp');
    		exit;
    	}

    	// Record:
    	$row = $rowset->current();

    	// In caso di POST sulla pagina:
    	if ($request->isPost()) {
	    	if ($form->isValid($request->getPost())) {
	    		// Modifica il record:
				$row->setFromArray($form->getValues());
				$row->save();

				// Redirige alla lista dei domini:
            	$this->_helper->redirector('view', 'ftp');
            	exit;
	        }
    	} else {
    		// Precarica i dati del record:
    		$form->populate($row->toArray());
    	}

    	// Dati generali della vista:
		$this->view->title = "Modifica account FTP";
		$this->view->modulo = "FTP";
    	$this->view->headTitle("Modifica account FTP");
		$this->view->form = $form;
    }

    public function deleteAction() {
		if ($this->getRequest()->isPost()) {
			$delete = $this->getRequest()->getParam('delete');
			if (is_array($delete)) {
				// Casta a int tutti i record dell'array:
				foreach ($delete as $k=>$v) {
					$delete[$k] = (int)$v;
				}
				$dDelete = "'" . implode("', '", $delete) . "'";

				$ftp = new Ftp();
				$ftp->delete(sprintf("id IN (%s)", $dDelete));
			}
		}

		$this->_helper->redirector('view', 'ftp');
    }
}

?>