<?php

// Zend Controller Action
require_once 'Zend/Controller/Action.php';

class MailController extends Neikos_Controller_AdminAction {
	private $filtriRicerca;
	private $page;
	private $item_per_page = 25;

	/**
	 * Nome della sessione utilizzata per la posta.
	 */
	const MAIL_SESSION = "dbtech_mail";

	/**
	 * Lista degli account di posta presenti
	 * paginati in base alle impostazioni specificate.
	 */
	public function viewAction() {
		// Setta i filtri di ricerca:
    	$this->_setFiltri();

    	// Classe degli account di posta:
    	$mail = new Mail();
    	$mail->setFiltri($this->filtriRicerca);

    	// Clienti:
		$clients = new Clients();

		// Server:
		$servers = new Servers();
    	$selServers = $mail->select()->from($mail, array("server_id"))->distinct();

		// Domini di posta:
		$mail_domains = new MailDomains();

		// Dati della pagina:
		$this->view->title = "Lista account di posta";
		$this->view->headTitle("Lista account di posta");
		$this->view->headScript()->appendFile("/scripts/js/view.js", "text/javascript")
		                         ->appendFile("/scripts/js/mail/view.js", "text/javascript");

		$this->view->modulo = "Account di Posta";
		$this->view->mail = $mail->getPage($this->page, $this->item_per_page);

		$this->view->filtriRicerca = $this->filtriRicerca;
		$this->view->listaClientiAttivi = $clients->fetchAll($clients->select()->from($clients, array("ID", "name"))->where("kategorie != 5")->where("parent = '0'")->order("name ASC"));
		$this->view->listaClientiFermati = $clients->fetchAll($clients->select()->from($clients, array("ID", "name"))->where("kategorie = 5")->where("parent = '0'")->order("name ASC"));
		$this->view->listaServer = $servers->fetchAll($servers->select()->where("id IN (" . $selServers->__toString() . ")")->order(array("is_neikos ASC", "name ASC")));
		$this->view->mailDomains = $mail_domains->fetchAll($mail_domains->select()->order("name"));

		// Helper per il paginatore:
		$this->view->pagination_config = array( 'total_items'    => $mail->count(),
                                               	'items_per_page' => $this->item_per_page,
                                               	'style'          => 'default'
       	);
	}

	/**
	 * Redirige sull'azione "view".
	 */
	public function indexAction() {
		return $this->_helper->redirector("view", $this->getRequest()->getControllerName());
	}

	private function _getSession() {
		// Gestisce la sessione:
		$mailSession = new Zend_Session_Namespace(self::MAIL_SESSION);
		$mailSession->setExpirationSeconds(3600);

		return $mailSession;
	}

	/**
	 * Setta i filtri di ricerca in base al POST o alla
	 * variabili contenute nella sessione.
	 */
	private function _setFiltri() {
		$mailSession = $this->_getSession();

		// Sblocca la sessione per il suo utilizzo:
		if ($mailSession->isLocked()) {
	    	$mailSession->unLock();
		}

		// Pagina di visualizzazione:
    	$this->page = (int)$this->getRequest()->getParam('page');

    	// Record per pagina:
    	$ipp = (int)$this->getRequest()->getParam('ipp');
    	if ($ipp > 0) {
    		$this->item_per_page = $mailSession->item_per_page = $ipp;
    	} else {
    		if ($mailSession->item_per_page > 0) {
    			$this->item_per_page = $mailSession->item_per_page;
    		} else {
    			$this->item_per_page = $mailSession->item_per_page = 25;
    		}
    	}

    	// Azione da intraprendere:
		$cercaButton = $this->getRequest()->getParam('cercaButton');
    	$azzeraButton = $this->getRequest()->getParam('azzeraButton');

		if (isset($cercaButton)) { // Prende i filtri dal POST:
			// Catena di filtri per eliminare l'HTML e togliere
			// gli spazi vuoti:
			$generalFilter = new Zend_Filter();
			$generalFilter->addFilter(new Zend_Filter_StripTags())
						  ->addFilter(new Zend_Filter_StringTrim());

			$filters = array(
				"*"     	 => $generalFilter,
				"client_id"  => "Int",
				"server_id"  => "Int",
			);

			$this->filtriRicerca = new Zend_Filter_Input($filters, null, $this->getRequest()->getPost());
			$mailSession->filtriRicerca = $this->filtriRicerca;
			$this->page = 1;
		} else if (isset($azzeraButton)) {
			// Azzera i filtri di ricerca:
			$this->filtriRicerca = $mailSession->filtriRicerca = new Zend_Filter_Input(null, null, null);
			$this->page = 1;
		} else {
			// Prende i filtri dalla sessione:
			if (!isset($mailSession->filtriRicerca)) {
				$mailSession->filtriRicerca = new Zend_Filter_Input(null, null, null);
			}

			$this->filtriRicerca = $mailSession->filtriRicerca;
		}

		// Blocca l'utilizzo della sessione:
		$mailSession->lock();
	}


	public function getFileRiepilogoAction() {
	    // Disattiva il layout in questa azione:
		$this->_helper->layout()->disableLayout();

		// Disattiva il rendering della view:
		$this->_helper->viewRenderer->setNoRender();

		// Autoloader delle classi della libreria:
		require_once("PhpOffice/PhpWord/Autoloader.php");
		\PhpOffice\PhpWord\Autoloader::register();

		// Lista delle caselle:
		$mail = $this->_request->getParam("mail");
		$mail_domains_id = (int)$this->_request->getParam("mail_domains_id");

		// Model:
		$mailDomainsModel = new MailDomains();
		$mailModel = new Mail();

		// Prende i dati del dominio di posta:
		$rowset = $mailDomainsModel->find($mail_domains_id);
		if (count($rowset) == 0) {
			exit;
		}
		$rowMailDomain = $rowset->current();

		// Alias del dominio di posta:
		$domainAliases = "";
		$alias_domains = $rowMailDomain->findDependentRowset('MailDomainsAliases');
		if (count($alias_domains) > 0) {
			foreach ($alias_domains as $dom_alias) {
				if ($domainAliases != "") $domainAliases .= ", ";
				$domainAliases .= $dom_alias->name;
			}
		}

		// Prende il modello in funzione del server:
		$fileModello = $rowMailDomain->getModelloFileRiepilogo();

		// Se il modello non esiste, restituisce un errore:
		if ($fileModello === false) {
		    throw new Zend_Controller_Action_Exception('Nessun modello presente per il server di posta', 404);
		}

		// Processor del template:
		$templateProcessor = new Neikos_PhpWord_TemplateProcessor($fileModello);

		// Dominio:
		$templateProcessor->setValue('DOMINIO', stripslashes($rowMailDomain->name));

		// Data corrente:
		$templateProcessor->setValue('DATA_CORRENTE', date("d-m-Y"));

		// Prende i dati relativi alle caselle:
		if (isset($mail[$mail_domains_id]) && is_array($mail[$mail_domains_id]) && count($mail[$mail_domains_id]) > 0) {
		    // Clona la riga per ogni casella:
		    $templateProcessor->cloneRow('EMAIL', count($mail[$mail_domains_id]));
		    $cont = 1;

			foreach ($mail[$mail_domains_id] as $mail_id) {
				$rowsetMail = $mailModel->find($mail_id);

				if (count($rowsetMail) > 0) {
					$rowMail = $rowsetMail->current();

					// Casella di posta:
					$user = stripslashes($rowMail->user . "@" . $rowMailDomain->name);

					// Quota:
					if ($rowMail->quota_ass < 0) {
						$quota = "Illimitata";
					} else {
						$quota = Neikos_Utility::formatDimByte($rowMail->quota_ass);
					}

					// Forward:
					if (empty($rowMail->forward)) {
					    $templateProcessor->deleteBlock('FORWARD_BLOCK#' . $cont);
					} else {
					    $templateProcessor->cloneBlock('FORWARD_BLOCK#' . $cont);
					    $templateProcessor->setValue('FORWARD#' . $cont, $rowMail->forward);
					}

                    // Alias:
					if (empty($rowMail->alias)) {
					    $templateProcessor->deleteBlock('ALIAS_BLOCK#' . $cont);
					} else {
					    $templateProcessor->cloneBlock('ALIAS_BLOCK#' . $cont);
					    $templateProcessor->setValue('ALIAS#' . $cont, $rowMail->alias);
					}

					// Dati dell'account:
					$templateProcessor->setValue('EMAIL#'    . $cont, $user);
					$templateProcessor->setValue('PASSWORD#' . $cont, $rowMail->pw);
					$templateProcessor->setValue('FORWARD#'  . $cont, $forwards);
					$templateProcessor->setValue('QUOTA#'    . $cont, $quota);
					$cont++;
				}
			}
		}

		// Alias di dominio:
		if (!empty($domainAliases)) {
		    $templateProcessor->cloneBlock("ALIAS_DOMINIO_BLOCK");
		    $templateProcessor->setValue("ALIAS_DOMINIO", $domainAliases);
		} else {
		    $templateProcessor->deleteBlock("ALIAS_DOMINIO_BLOCK");
		}

		// Nome del file da scaricare:
		$nomeFile = "email_" . str_replace(".", "_", $rowMailDomain->name) . "_" . date("Ymd") . ".docx";

		// Header:
		header("Content-Description: File Transfer");
        header('Content-Disposition: attachment; filename="' . $nomeFile . '"');
        header('Content-Type: application/vnd.openxmlformats-officedocument.wordprocessingml.document');
        header('Content-Transfer-Encoding: binary');
        header('Cache-Control: must-revalidate, post-check=0, pre-check=0');
        header('Expires: 0');

		// File di salvataggio:
        $filename = $templateProcessor->save();

        // Mostra il contenuto del file:
        echo file_get_contents($filename);

        // Cancella il file temporaneo:
        @unlink($filename);
	}


	public function ajaxSaveMailPwAction() {
	    // Disattiva il layout in questa azione:
	    $this->_helper->layout()->disableLayout();

	    // Fa passare solo le richiesta asincrone.
	    if (!$this->getRequest()->isXmlHttpRequest()) {
	        return $this->_helper->redirector('index', 'index');
	    }

	    // Id della casella e password:
	    $mail_id = (int)$this->getRequest()->getParam('mail_id', 0);
	    $pw = $this->getRequest()->getParam('pw', "");

	    // Istanzia l'oggetto dell'utente db:
	    $mail = new Mail();

	    // Prende l'utente corrente:
	    $rowset = $mail->find($mail_id);
	    if ($rowset > 0) {
	        $row = $rowset->current();
	        $row->pw = $pw;
	        $row->save();
	    }

	    $this->_helper->AjaxContext();
	}
}
