<?php

// Zend Controller Action
require_once 'Zend/Controller/Action.php';

class MailDomainsController extends Neikos_Controller_AdminAction {
	private $filtriRicerca;
	private $page;
	private $item_per_page = 50;

	/**
	 * Nome della sessione utilizzata per la posta.
	 */
	const MAIL_DOMAINS_SESSION = "dbtech_mail_domains";

	/**
 	 * Redirige sull'azione "view".
	 */
	public function indexAction() {
		return $this->_helper->redirector("view", $this->getRequest()->getControllerName());
	}

	/**
	 * Lista dei domini di posta presenti.
	 */
	public function viewAction() {
		// Setta i filtri di ricerca:
    	$this->_setFiltri();

		// Domini di posta:
		$mail_domains = new MailDomains();
		$mail_domains->setFiltri($this->filtriRicerca);

		// Clienti:
		$clients = new Clients();

		// Server:
		$servers = new Servers();
		$selServers = $mail_domains->select()->from($mail_domains, array("server_id"))->distinct();

		// Dati della pagina:
		$this->view->title = "Lista domini di posta";
		$this->view->headTitle("Lista domini di posta");
		$this->view->headScript()->appendFile("/scripts/js/scriptaculous/scriptaculous.js", "text/javascript")
								 ->appendFile("/scripts/js/mail-domains/view.js", "text/javascript");

		$this->view->modulo = "Domini di Posta";
		$this->view->filtriRicerca = $this->filtriRicerca;
		$this->view->listaClientiAttivi = $clients->fetchAll($clients->select()->from($clients, array("ID", "name"))->where("kategorie != 5")->where("parent = '0'")->order("name ASC"));
		$this->view->listaClientiFermati = $clients->fetchAll($clients->select()->from($clients, array("ID", "name"))->where("kategorie = 5")->where("parent = '0'")->order("name ASC"));
		$this->view->listaServer = $servers->fetchAll($servers->select()->where("id IN (" . $selServers->__toString() . ")")->order(array("is_neikos ASC", "name ASC")));

		$this->view->mail_domains = $mail_domains->getPage($this->page, $this->item_per_page);

		// Helper per il paginatore:
		$this->view->pagination_config = array( 'total_items'    => $mail_domains->count(),
                                               	'items_per_page' => $this->item_per_page,
                                               	'style'          => 'default'
       	);
	}

	/**
     * Salva il cliente associato ad un dominio di posta.
     */
    public function saveclientsAction() {
    	// Disattiva il layout in questa azione:
    	$this->_helper->layout()->disableLayout();

    	// Fa passare solo le richiesta asincrone.
    	if (!$this->getRequest()->isXmlHttpRequest()) {
    		return $this->_helper->redirector('index', 'index');
        }

    	// Dati del cliente e del dominio:
    	$mail_domain_id = (int)$this->getRequest()->getParam('mail_domain_id', null);
    	$client_id = (int)$this->getRequest()->getParam('client_id', null);

    	$set = array(
    		"project_id" => ($client_id>0) ? $client_id : null
    	);

    	// Istanzia l'oggetto Domains:
    	$mail_domains = new MailDomains();

    	// Di quali domini modificare il cliente:
    	$where = $mail_domains->getAdapter()->quoteInto("id = ?", $mail_domain_id);

    	// Effettua la modifica:
    	$updateSuccess = $mail_domains->update($set, $where);

    	$this->_helper->AjaxContext();
    }


	private function _getSession() {
		// Gestisce la sessione:
		$mailDomainsSession = new Zend_Session_Namespace(self::MAIL_DOMAINS_SESSION);
		$mailDomainsSession->setExpirationSeconds(3600);

		return $mailDomainsSession;
	}

	/**
	 * Setta i filtri di ricerca in base al POST o alla
	 * variabili contenute nella sessione.
	 */
	private function _setFiltri() {
		$mailDomainsSession = $this->_getSession();

		// Sblocca la sessione per il suo utilizzo:
		if ($mailDomainsSession->isLocked()) {
	    	$mailDomainsSession->unLock();
		}

		// Pagina di visualizzazione:
    	$this->page = (int)$this->getRequest()->getParam('page');

    	// Record per pagina:
    	$ipp = (int)$this->getRequest()->getParam('ipp');
    	if ($ipp > 0) {
    		$this->item_per_page = $mailDomainsSession->item_per_page = $ipp;
    	} else {
    		if ($mailDomainsSession->item_per_page > 0) {
    			$this->item_per_page = $mailDomainsSession->item_per_page;
    		} else {
    			$this->item_per_page = $mailDomainsSession->item_per_page = 50;
    		}
    	}

    	// Azione da intraprendere:
		$cercaButton = $this->getRequest()->getParam('cercaButton');
    	$azzeraButton = $this->getRequest()->getParam('azzeraButton');

		if (isset($cercaButton)) { // Prende i filtri dal POST:
			// Catena di filtri per eliminare l'HTML e togliere
			// gli spazi vuoti:
			$generalFilter = new Zend_Filter();
			$generalFilter->addFilter(new Zend_Filter_StripTags())
						  ->addFilter(new Zend_Filter_StringTrim());

			$filters = array(
				"*"     	  => $generalFilter,
				"q"			  => new Zend_Filter_StringTrim(),
				"project_id"  => "Int",
				"server_id"   => "Int"
			);

			$this->filtriRicerca = new Zend_Filter_Input($filters, null, $this->getRequest()->getPost());
			$mailDomainsSession->filtriRicerca = $this->filtriRicerca;
			$this->page = 1;
		} else if (isset($azzeraButton)) {
			// Azzera i filtri di ricerca:
			$this->filtriRicerca = $mailDomainsSession->filtriRicerca = new Zend_Filter_Input(null, null, null);
			$this->page = 1;
		} else {
			// Prende i filtri dalla sessione:
			if (!isset($mailDomainsSession->filtriRicerca)) {
				$mailDomainsSession->filtriRicerca = new Zend_Filter_Input(null, null, null);
			}

			$this->filtriRicerca = $mailDomainsSession->filtriRicerca;
		}

		// Blocca l'utilizzo della sessione:
		$mailDomainsSession->lock();
	}
}

?>