<?php

// Zend Controller Action
require_once 'Zend/Controller/Action.php';

class ServersController extends Neikos_Controller_AdminAction {
    /**
     * Redirige sull'azione "view".
     */
    public function indexAction() {
        $this->_forward("view");
    }


	/**
	 * Azione "view": quella che riguarda la lista
	 * dei server presenti.
	 */
    public function viewAction() {
    	// Oggetto server:
    	$servers = new Servers();

    	// Dati da passare alla vista:
    	$this->view->headTitle("Lista server presenti");
		$this->view->modulo = "Server";

		$this->view->servers_attivi = $servers->getLista("s.stato='A'");
		$this->view->servers_non_attivi = $servers->getLista("s.stato='D'");
    }


	/**
	 * Azione "modify": modifica i dati dei server.
	 */
    public function modifyAction() {
    	// Model:
        $server = new Servers();

        // Form:
        $form = new Default_Form_Server();

        // Request:
        $request = $this->getRequest();

        // Id del record da modificare:
        $id = (int)$request->getParam("id", 0);

        // Prende il record:
        $rowset = $server->find($id);

        if (count($rowset) == 0) {
            // Record non trovato:
            Neikos_Systemmessage::push("Il record #" . $id . " non &egrave; stato trovato.", Neikos_Systemmessage::MSG_ERRORE);

            return $this->_helper->redirector('view', 'servers');
        }

        // Record:
        $row = $rowset->current();

        // In caso di POST sulla pagina:
        if ($request->isPost()) {
            if ($form->isValid($request->getPost())) {
                // Modifica il record:
                $row->setFromArray($form->getValues());
                $row->save();

                // Redirige alla lista dei domini:
                return $this->_helper->redirector('view', 'servers');
            }
        } else {
            // Precarica i dati del record:
            $form->populate($row->toArray());
        }

        // Dati generali della vista:
        $this->view->title = "Modifica server";
        $this->view->modulo = "Server";
        $this->view->headTitle("Modifica server");
        $this->view->form = $form;
    }


	/**
 	 * Aggiunge un nuovo server.
     */
	public function addAction() {
		// Model:
    	$server = new Servers();

    	// Form:
    	$form = new Default_Form_Server();

    	// Request:
    	$request = $this->getRequest();

    	// In caso di POST sulla pagina:
    	if ($request->isPost()) {
    	    if ($form->isValid($request->getPost())) {
    	        // Inserisce il nuovo record:
    	        $newRow = $server->createRow($form->getValues());
    	        $newRow->save();

    	        // Redirige alla lista dei software:
    	        return $this->_helper->redirector('view', 'servers');
    	    }
    	}

    	// Dati generali della vista:
    	$this->view->title = "Nuovo server";
    	$this->view->modulo = "Server";
    	$this->view->headTitle("Nuovo server");
    	$this->view->form = $form;
	}


	/**
	 * Cancella un server
	 */
	public function deleteAction() {
	    // Model:
	    $serverModel = new Servers();

	    // Request:
	    $request = $this->getRequest();

	    // Id del record da modificare:
	    $id = (int)$request->getParam("id", 0);

	    // Prende il record:
	    $rowset = $serverModel->find($id);

	    if (count($rowset) == 0) {
	        // Record non trovato:
	        Neikos_Systemmessage::push("Il record #" . $id . " non &egrave; stato trovato.", Neikos_Systemmessage::MSG_ERRORE);

	        return $this->_helper->redirector('view', 'servers');
	    }

	    $server = $rowset->current();

	    // Prima di cancellare un server controlla che non ci siano record associati, altrimenti blocca la cancellazione.
	    if ($server->canBeDeleted()) {
	        $server->delete();

	        return $this->_helper->redirector('view', 'servers');
	    }

	    // Dati generali della vista:
	    $this->view->title = "Cancellazione server";
	    $this->view->modulo = "Server";
	    $this->view->headTitle("Cancellazione server");
	    $this->view->server = $server;
	}

	public function summaryAction() {
	    // Server:
	    $server_id = $this->getRequest()->getParam('server_id');

	    // Dati del server:
	    $servers = new Servers();
	    $server = $servers->find($server_id)->current();

	    // Se il server non esiste...
	    if ($server == null) {
	        // ...rimanda alla home:
	        return $this->_helper->redirector("index", "index");
	    }

	    // Dati della pagina:
	    $titolo = sprintf("Riepilogo server #%d", $server_id);
	    $this->view->title = $titolo;
	    $this->view->headTitle($titolo);
	    $this->view->modulo = "Server";
	    $this->view->server = $server;
	    $this->view->editMode = false;

	    // Domini:
	    $domains = new Domains();
	    $listaDomini = $domains->select()
	                           ->where("server_id = ?", $server_id)
	                           ->where("parent_id IS NULL OR parent_id = '0'")
	                           ->order("name ASC");
	    $this->view->listDomains = $domains->fetchAll($listaDomini);

	    // Dns:
	    $dns = new Dns();
	    $listaDns = $dns->select()
	                    ->where("server_id = ?", $server_id)
	                    ->order("name ASC");
	    $this->view->listDns = $dns->fetchAll($listaDns);

	    // Mail:
	    $mail = new Mail();
	    $listaMail = $mail->select()
	                      ->from($mail)
	                      ->joinleft(array("md"=>"mail_domains"), "md.id=mail.mail_domains_id", array())
	                      ->where("md.server_id = ?", $server_id)
	                      ->order(array("md.name", "mail.user"));
	    $this->view->listMail = $mail->fetchAll($listaMail);

	    // Database:
	    $database = new Database();
	    $listaDatabase = $database->select()
	                              ->from($database)
	                              ->where("server_id = ?", $server_id)
	                              ->order(array("nome"));
	    $this->view->listDatabase = $database->fetchAll($listaDatabase);

	    // FTP:
	    $ftp = new Ftp();
	    $listaFtp = $ftp->select()
	                    ->from($ftp)
	                    ->where("server_id = ?", $server_id)
	                    ->order(array("user"));
	    $this->view->listaFtp = $ftp->fetchAll($listaFtp);

	    // Software:
	    $software = new Software();
	    $listaSoftware = $software->select()
	                              ->where("server_id = ?", $server_id)
	                              ->order("id DESC");
	    $this->view->listSoftware = $software->fetchAll($listaSoftware);

	    // ID del server:
	    $this->view->id = $server_id;
	}
}

