<?php

// Zend Controller Action
require_once 'Zend/Controller/Action.php';

class SoftwareController extends Neikos_Controller_AdminAction {
	/**
	 * Nome della sessione utilizzata per i software.
	 */
	const SOFTWARE_SESSION = "dbtech_software_session";

	protected function _getSession() {
		// Gestisce la sessione:
		$softwareSession = new Zend_Session_Namespace(self::SOFTWARE_SESSION);
		$softwareSession->setExpirationSeconds(3600);

		return $softwareSession;
	}

	protected function _setFiltri() {
		$softwareSession = $this->_getSession();

		// Sblocca la sessione per il suo utilizzo:
		if ($softwareSession->isLocked()) {
	    	$softwareSession->unLock();
		}

		// Pagina di visualizzazione:
    	$this->_page = (int)$this->getRequest()->getParam('page');

    	// Record per pagina:
    	$ipp = (int)$this->getRequest()->getParam('ipp');
    	if ($ipp > 0) {
    		$this->_item_per_page = $softwareSession->item_per_page = $ipp;
    	} else {
    		if ($softwareSession->item_per_page > 0) {
    			$this->_item_per_page = $softwareSession->item_per_page;
    		} else {
    			$this->_item_per_page = $softwareSession->item_per_page = 25;
    		}
    	}

    	// Azione da intraprendere:
		$cercaButton = $this->getRequest()->getParam('cercaButton');
    	$azzeraButton = $this->getRequest()->getParam('azzeraButton');

		if (isset($cercaButton)) { // Prende i filtri dal POST:
			// Catena di filtri per eliminare l'HTML e togliere
			// gli spazi vuoti:
			$generalFilter = new Zend_Filter();
			$generalFilter->addFilter(new Zend_Filter_StripTags())
						  ->addFilter(new Zend_Filter_StringTrim());

			$filters = array(
				"*"     			=> $generalFilter,
				"client_id"  		=> "Int",
			    "server_id"  		=> "Int",
				"software_tipo_id"  => "Int",
				"name"		 		=> "BaseName",
			    "versione"		    => "BaseName",
			    "plugin_version"	=> "BaseName"
			);
			$this->_filtriRicerca = new Zend_Filter_Input($filters, null, $this->getRequest()->getPost());
			$softwareSession->filtriRicerca = $this->_filtriRicerca;
			$this->page = 1;
		} else if (isset($azzeraButton)) {
			// Azzera i filtri di ricerca:
			$this->_filtriRicerca = $softwareSession->filtriRicerca = new Zend_Filter_Input(null, null, null);
			$this->_page = 1;
		} else {
			// Prende i filtri dalla sessione:
			if (!isset($softwareSession->filtriRicerca)) {
				$softwareSession->filtriRicerca = new Zend_Filter_Input(null, null, null);
			}

			$this->_filtriRicerca = $softwareSession->filtriRicerca;
		}

		// Blocca l'utilizzo della sessione:
		$softwareSession->lock();
	}


	/**
	 * Nome della sessione utilizzata per i plugin software.
	 */
	const SOFTWARE_PLUGIN_SESSION = "dbtech_software_plugin_session";

	protected function _getSessionPlugin() {
	    // Gestisce la sessione:
	    $softwarePluginSession = new Zend_Session_Namespace(self::SOFTWARE_PLUGIN_SESSION);
	    $softwarePluginSession->setExpirationSeconds(3600);

	    return $softwarePluginSession;
	}

	protected function _setFiltriPlugin() {
	    $softwarePluginSession = $this->_getSessionPlugin();

	    // Sblocca la sessione per il suo utilizzo:
	    if ($softwarePluginSession->isLocked()) {
	        $softwarePluginSession->unLock();
	    }

	    // Pagina di visualizzazione:
	    $this->_page = (int)$this->getRequest()->getParam('page');

	    // Record per pagina:
	    $ipp = (int)$this->getRequest()->getParam('ipp');
	    if ($ipp > 0) {
	        $this->_item_per_page = $softwarePluginSession->item_per_page = $ipp;
	    } else {
	        if ($softwarePluginSession->item_per_page > 0) {
	            $this->_item_per_page = $softwarePluginSession->item_per_page;
	        } else {
	            $this->_item_per_page = $softwarePluginSession->item_per_page = 25;
	        }
	    }

	    // Azione da intraprendere:
	    $cercaButton = $this->getRequest()->getParam('cercaButton');
	    $azzeraButton = $this->getRequest()->getParam('azzeraButton');

	    if (isset($cercaButton)) { // Prende i filtri dal POST:
	        // Catena di filtri per eliminare l'HTML e togliere
	        // gli spazi vuoti:
	        $generalFilter = new Zend_Filter();
	        $generalFilter->addFilter(new Zend_Filter_StripTags())
	                      ->addFilter(new Zend_Filter_StringTrim());

	        $filters = array(
	            "*"     			=> $generalFilter,
	            "software_tipo_id"  => "Int",
	            "name"		 		=> "BaseName"
	        );
	        $this->_filtriRicerca = new Zend_Filter_Input($filters, null, $this->getRequest()->getPost());
	        $softwarePluginSession->filtriRicerca = $this->_filtriRicerca;
	        $this->page = 1;
	    } else if (isset($azzeraButton)) {
	        // Azzera i filtri di ricerca:
	        $this->_filtriRicerca = $softwarePluginSession->filtriRicerca = new Zend_Filter_Input(null, null, null);
	        $this->_page = 1;
	    } else {
	        // Prende i filtri dalla sessione:
	        if (!isset($softwarePluginSession->filtriRicerca)) {
	            $softwarePluginSession->filtriRicerca = new Zend_Filter_Input(null, null, null);
	        }

	        $this->_filtriRicerca = $softwarePluginSession->filtriRicerca;
	    }

	    // Blocca l'utilizzo della sessione:
	    $softwarePluginSession->lock();
	}


	/**
	 * Redirige sull'azione "view".
	 */
	public function indexAction() {
		$this->_forward("view");
	}


	public function setFiltersAction() {
	    // Prende i filtri:
	    $encodedFilters = $this->_request->getParam("filters");

	    // Li decoda:
	    $filters = @Zend_Json::decode(@base64_decode($encodedFilters));

	    // Setta i filtri in sessione, simulando nu POST:
	    $this->getRequest()->setPost($filters);
	    $this->getRequest()->setParam("cercaButton", 1);
	    $this->_setFiltri();

	    return $this->_helper->redirector('view', 'software');
	}


	public function viewAction() {
		// Setta i filtri di ricerca:
    	$this->_setFiltri();

    	// Setta i filtri di ricerca nel model:
    	$software = new Software();
    	$software->setFiltri($this->_filtriRicerca);

    	// Clienti:
		$clients = new Clients();

		// Server:
		$servers = new Servers();
		$selServers = $software->select()->from($software, array("server_id"))->distinct();

		// Dati della pagina:
		$this->view->title = "Lista software";
		$this->view->headTitle("Lista software");
		$this->view->headScript()->appendFile("/scripts/js/view.js", "text/javascript");

		$this->view->modulo = "Software";
		$this->view->filtriRicerca = $this->_filtriRicerca;
		$this->view->listaTipiSoftware = Software_Tipo::getListaPerSelect();
		$this->view->listaClientiAttivi = $clients->fetchAll($clients->select()->from($clients, array("ID", "name"))->where("kategorie != 5")->where("parent = '0'")->order("name ASC"));
		$this->view->listaClientiFermati = $clients->fetchAll($clients->select()->from($clients, array("ID", "name"))->where("kategorie = 5")->where("parent = '0'")->order("name ASC"));
		$this->view->listaServer = $servers->fetchAll($servers->select()->where("id IN (" . $selServers->__toString() . ")")->order(array("is_neikos ASC", "name ASC")));

		// Dati della pagina:
		$this->view->editMode = true;
		$this->view->listSoftware = $software->getPage($this->_page, $this->_item_per_page);

		// Helper per il paginatore:
		$this->view->pagination_config = array(
		    'total_items'    => $software->count(),
            'items_per_page' => $this->_item_per_page,
            'style'          => 'default'
       	);
	}


	public function addAction() {
		// Model:
    	$software = new Software();

    	// Form:
    	$form = new Default_Form_Software();

    	// Request:
    	$request = $this->getRequest();

    	// In caso di POST sulla pagina:
    	if ($request->isPost()) {
	    	if ($form->isValid($request->getPost())) {
	    		// Inserisce il nuovo record:
				$newRow = $software->createRow($form->getValues());
				$newRow->save();

				// Redirige alla lista dei software:
            	return $this->_helper->redirector('view', 'software');
	        }
    	}

    	// Dati generali della vista:
		$this->view->title = "Nuovo software";
		$this->view->modulo = "Software";
    	$this->view->headTitle("Nuovo software");
		$this->view->form = $form;
	}


	public function modifyAction() {
		// Model:
    	$software = new Software();

    	// Form:
    	$form = new Default_Form_Software();

    	// Request:
    	$request = $this->getRequest();

    	// Id del record da modificare:
    	$id = (int)$request->getParam("id", 0);

    	// Prende il record:
    	$rowset = $software->find($id);

    	if (count($rowset) == 0) {
    		// Record non trovato:
			Neikos_Systemmessage::push("Il record #" . $id . " non &egrave; stato trovato.", Neikos_Systemmessage::MSG_ERRORE);

    		return $this->_helper->redirector('view', 'software');
    	}

    	// Record:
    	$row = $rowset->current();

    	// In caso di POST sulla pagina:
    	if ($request->isPost()) {
	    	if ($form->isValid($request->getPost())) {
	    		// Modifica il record:
				$row->setFromArray($form->getValues());
				$row->save();

				// Redirige alla lista dei domini:
            	return $this->_helper->redirector('view', 'software');
	        }
    	} else {
    		// Precarica i dati del record:
    		$form->populate($row->toArray());
    	}

    	// Dati generali della vista:
		$this->view->title = "Modifica software";
		$this->view->modulo = "Software";
    	$this->view->headTitle("Modifica software");
		$this->view->form = $form;
	}


	public function deleteAction() {
		if ($this->getRequest()->isPost()) {
			$delete = $this->getRequest()->getParam('delete');
			if (is_array($delete)) {
				// Casta a int tutti i record dell'array:
				foreach ($delete as $k => $v) {
					$delete[$k] = (int)$v;
				}
				$dDelete = "'" . implode("', '", $delete) . "'";

				$software = new Software();
				$software->delete(sprintf("id IN (%s)", $dDelete));
			}
		}

		return $this->_helper->redirector('view', 'software');
	}


	public function tipoAction() {
		// Form:
    	$form = new Default_Form_SoftwareTipo();

    	// Request:
    	$request = $this->getRequest();

    	// Model:
    	$software = new Software();
    	$softwareTipo = new Software_Tipo();

    	if ($request->isPost()) {
    		if ($form->isValid($request->getPost())) {
				$oldTipoSoftId = $form->getValue("software_tipo_id");
				$action = $form->getValue("action");

				// Prende il vecchio record:
				$rowset = $softwareTipo->find($oldTipoSoftId);
				$oldTipoSoft = $rowset->current();

				if ($action == "delTipoSoft") {
					// Eliminazione del tipo:
					$nuovoTipoId = (int)$form->getValue("new_software_tipo_id");

					// Passa i software al nuovo tipo:
					$software->moveByTipo($oldTipoSoftId, $nuovoTipoId);

					// Elimina il vecchio tipo:
					$oldTipoSoft->delete();
				} else {
					// Modifica del nome:
					$nuovoNome = $form->getValue("new_software_tipo_name");

					// Prende il record:
					$oldTipoSoft->tipo = $nuovoNome;
					$oldTipoSoft->save();
				}

				// Si redirige alla view:
				return $this->_helper->redirector('tipo', 'software');
	    	}
    	}

		// Dati generali della vista:
		$this->view->title = "Gestisci tipo software";
		$this->view->modulo = "Software";
    	$this->view->headTitle("Gestisci tipo software");
		$this->view->form = $form;
	}


	public function svnAction() {
		// Dati generali della vista:
		$this->view->title = "Software sotto SVN";
		$this->view->headTitle("Software sotto SVN");
		$this->view->modulo = "Software";

		$directory = '/var/lib/svn';
		$this->view->svnlist = @array_diff(@scandir($directory), array('..', '.'));
	}


	/**
	 * Lista dei plugin presenti
	 */
	public function pluginAction() {
	    // Setta i filtri di ricerca:
	    $this->_setFiltriPlugin();

	    // Setta i filtri di ricerca nel model:
	    $softwarePlugin = new Software_Plugin();
	    $softwarePlugin->setFiltri($this->_filtriRicerca);

	    // Dati generali della vista:
	    $this->view->title = "Lista plugin software";
	    $this->view->headTitle("Lista plugin software");
	    $this->view->modulo = "Software";

	    $this->view->filtriRicerca = $this->_filtriRicerca;
	    $this->view->listaTipiSoftware = Software_Tipo::getListaPerSelect();

	    // Dati della pagina:
	    $this->view->listSoftwarePlugin = $softwarePlugin->getPage($this->_page, $this->_item_per_page);

	    // Helper per il paginatore:
	    $this->view->pagination_config = array(
	        'total_items'    => $softwarePlugin->count(),
	        'items_per_page' => $this->_item_per_page,
	        'style'          => 'default'
	    );
	}


	/**
	 * Aggiunta di un nuovo plugin
	 */
	public function pluginAddAction() {
	    // Dati generali della vista:
	    $this->view->title = "Nuovo plugin software";
	    $this->view->headTitle("Nuovo plugin software");
	    $this->view->modulo = "Software";

	    // Form:
	    $form = new Default_Form_SoftwarePlugin();

	    // Model:
	    $softwarePlugin = new Software_Plugin();

	    // Request:
	    $request = $this->getRequest();

	    // In caso di POST sulla pagina:
	    if ($request->isPost()) {
	        if ($form->isValid($request->getPost())) {
	            // Inserisce il nuovo record:
	            $newRow = $softwarePlugin->createRow($form->getValues());
	            $newRow->save();

	            // Redirige alla lista dei software:
	            return $this->_helper->redirector('plugin', 'software');
	        }
	    }

	    $this->view->form = $form;
	}


	/**
	 * Modifica di un nuovo plugin
	 */
	public function pluginModifyAction() {
	    // Model:
	    $softwarePlugin = new Software_Plugin();

	    // Id del plugin da modificare:
	    $id = (int)$this->_request->getParam("id");

	    // Form:
	    $form = new Default_Form_SoftwarePlugin(array(
	        "operation" => Default_Form_SoftwarePlugin::OP_MODIFY
	    ));

	    // Cerca il plugin sul db:
	    $rowset = $softwarePlugin->find($id);
	    if (count($rowset) == 1) {
            $row = $rowset->current();
            $form->setDefaults($row->toArray());
	    } else {
	        // Errore:
	        Neikos_Systemmessage::push("Plugin non trovato.", Neikos_Systemmessage::MSG_ERRORE);

	        // Redirige alla lista dei software:
	        return $this->_helper->redirector('plugin', 'software');
	    }

	    // Dati generali della vista:
	    $this->view->title = "Modifica plugin software";
	    $this->view->headTitle("Modifica plugin software");
	    $this->view->modulo = "Software";

	    // Request:
	    $request = $this->getRequest();

	    // In caso di POST sulla pagina:
	    if ($request->isPost()) {
	        if ($form->isValid($request->getPost())) {
	            // Inserisce il nuovo record:
	            $row->setFromArray($form->getValues());
	            $row->save();

	            // Redirige alla lista dei software:
	            return $this->_helper->redirector('plugin', 'software');
	        }
	    }

	    $this->view->form = $form;
	}


	/**
	 * Cancellazione di un plugin
	 */
	public function pluginDeleteAction() {
	    // Model:
	    $softwarePlugin = new Software_Plugin();

        // Id del plugin da cancellare:
	    $id = (int)$this->_request->getParam("id");

	    // Verifica se l'id è corretto:
	    $rowset = $softwarePlugin->find($id);
	    if (count($rowset) == 0) {
	        // Mostra un messaggio di errore:
	        Neikos_Systemmessage::push("Pugin non trovato.", Neikos_Systemmessage::MSG_ERRORE);
	    } else {
    	    $row = $rowset->current();

            // Verifica i software associati:
            $rowsetSoftware = $row->findDependentRowset("Software_To_Plugin");

            if (count($rowsetSoftware) > 0) {
                // Mostra un messaggio di errore:
                Neikos_Systemmessage::push("Prima di cancellare il plugin, eliminare i software associati.", Neikos_Systemmessage::MSG_ERRORE);
            } else {
                // Prodede alla cancellazione:
                $row->delete();
            }
	    }

        // Si redirige alla lista dei plugin:
        return $this->_helper->redirector('plugin', 'software');
	}



    /**
     * Plugin collegati ad un software
     */
	public function pluginRelatedAction() {
	    // Model:
	    $softwareModel = new Software();

	    // Request:
	    $request = $this->getRequest();
	    $software_id = $request->getParam("software_id");

	    // Verifica se il software passato è corretto:
	    $softwareRowset = $softwareModel->find($software_id);

	    if ($softwareRowset->count() == 0) {
	        // Software non corretto, redirige alla lista dei software:
	        return $this->_helper->redirector('view', 'software');
	    }

	    // Software:
	    $software = $softwareRowset->current();

	    // Lista dei plugin associati:
	    $listPlugin = $software->findDependentRowset("Software_To_Plugin");

	    // Dati generali della vista:
	    $this->view->title = "Plugin associati";
	    $this->view->headTitle("Plugin associati");
	    $this->view->modulo = "Software";

	    $this->view->software = $software;
	    $this->view->listPlugin = $listPlugin;
	}


	/**
	 * Associa un plugin ad un software presente sul db
	 */
	public function toPluginAction() {
	    // Model:
	    $softwareToPlugin = new Software_To_Plugin();

	    // Request:
	    $request = $this->getRequest();
	    $software_id = $request->getParam("software_id");
	    $software_plugin_id = $request->getParam("software_plugin_id");

        // Form:
        $form = new Default_Form_SoftwareToPlugin(
            array(
                "software_id"        => $software_id,
                "software_plugin_id" => $software_plugin_id
            )
        );

        // Software associato al form:
        $software = $form->getSoftware();
        if ($software == null) {
            return $this->_helper->redirector('view', 'software');
        }

        // Verifica se si tratta di una modifica:
        $softwarePlugin = $form->getSoftwarePlugin();
        if ($softwarePlugin != null) {
            $rowset = $softwareToPlugin->find($software->id, $softwarePlugin->id);
            if (count($rowset) == 1) {
                // Modifica:
                $row = $rowset->current();
                $form->setDefaults($row->toArray());
            } else {
                // Inserimento:
                $row = $softwareToPlugin->createRow($form->getValues());
            }
        }

	    // Dati generali della vista:
	    $this->view->title = "Associa plugin";
	    $this->view->headTitle("Associa plugin");
	    $this->view->modulo = "Software";

	    // In caso di POST sulla pagina:
	    if ($request->isPost()) {
	        if ($form->isValid($request->getPost())) {
	            $row->setFromArray($form->getValues());
	            $row->save();

	            // Redirige alla lista dei software:
	            return $this->_helper->redirector('plugin-related', 'software', null, array("software_id" => $software_id));
	        }
	    }

	    $this->view->form = $form;
	}


	/**
	 * Elimina un'associazione tra un plugine e un software.
	 */
	public function toPluginDeleteAction() {
	    // Request:
	    $request = $this->getRequest();
	    $software_id = $request->getParam("software_id");
	    $software_plugin_id = $request->getParam("software_plugin_id");

	    $model = new Software_To_Plugin();
	    $model->delete(
	        $model->getAdapter()->quoteInto("software_id = ?", (int)$software_id) . " AND " .
	        $model->getAdapter()->quoteInto("software_plugin_id = ?", (int)$software_plugin_id)
	    );

	    // Redirige alla lista dei software:
	    return $this->_helper->redirector('plugin-related', 'software', null, array("software_id" => $software_id));
	}
}