<?php

// Zend Controller Action
require_once 'Zend/Controller/Action.php';

class UpdatesController extends Neikos_Controller_AdminAction {
	public function indexAction() {
		// Aggiornamenti:
		$updates = new Updates();

		// Server:
		$serverModel = new Servers();

		// Tutti i server in archivio:
		$selServer = $serverModel->select()->from($serverModel)
		                         ->where("stato = ?", Servers::STATO_ATTIVO)
		                         ->where("aggiornabile = ?", Servers::AGGIORNABILE_SI)
		                         ->order("name ASC");

		// Request:
		$request = $this->getRequest();

		// Tipi di aggiornamento possibili:
		$updateTypes = Updates::getUpdateTypes();

		// Controlla che non siano stati passati dei dati in POST nel qual caso
		// procede al salvataggio dei nuovi dati:
		if ($request->isPost()) {
			$aggiornamento = (array)$request->getParam("aggiornamento");
			$server_id = (int)$request->getParam("server_id");

            // Prende solo i parametri validi tra quelli specificati:
			$aggiornamento = array_intersect($aggiornamento, array_keys($updateTypes));
			if (count($aggiornamento) == 0) {
			    Neikos_Systemmessage::push("Specificare cosa aggiornare", Neikos_Systemmessage::MSG_ERRORE);
			}

			// Prende il server passato o la lista di tutti i server:
			$serverAgg = $serverModel->find($server_id);
			if (count($serverAgg) == 0) {
				$serverAgg = $serverModel->fetchAll($selServer);
			}

			if (count($serverAgg) > 0 && count($aggiornamento) > 0) {
			    $contErr = 0;

			    // Cicla sui server, segnando solo quelli permessi:
				foreach ($serverAgg as $server) {
				    $allowedUpdates = $server->allowed_updates;

					foreach ($aggiornamento as $agg) {
					    if (@in_array($agg, $allowedUpdates) && $server->stato == Servers::STATO_ATTIVO && $server->aggiornabile == Servers::AGGIORNABILE_SI) {
    						$row = array(
    							"server_id"	=> $server->id,
    							"modulo"	=> $agg,
    							"status" 	=> "A",
    							"data_ins"  => date("Y-m-d H:i:s")
    						);
    						$updates->insert($row);
					    } else {
					        $contErr++;
					    }
					}
				}

				// Eventuale messaggio di errore:
				if ($contErr > 0) {
				    Neikos_Systemmessage::push("Aggiornamenti immediati non permessi: " . $contErr, Neikos_Systemmessage::MSG_ERRORE);
				}

				return $this->_helper->redirector("index", $this->getRequest()->getControllerName());
			}
		}

		// Dati da passare alla vista:
		$this->view->headTitle("Richiedi aggiornamenti immediati");
		$this->view->modulo = "Aggiornamenti dati dai server";
		$this->view->title  = "Richiedi aggiornamenti immediati";
		$this->view->update_types = $updateTypes;
		$this->view->servers = $serverModel->fetchAll($selServer);
		$this->view->updates = $updates->fetchAll($updates->select()->order("id DESC")->limit(50));
	}
}
