<?php

// Zend Controller Action
require_once 'Zend/Controller/Action.php';

class UsersController extends Neikos_Controller_Action {
	private $_auth_session = null;

	public function __construct(Zend_Controller_Request_Abstract $request, Zend_Controller_Response_Abstract $response, array $invokeArgs = array()) {
		// Gestisce la sessione di autenticazione:
		$this->_auth_session = new Zend_Session_Namespace('auth');

		parent::__construct($request, $response, $invokeArgs);
	}

	public function loginAction() {
		// Request:
		$request = $this->_request;

		// Dati della request:
		$loginButton = $request->getParam("loginButton", null);
		$username = $request->getParam("username");
		$password = $request->getParam("password");

		if (isset($loginButton)) {
			$this->authenticate($username, $password);
		}

		if ($this->_auth_session->autenticato) {
			// Verifica la pagina di proveniente se presente:
			$url = $this->_getPostLoginRedirectUrl();
			if ($url != null) {
				return $this->_redirect($url);
			}

			// ... altrimenti redirige l'utente all'home:
			return $this->_helper->getHelper("redirector")->goto("index", "index");
		}

		// Dati della pagina:
		$this->view->headTitle("Login");
	}

    /**
     * Effettua l'autenticazione.
     */
    protected function authenticate($username, $password) {
    	// Sblocca la sessione per il suo utilizzo:
		if ($this->_auth_session->isLocked()) {
	    	$this->_auth_session->unLock();
		}

		// Azzera le variabili:
		$userData = array();
		$errorCode = 0;

		// Controlla le credenziali:
		$ris = Users::checkCredenziali($username, $password, $userData, $errorCode);

		// Verifica se l'utente è corretto:
		if (!$ris) {
			$autenticato = false;

			switch ($errorCode) {
				case Users::ERROR_CODE_ROLE_NOT_VALID:
					$errMsg = "Non sei autorizzato ad accedere.";
					break;

				case Users::ERROR_CODE_INVALID_CREDENTIAL:
				default:
					$errMsg = "Nome utente o password errata.";
					break;
			}

			Neikos_Systemmessage::push($errMsg, Neikos_Systemmessage::MSG_ERRORE);
		} else {
			$autenticato = true;

			// Dati della sessione di autenticazione:
			$info = array();
			$info['nome'] 		= $userData["vorname"];
			$info['cognome']	= $userData["nachname"];
			$info['user'] 		= $userData["kurz"];
			$info['users_id'] 	= $userData["ID"];
			$info['username'] 	= $userData["loginname"];

			// Segna i dati dell'utente in sessione:
			$this->_auth_session->user_info = $info;

			// Segna l'autenticazione nel log:
			Neikos_Log::Write("Login");
		}

		// Segna il risultato dell'autenticazione in sessione:
		$this->_auth_session->autenticato = $autenticato;

		// Blocca la sessione:
		$this->_auth_session->lock();
	}

	public function logoutAction() {
		// Segna il logout nel log:
		Neikos_Log::Write("Logout");

    	// Sblocca la sessione per il suo utilizzo:
		if ($this->_auth_session->isLocked()) {
	    	$this->_auth_session->unLock();
		}

		// La resetta, effettuando il logout:
		$this->_auth_session->autenticato = false;
	    $this->_auth_session->info = array();

	    // La blocca di nuovo:
	    $this->_auth_session->lock();

	    // Redirige l'utente all'home:
		$this->_helper->getHelper("redirector")->goto("index", "index");
    }
}
