<?php

// Zend Controller Action
require_once 'Zend/Controller/Action.php';

class UtilityController extends Neikos_Controller_AdminAction {
	public function indexAction() {
		$this->_redirector = $this->_helper->getHelper('Redirector');

		// Codice 303: See Other.
		$this->_redirector->setCode(303)->setExit(false)
                          ->setGotoSimple("index", "index");
	}

	/**
	 * Mostra tutte le informazioni possibili sui domini eseguendo dei comandi.
	 */
	public function whoisAction() {
		// Dati della pagina:
		$this->view->title = "Whois";
		$this->view->headTitle("Whois");
		$this->view->modulo = "Utility";

		$retCmd = "";

		// Pagina di visualizzazione:
    	$domainName = stripslashes($this->getRequest()->getParam('domainName'));
		if (!empty($domainName)) {
			$command = "whois %s";
			$cmdline = sprintf($command, $domainName);

			$retCmd = "<h1>" . $cmdline . "</h1>"
					  ."<pre style='font-family:monospace; font-size:13px'>"
					  .trim(shell_exec($cmdline))
					  ."</pre>";
		}

		$this->view->retCmd 	= $retCmd;
		$this->view->domainName = $domainName;
	}


	/**
     * Risponde alle richieste in AJAX di quei clienti
     * che matchiano una certa stringa di ricerca.
     */
    public function autocompleteClientsAction()
    {
    	// Disattiva il layout in questa azione:
    	$this->_helper->layout()->disableLayout();

    	// Fa passare solo le richiesta asincrone:
    	if (!$this->getRequest()->isXmlHttpRequest()) {
    		return $this->_helper->redirector('index', 'index');
        }

        // Stringa di ricerca:
        $q = trim($this->getRequest()->getParam('q', null));

        // Cerca i clienti:
		$clients = new Clients();
		$select = $clients->select()->from($clients, array("id"=>"ID", "name"))->where("name LIKE ?", "%" . $q . "%")->where("parent = '0'");
		$matches = $clients->fetchAll($select);

		Zend_Controller_Action_HelperBroker::addPrefix('Neikos_Controller_Action_Helper');
		$this->_helper->MyAutoCompleteScriptaculous($matches);
    }


	/**
     * Risponde alle richieste in AJAX di quei software
     * che matchiano una certa stringa di ricerca.
     */
    public function autocompleteSoftwareAction()
    {
    	// Disattiva il layout in questa azione:
    	$this->_helper->layout()->disableLayout();

    	// Fa passare solo le richiesta asincrone:
    	if (!$this->getRequest()->isXmlHttpRequest()) {
    		return $this->_helper->redirector('index', 'index');
        }

        // Stringa di ricerca:
        $q = trim($this->getRequest()->getParam('q', null));

        // Cerca i clienti:
		$rowset = Software::findByUrl($q);

		$matches = array();
		if (count($rowset) > 0) {
			foreach ($rowset as $row) {
				$obj = new stdClass();
				$obj->id = $row->id;
				$obj->name = $row->getDescrizione();
				$matches[] = $obj;
			}
		}

		Zend_Controller_Action_HelperBroker::addPrefix('Neikos_Controller_Action_Helper');
		$this->_helper->MyAutoCompleteScriptaculous($matches);
    }


    public function dbmailNonAssociatiAction() {
    	// Tutti i dbmail:
		$dbmail = Dbmail::getAll();

		// Tutti i progetti:
		$clients = Clients::getAll();

		// Non associati correttamente:
		$nonAssociati = array();
		foreach ($dbmail AS $dbm) {
			$trovato = false;
			foreach ($clients AS $cliente) {
				if (eregi($cliente->name, $dbm->tabella)) {
					$trovato = true;
					break;
				}
			}

			if (!$trovato) {
				$nonAssociati[] = $dbm;
				$cont++;
			}
		}

		// Dati della view:
		$this->view->title = "Dbmail non associati";
		$this->view->headTitle("Dbmail non associati");
		$this->view->modulo = "Dbmail non associati";
		$this->view->nonAssociati = $nonAssociati;
    }
}

