<?php

class Default_Form_Database extends Zend_Form {
	public function init() {
		$this->setMethod('post');
		$this->setAction("#");

		// Lista dei clienti:
		$listaClienti = array("" => "- scegli -") +
						Clients::getListaPerSelect();

		// Lista dei server:
		$listaServer = array("" => "- scegli -") +
					   Servers::getListaPerSelect();

		// Nome db:
		$this->addElement("text", "nome", array(
			'label' 	  => "Nome db:",
			'required'    => true,
			'filters'     => array("StringTrim"),
			'validators'  => array(
				array(
					'validator' 			=> 'NotEmpty',
					'breakChainOnFailure'	=> true,
					'options' 				=> array('messages' => array(
						Zend_Validate_NotEmpty::IS_EMPTY => "Il campo &egrave; obbligatorio."
					))
				)
			)
    	));

    	$selectSoftware = $this->getSelectSoftware();

    	// Cliente:
		$projectElement = new Neikos_Form_Element_ComboSelect("project_id", array(
			'label' 		=> "Cliente:",
			'required'   	=> true,
			'multiOptions' 	=> $listaClienti,
			'validators' => array(
				array(
					'validator' 			=> 'NotEmpty',
					'breakChainOnFailure'	=> true,
					'options' 				=> array('messages' => array(
						Zend_Validate_NotEmpty::IS_EMPTY => "Il campo &egrave; obbligatorio."
					))
				)
			),
			'callback' => array(
				'callback' => array('Default_Form_Database', 'getSoftwareOption'),
				'elements' => array($selectSoftware)
            )
    	));
    	$this->addElement($projectElement);

    	// Server:
    	$this->addElement("select", "server_id", array(
			'label' 		=> "Server:",
    		'required'   	=> true,
			'multiOptions' 	=> $listaServer,
			'validators' => array(
				array(
					'validator' 			=> 'NotEmpty',
					'breakChainOnFailure'	=> true,
					'options' 				=> array('messages' => array(
						Zend_Validate_NotEmpty::IS_EMPTY => "Il campo &egrave; obbligatorio."
					))
				)
			)
    	));

    	// Software:
    	$this->addElement($selectSoftware);

    	// Note:
    	$this->addElement("textarea", "note", array(
			'label' 		=> "Note:",
    		'filters'    	=> array("StringTrim"),
			'validators' 	=> array(

    		)
    	));

    	$this->addElement("button", "salva", array(
			'label' => "Salva",
    	    'type'  => "submit"
    	));
	}


	/**
	 * Select del software
	 *
	 * @param int $client_id
	 * @param array $decorators
	 *
	 * @return Zend_Form_Element
	 */
	public function getSelectSoftware($client_id = null, $decorators = array()) {
		$element = $this->createElement("select", "software_id", array(
			'label' 		=> "Software associato:",
			'required'   	=> false,
			'validators' 	=> array(
	    		'Int'
    		)
    	));

    	$element->addDecorators(array(
    		array(
    			"HtmlTag", array("tag" => "span", "id" => "software_id_container")
    		)
    	));

    	self::getSoftwareOption($element, $client_id);

    	return $element;
	}


	/**
	 * Funzione di callback per l'aggiornamento del select
	 * dei software in funzione del cliente.
	 */
	public static function getSoftwareOption(Zend_Form_Element $element, $client_id = null) {
		$listaSoftware = array("" => "- scegli -");
		if ($client_id != null) {
			$listaSoftware += Software::getSoftwareByProjectIdForSelect($client_id);
		}

		// Aggiorna il select:
		$element->setMultiOptions($listaSoftware);
	}
}
