<?php

class Default_Form_DatabaseUser extends Zend_Form {
	public function init() {
		$this->setMethod('post');
		$this->setAction("#");

		// Lista dei server:
		$listaServer = array("" => "- scegli -") +
					   Servers::getListaPerSelect();
		$listaDatabase = array();


		$this->addElement("text", "user", array(
			'label'      => "User:",
            'required'   => true,
            'filters'    => array("StringTrim"),
			'validators' => array(
				array(
					'validator' 			=> 'NotEmpty',
					'breakChainOnFailure'	=> true,
					'options' 				=> array('messages' => array(
						Zend_Validate_NotEmpty::IS_EMPTY => "Il campo &egrave; obbligatorio."
					))
				)
			)
		));

		$this->addElement("text", "pw", array(
			'label'      => "Password:",
            'required'   => false,
            'filters'    => array("StringTrim")
		));


		$this->addElement("text", "host", array(
			'label'      => "Hostname:",
            'required'   => true,
            'filters'    => array("StringTrim"),
			'validators' => array(
				array(
					'validator' 			=> 'NotEmpty',
					'breakChainOnFailure'	=> true,
					'options' 				=> array('messages' => array(
						Zend_Validate_NotEmpty::IS_EMPTY => "Il campo &egrave; obbligatorio."
					))
				)
			)
		));

		$selectDatabase = $this->getSelectDatabase();

    	// Server:
    	$serverElement = new Neikos_Form_Element_ComboSelect("server_id", array(
			'label' 		=> "Server:",
    		'required'   	=> true,
			'multiOptions' 	=> $listaServer,
			'validators' => array(
				array(
					'validator' 			=> 'NotEmpty',
					'breakChainOnFailure'	=> true,
					'options' 				=> array('messages' => array(
						Zend_Validate_NotEmpty::IS_EMPTY => "Il campo &egrave; obbligatorio."
					))
				)
			),
    		'callback' => array(
					'callback' => array('Default_Form_DatabaseUser', 'getDatabaseOption'),
					'elements' => array($selectDatabase)
            )
    	));
    	$this->addElement($serverElement);


    	// Associazione al db:
    	$this->addElement($selectDatabase);

    	// Note:
    	$this->addElement("textarea", "note", array(
			'label' 		=> "Note:",
    		'filters'    	=> array("StringTrim"),
			'validators' 	=> array(

    		)
    	));

    	$this->addElement("button", "salva", array(
			'label' => "Salva",
    	    'type'  => 'submit'
    	));
	}


    /**
     * Select del database
     *
     * @param int $server_id
     * @param array $decorators
     *
     * @return Zend_Form_Element
     */
	public function getSelectDatabase($server_id = null, $decorators = array()) {
		$element = $this->createElement("multiselect", "database_id", array(
			'label' 		=> "Associazione al database:",
			'required'   	=> false,
			'validators' 	=> array(

    		)
    	));

    	$element->addDecorators(array(
    		array(
    			"HtmlTag", array("tag" => "span", "id" => "database_id_container")
    		)
    	));

    	self::getDatabaseOption($element, $server_id);

    	return $element;
	}


	/**
	 * Funzione di callback per l'aggiornamento del select
	 * dei database in funzione del server.
	 */
	public static function getDatabaseOption(Zend_Form_Element $element, $server_id = null) {
		$listaDatabase = array();
		if ($server_id != null) {
			$listaDatabase += Database::getListaDbManualiForSelect($server_id);
		}

		// Aggiorna il select:
		$element->setMultiOptions($listaDatabase);
	}
}

