<?php

class Default_Form_Domain extends Zend_Form {
    public function init() {
        $this->setMethod('post');
        $this->setAction("#");

        // Tutti i clienti:
        $clients = new Clients();
        $selClients = $clients->select()
                              ->from($clients, array("key" => "ID", "value" => "name"))
                              ->where("parent = 0")
                              ->order("name ASC");
        $listaClients = $clients->fetchAll($selClients)->toArray();

        // Tutti i server:
        $servers = new Servers();
        $selServers = $servers->select()
                              ->where("aggiornabile = 'N'")
                              ->order("name ASC")
                              ->order("project_id ASC");
        $risServer = $servers->fetchAll($selServers);

        $listaServer = null;
        if (count($risServer)>0) {
            foreach ($risServer as $server) {
                $proprietario = $server->findParentRow('Clients');
                if (count($proprietario) > 0) {
                    $nome = $server->name . " (" . $proprietario->name . ")";
                } else {
                    $nome = $server->name;
                }
                $listaServer[] = array("key" => $server->id, "value" => $nome);
            }
        }

        // Domini presenti:
        $domains = new Domains();
        $selDomains = $domains->select()
                              ->from($domains, array("key" => "id", "value" => "name"))
                              ->where("immesso = 'M'")
                              ->where("parent_id = 0 OR parent_id IS NULL")
                              ->order("name ASC");
        $listaDomain = $domains->fetchAll($selDomains)->toArray();
        array_unshift($listaDomain, array("key"=>"0", "value"=>"-- Dominio principale --"));


        // Nome del dominio:
        $this->addElement("text", "name", array(
            'required'  => true,
            'label'     => 'Nome di dominio:',
            'filters'   => array(
                'StringToLower'
            ),
            'validators' => array(
                array(
                    'validator' 			=> 'NotEmpty',
                    'breakChainOnFailure'	=> true,
                    'options' 				=> array('messages' => array(
                        Zend_Validate_NotEmpty::IS_EMPTY => "Il campo &egrave; obbligatorio."
                    ))
                )
            )
        ));

        // Cliente:
        $this->addElement("select", "project_id", array(
            'label'        => "Cliente:",
            'class'        => "chosen-select",
            'multiOptions' => $listaClients
        ));

        // Server:
        $this->addElement("select", "server_id", array(
            'label'        => "Server:",
            'class'        => "chosen-select",
            'multiOptions' => $listaServer
        ));

        // IP del dominio scelto tra quelli del server:
        $this->addElement("text", "ip_port", array(
            'required'   => true,
            'label'      => 'IP del dominio:',
            'validators' => array(
                'Ip',
                array(
                    'validator' 			=> 'NotEmpty',
                    'breakChainOnFailure'	=> true,
                    'options' 				=> array('messages' => array(
                        Zend_Validate_NotEmpty::IS_EMPTY => "Il campo &egrave; obbligatorio."
                    ))
                )
            )
        ));

        // Sotto-dominio:
        $this->addElement("select", "parent_id", array(
            'label'        => "Sottodominio di:",
            'class'        => "chosen-select",
            'multiOptions' => $listaDomain
        ));

        // Button:
        $this->addElement("button", "salva", array(
			'label' => "Salva",
    	    'type'  => "submit"
    	));
    }
}