<?php

class Default_Form_Ftp extends Zend_Form {
	public function init() {
		$this->setMethod('post');
		$this->setAction("#");

		// Lista dei clienti:
		$listaClienti = Clients::getListaPerSelect();

		// Lista dei server:
		$listaServer = array(0 => "- altro -") +
					   Servers::getListaPerSelect();

		$this->addElement("text", "user", array(
			'label'      => "User:",
			'value'		 => "anonymous",
            'required'   => true,
            'filters'    => array("StringTrim"),
			'validators' => array(
				array(
					'validator' 			=> 'NotEmpty',
					'breakChainOnFailure'	=> true,
					'options' 				=> array('messages' => array(
						Zend_Validate_NotEmpty::IS_EMPTY => "Il campo &egrave; obbligatorio."
					))
				)
			)
		));

		$this->addElement("text", "pw", array(
			'label'      => "Password:",
			'value'	 	 => "anonymous",
            'required'   => true,
            'filters'    => array("StringTrim"),
			'validators' => array(
				array(
					'validator' 			=> 'NotEmpty',
					'breakChainOnFailure'	=> true,
					'options' 				=> array('messages' => array(
						Zend_Validate_NotEmpty::IS_EMPTY => "Il campo &egrave; obbligatorio."
					))
				)
			)
		));

		$this->addElement("text", "host", array(
			'label'      => "Hostname:",
            'required'   => true,
            'filters'    => array("StringTrim"),
			'validators' => array(
				array(
					'validator' 			=> 'NotEmpty',
					'breakChainOnFailure'	=> true,
					'options' 				=> array('messages' => array(
						Zend_Validate_NotEmpty::IS_EMPTY => "Il campo &egrave; obbligatorio."
					))
				)
			),
		));

		$this->addElement("text", "url", array(
			'label'      => "Url web:",
            'required'   => false,
            'filters'    => array("StringTrim")
		));

		$this->addElement("text", "server_path", array(
			'label'      => "Percorso sul server:",
            'required'   => false,
            'filters'    => array("StringTrim")
		));

		$this->addElement("text", "quota_ass", array(
			'label'      => "Quota assegnata:",
            'required'   => false,
            'filters'    => array("StringTrim"),
		));

		$this->addElement("select", "project_id", array(
			'label' 		=> "Cliente:",
			'required'   	=> true,
			'multiOptions' 	=> $listaClienti,
			'validators'    => array(
				array(
					'validator' 			=> 'NotEmpty',
					'breakChainOnFailure'	=> true,
					'options' 				=> array('messages' => array(
						Zend_Validate_NotEmpty::IS_EMPTY => "Il campo &egrave; obbligatorio."
					))
				)
			),
		    'class'         => 'chosen-select'
    	));

    	$this->addElement("select", "server_id", array(
			'label' 		=> "Server:",
    		'required'   	=> false,
			'multiOptions' 	=> $listaServer,
			'validators' 	=> array(
	    			'Int'
    		),
    	    'class'         => 'chosen-select'
    	));

    	$this->addElement("textarea", "note", array(
			'label' 		=> "Note:",
    		'filters'    	=> array("StringTrim"),
			'validators' 	=> array(

    		)
    	));

    	$this->addElement("button", "salva", array(
			'label' => "Salva",
    	    'type'  => 'submit'
    	));
	}
}

