<?php

class Default_Form_Server extends Zend_Form {
    public function init() {
        $this->setMethod('post');
        $this->setAction("#");

        // Lista dei clienti:
        $listaClienti = array("" => "- scegli -") +
                        Clients::getListaPerSelect();

        // Gruppi di server:
        $listaGruppi = array("" => "- scegli -") +
                       Servers_Group::getAllForSelect();

        // Nome db:
        $this->addElement("text", "name", array(
            'label' 	  => "Nome:",
            'required'    => true,
            'filters'     => array("StringTrim"),
            'validators'  => array(
                array(
                    'validator' 			=> 'NotEmpty',
                    'breakChainOnFailure'	=> true,
                    'options' 				=> array('messages' => array(
                        Zend_Validate_NotEmpty::IS_EMPTY => "Il campo &egrave; obbligatorio."
                    ))
                )
            )
        ));

        // Gruppo:
        $this->addElement("select", "servers_group_id", array(
            'label' 	   => "Tipologia server:",
            'multiOptions' => $listaGruppi,
            'required'     => true,
            'filters'      => array("StringTrim"),
            'validators'   => array(
                array(
                    'validator' 			=> 'NotEmpty',
                    'breakChainOnFailure'	=> true,
                    'options' 				=> array('messages' => array(
                        Zend_Validate_NotEmpty::IS_EMPTY => "Il campo &egrave; obbligatorio."
                    ))
                )
            ),
            'class' => 'chosen-select'
        ));

        $this->addElement("text", "user", array(
            'label'      => "User:",
            'required'   => false,
            'filters'    => array("StringTrim")
        ));

        $this->addElement("text", "pw", array(
            'label'      => "Password:",
            'required'   => false,
            'filters'    => array("StringTrim")
        ));

        // Stato:
        $this->addElement("select", "stato", array(
            'label' 	   => "Stato:",
            'multiOptions' => array(Servers::STATO_ATTIVO => "Attivo", Servers::STATO_NON_ATTIVO => "Non attivo"),
            'required'     => true,
            'filters'      => array("StringTrim"),
            'validators'   => array(
                array(
                    'validator' 			=> 'NotEmpty',
                    'breakChainOnFailure'	=> true,
                    'options' 				=> array('messages' => array(
                        Zend_Validate_NotEmpty::IS_EMPTY => "Il campo &egrave; obbligatorio."
                    ))
                )
            ),
            'class' => 'chosen-select'
        ));

        // Indirizzi ip:
        $ipAddress = new Neikos_Form_Element_MultiIpAddresses("ip", array(
            "label" => "Indirizzi IP:",
            "note"  => "NB: per eliminare un indirizzo IP lasciare vuota la casella di testo."
        ));
        $this->addElement($ipAddress);

        // Aggiornamenti:
        $this->addDisplayGroup(array("ip"), "ip-data", array(
            "legend" => "Indirizzi ip",
            "decorators" => array('FormElements', 'Fieldset')
        ));


        // Server neikos:
        $this->addElement("checkbox", "is_neikos", array(
            'label'          => "Server Neikos:",
            'checkedValue'   => Servers::SERVER_NEIKOS,
            'uncheckedValue' => Servers::SERVER_ESTERNO
        ));

        // Aggiornabile?
        $this->addElement("checkbox", "aggiornabile", array(
            'label'          => "Aggiornabile in maniera automatica:",
            'checkedValue'   => Servers::AGGIORNABILE_SI,
            'uncheckedValue' => Servers::AGGIORNABILE_NO
        ));

        // Casa è aggiornabile?
        $this->addElement("multiselect", "allowed_updates", array(
            'label'        => "Permetti aggiornamenti manuali di:",
            'multiOptions' => Updates::getUpdateTypes(),
            'class'        => 'chosen-select'
        ));

        // Aggiornamenti:
        $this->addDisplayGroup(array("is_neikos", "aggiornabile", "allowed_updates"), "updates", array(
            "legend" => "Aggiornamenti automatici",
            "decorators" => array('FormElements', 'Fieldset')
        ));

        // Cliente:
        $this->addElement("select", "project_id", array(
            'label' 		=> "Cliente:",
            'required'   	=> true,
            'multiOptions' 	=> $listaClienti,
            'validators' 	=> array(
                array(
                    'validator' 			=> 'NotEmpty',
                    'breakChainOnFailure'	=> true,
                    'options' 				=> array('messages' => array(
                        Zend_Validate_NotEmpty::IS_EMPTY => "Il campo &egrave; obbligatorio."
                    ))
                )
            ),
            'class'         => "chosen-select"
        ));

        // Costo:
        $this->addElement("text", "costo", array(
            'label'     => "Costo:",
            'required'  => false,
            'filters'   => array("StringTrim")
        ));

        // Data attivazione:
        $dataAttivazione = new Neikos_Form_Element_DatePicker("data_attivazione", array(
            'label' 	=> "Data attivazione:",
            'required'  => false,
            'class'     => 'date_picker',
            'css_path'  => '/scripts/js/calendarview/',
            'js_path'   => '/scripts/js/calendarview/',
            'filters'   => array(
                new Neikos_Filter_Date(array(
                    "format"   => Neikos_Filter_Date::FORMAT_DATE_SQL,
                    "nullable" => true
                ))
            )
        ));
        $this->addElement($dataAttivazione);

        // Data scadenza:
        $dataScadenza = new Neikos_Form_Element_DatePicker("data_scadenza", array(
            'label' 	=> "Data scadenza:",
            'required'  => false,
            'class'     => "date_picker",
            'css_path'  => '/scripts/js/calendarview/',
            'js_path'   => '/scripts/js/calendarview/',
            'filters'   => array(
                new Neikos_Filter_Date(array(
                    "format"   => Neikos_Filter_Date::FORMAT_DATE_SQL,
                    "nullable" => true
                ))
            )
        ));
        $this->addElement($dataScadenza);

        // Info commerciali:
        $this->addDisplayGroup(array("project_id", "costo", "data_attivazione", "data_scadenza"), "info-commerciali", array(
            "legend" => "Info commerciali",
            "decorators" => array('FormElements', 'Fieldset')
        ));


        // Note:
        $this->addElement("textarea", "note", array(
            'label' 		=> "Note:",
            'filters'    	=> array("StringTrim")
        ));

        $this->addElement("button", "salva", array(
            'label'  => "Salva",
            'type'   => "Submit"
        ));
    }
}