<?php

class Default_Form_Software extends Zend_Form {
	public function init() {
		$this->setMethod('post');
		$this->setAction("#");

		// Lista dei clienti:
		$listaClienti = array("" => "- scegli -") +
		                  Clients::getListaPerSelect();

		// Lista dei server:
		$listaServer = array("" => "- Altro server -") +
		                  Servers::getListaPerSelect();


		// Lista dei tipi:
		$listaTipi = Software_Tipo::getListaPerSelect() +
				   	    array("0" => "- Nuovo tipo -");


		// Cliente:
		$this->addElement("select", "project_id", array(
			'label' 		=> "Cliente:",
			'required'   	=> true,
			'multiOptions' 	=> $listaClienti,
		    'validators' 	=> array(
		        array(
		            'validator' 			=> 'NotEmpty',
		            'breakChainOnFailure'	=> true,
		            'options' 				=> array('messages' => array(
		                Zend_Validate_NotEmpty::IS_EMPTY => "Il campo &egrave; obbligatorio."
		            ))
		        )
		    ),
		    'class'         => "chosen-select"
    	));

		// Server:
		$this->addElement("select", "server_id", array(
		    'label' 		=> "Server:",
		    'required'   	=> false,
		    'filters'       => array(
		        new Neikos_Filter_IntOrNull()
		     ),
		    'multiOptions' 	=> $listaServer,
		    'class'         => "chosen-select"
		));

    	$this->addElement("select", "software_tipo_id", array(
			'label' 		=> "Tipo software:",
			'required'   	=> true,
			'multiOptions' 	=> $listaTipi,
			'validators' 	=> array(
	    		'Int'
    		),
		    'class'         => "chosen-select"
    	));

    	$this->addElement("text", "versione", array(
    	    'label'      => "Versione:",
    	    'required'   => false,
    	    'filters'    => array("StringTrim")
    	));

		$this->addElement("text", "user", array(
			'label'      => "User:",
            'required'   => true,
            'filters'    => array("StringTrim"),
			'validators' => array(
				array(
					'validator' 			=> 'NotEmpty',
					'breakChainOnFailure'	=> true,
					'options' 				=> array('messages' => array(
						Zend_Validate_NotEmpty::IS_EMPTY => "Il campo &egrave; obbligatorio."
					))
				)
			)
		));

		$this->addElement("select", "user_tipo", array(
			'label' 		=> "Tipo user:",
			'required'   	=> true,
			'multiOptions' 	=> Software::getTipiUser(),
			'validators' 	=> array(
	    		array(
					'validator' 			=> 'NotEmpty',
					'breakChainOnFailure'	=> true,
					'options' 				=> array('messages' => array(
						Zend_Validate_NotEmpty::IS_EMPTY => "Il campo &egrave; obbligatorio."
					))
				)
			),
		    'class'         => "chosen-select"
    	));

		$this->addElement("text", "pw", array(
			'label'      => "Password:",
            'required'   => true,
            'filters'    => array("StringTrim"),
			'validators' => array(
				array(
					'validator' 			=> 'NotEmpty',
					'breakChainOnFailure'	=> true,
					'options' 				=> array('messages' => array(
						Zend_Validate_NotEmpty::IS_EMPTY => "Il campo &egrave; obbligatorio."
					))
				)
			)
		));

		// Url:
		$this->addElement("text", "url", array(
			'label'      => "Url web:",
            'required'   => false,
            'filters'    => array("StringTrim"),
		    'validators' => array(
                array(
                    'validator'             => 'Callback',
                    'breakChainOnFailure'	=> true,
                    'options'               => array(
                        'callback' => array('Zend_Uri', 'check'),
                        'messages' => array(
                            Zend_Validate_Callback::INVALID_VALUE => 'Inserisci una url valida.'
                        )
                    ),
                ),
            )
		));

		$this->addElement("select", "url_tipo", array(
			'label' 		=> "Tipo url:",
			'required'   	=> false,
			'multiOptions' 	=> Software::getTipiUrl(),
		    'class'         => "chosen-select"
    	));

		$this->addElement("text", "path", array(
		    'label'      => "Path completo sul server:",
		    'required'   => false,
		    'filters'    => array("StringTrim")
		));

		$this->addElement("textarea", "note", array(
			'label' 		=> "Note:",
    		'filters'    	=> array("StringTrim")
    	));

    	$this->addElement("button", "salva", array(
			'label'  => "Salva",
    	    'type'   => "Submit"
    	));
	}
}
