<?php

class Default_Form_SoftwarePlugin extends Zend_Form {
    const OP_MODIFY = "mod";
    const OP_INSERT = "ins";

    /**
     * Operazione
     *
     * @var string
     */
    protected $_operation = self::OP_INSERT;


    /**
     * Costruttore della classe.
     *
     * @param array|Zend_Config|null $options
     */
    public function __construct($options = null)
    {
        // Prende i parametri che occorrono:
        if (is_array($options)) {
            $this->_setOperation($options['operation']);
        } elseif ($options instanceof Zend_Config) {
            $opts = $options->toArray();
            $this->_setOperation($options['operation']);
        }

        // Costruttore della classe padre:
        parent::__construct($options);
    }


    /**
     * Setta l'operazione
     *
     * @param string $op
     *
     * @return Default_Form_SoftwarePlugin
     */
    protected function _setOperation($op) {
        if ($op == self::OP_MODIFY) {
            $this->_operation = self::OP_MODIFY;
        } else {
            $this->_operation = self::OP_INSERT;
        }

        return $this;
    }


    /**
     * Tipi software
     *
     * @return array
     */
    public function getTipiSoftware() {
        // Lista dei tipi di software:
        $listaTipiSoftware = Software_Tipo::getListaPerSelect(false);

        return array("" => "- scegli -") +
               $listaTipiSoftware;
    }


    /**
     * Inizializzazione del form
     *
     * @see Zend_Form::init()
     */
    public function init() {
		$this->setMethod('post');
		$this->setAction("#");

		$this->addElement("text", "name", array(
		    'label' 		=> "Nome plugin:",
		    'required'   	=> true,
		    'allowEmpty' 	=> false,
		    'filters'    	=> array("StringTrim"),
		    'validators' => array(
		        array(
		            'validator' 			=> 'NotEmpty',
		            'breakChainOnFailure'	=> true,
		            'options' 				=> array('messages' => array(
		                Zend_Validate_NotEmpty::IS_EMPTY => "Il campo &egrave; obbligatorio."
		            ))
		        )
		    )
		));

		$this->addElement("text", "identifier", array(
		    'label' 		=> "Identificativo plugin:",
		    'required'   	=> false,
		    'allowEmpty' 	=> true,
		    'filters'    	=> array("StringTrim")
		));

		// Tipo software:
		if ($this->_operation == self::OP_MODIFY) {
		    $this->addElement("note", "software_tipo_id", array(
		        'label' 		=> "Tipo software:",
		        'required'   	=> true
		    ));
		} else {
    		$this->addElement("select", "software_tipo_id", array(
    		    'label' 		=> "Tipo software:",
    		    'required'   	=> true,
    		    'allowEmpty' 	=> false,
    		    'multiOptions' 	=> $this->getTipiSoftware(),
    		    'class'         => "chosen-select"
    		));
		}

		// Note:
		$this->addElement("textarea", "note", array(
		    'label' 		=> "Nota:",
		    'required'   	=> false,
		    'allowEmpty' 	=> true,
		    'filters'    	=> array("StringTrim"),

		));

		// Pulsante di salvataggio:
		$this->addElement("button", "salva", array(
		    'label'   => "Salva",
		    'type'    => 'submit'
		));
	}


	/**
	 * Setta i valori degli elementi
	 *
	 * @param string $name
	 * @param mixed $value
	 *
	 * @see Zend_Form::setDefault()
	 *
	 * @return Default_Form_SoftwarePlugin
	 */
	public function setDefault($name, $value) {
	    $name = (string)$name;
	    if ($name == "software_tipo_id" && $this->_operation == self::OP_MODIFY) {
	        $values = $this->getTipiSoftware();
	        if (isset($values[$value])) {
	            $value = $values[$value];
	        }
	    }

	    return parent::setDefault($name, $value);
	}
}