<?php

class Default_Form_SoftwareTipo extends Zend_Form {
	public function init() {
		$this->setMethod('post');
		$this->setAction("#");

		// Lista dei tipi con il numero di software associato tra parentesi:
		$listaTipiSoftware = Software_Tipo::getListaPerSelect(true);

		$this->addElement("select", "software_tipo_id", array(
			'label' 		=> "Tipo software:",
			'required'   	=> true,
			'multiOptions' 	=> $listaTipiSoftware,
			'validators' 	=> array(
	    		'Int'
    		),
		    'class'         => "chosen-select"
    	));

    	$this->addElement("radio", "action", array(
			'label' 		=> "Azione da intraprendere:",
			'required'   	=> true,
    		'multiOptions'  => array(
    							'modTipoSoft' => 'Modifica il tipo di software',
    							'delTipoSoft' => 'Elimina il tipo di software'
    		),
			'validators' 	=> array(

    		)
    	));


    	// Modifica nome tipo software:
    	$val1 = new Neikos_Validate_FieldDepends('action', 'modTipoSoft');
    	$val1->setMessages(array(
    	    Neikos_Validate_FieldDepends::KEY_IS_EMPTY => "Il campo &egrave; obbligatorio."
    	));
    	$this->addElement("text", "new_software_tipo_name", array(
			'label' 		=> "Nuovo nome per il tipo software:",
			'required'   	=> false,
    		'allowEmpty' 	=> false,
    	    'filters'    	=> array("StringTrim"),
    		'validators' 	=> array(
    			array(
					'validator' 			=> $val1,
					'breakChainOnFailure'	=> true
				)
    		)
    	));


    	// Nuovo tipo software:
    	$val2 = new Neikos_Validate_FieldDepends('action', 'delTipoSoft');
    	$val2->setMessages(array(
    	    Neikos_Validate_FieldDepends::KEY_IS_EMPTY => "Il campo &egrave; obbligatorio."
    	));

    	$val3 = new Neikos_Validate_ValueNotEqual('software_tipo_id');
    	$val3->setMessages(array(
    	    Neikos_Validate_ValueNotEqual::KEY_EQUAL => "Il nuovo tipo software non pu&ograve; essere uguale al vecchio."
    	));

    	$this->addElement("select", "new_software_tipo_id", array(
			'label' 		=> "Nuovo tipo software:",
			'required'   	=> false,
    		'allowEmpty' 	=> false,
			'multiOptions' 	=> array(0 => "- scegli -") + $listaTipiSoftware,
    	    'class'         => "chosen-select",
    		'validators' 	=> array(
	    		'Int',
    			array(
					'validator' 			=> $val2,
					'breakChainOnFailure'	=> true
				),
				array(
					'validator' 			=> $val3,
					'breakChainOnFailure'	=> true
				)
    		)
    	));


    	$this->addElement("button", "salva", array(
			'label'  => "Salva",
    	    'type'   => 'submit'
    	));
	}
}
