<?php

class Default_Form_SoftwareToPlugin extends Zend_Form {
    /**
     * Software
     *
     * @var Software
     */
    protected $_software = null;

    /**
     * Plugin
     *
     * @var Software_Plugin
     */
    protected $_software_plugin = null;


    /**
     * Costruttore della classe.
     *
     * @param array|Zend_Config|null $options
     */
    public function __construct($options = null)
    {
        // Prende i parametri che occorrono:
        if (is_array($options)) {
            $this->setSoftware((int)$options['software_id']);
            $this->setSoftwarePlugin((int)$options['software_plugin_id']);
        } elseif ($options instanceof Zend_Config) {
            $opts = $options->toArray();
            $this->setSoftware((int)$opts['software_id']);
            $this->setSoftwarePlugin((int)$options['software_plugin_id']);
        }

        // Costruttore della classe padre:
        parent::__construct($options);
    }


    /**
     * Controlla che il software esista e lo setta
     * nella variabile giusta.
     *
     * @param int $software_id
     *
     * @return Default_Form_SoftwareToPlugin
     */
    public function setSoftware($software_id) {
        if ($software_id <= 0) {
            return $this;
        }

        // Verifica se il software passato è corretto:
        $softwareModel = new Software();
        $softwareRowset = $softwareModel->find($software_id);

        if ($softwareRowset->count() == 1) {
            $software = $softwareRowset->current();

            $this->_software = $software;
        }

        return $this;
    }


    /**
     * Software associato al form
     *
     * @return Software|null
     */
    public function getSoftware() {
        return $this->_software;
    }


    /**
     * Controlla che il plugin esista e lo setta
     * nella variabile giusta.
     *
     * @param int $software_id
     *
     * @return Default_Form_SoftwareToPlugin
     */
    public function setSoftwarePlugin($software_plugin_id) {
        if ($software_plugin_id <= 0) {
            return $this;
        }

        // Verifica se il software passato è corretto:
        $softwarePluginModel = new Software_Plugin();
        $softwarePluginRowset = $softwarePluginModel->find($software_plugin_id);

        if ($softwarePluginRowset->count() == 1) {
            $softwarePlugin = $softwarePluginRowset->current();

            $this->_software_plugin = $softwarePlugin;
        }

        return $this;
    }


    /**
     * Plugin associato al form
     *
     * @return Software|null
     */
    public function getSoftwarePlugin() {
        return $this->_software_plugin;
    }


    /**
     * Restituisce i valori inseriti nel form sotto forma di array
     *
     * @param  bool $suppressArrayNotation
     * @return array
     */
    public function getValues($suppressArrayNotation = false) {
        // Valori del form:
        $values = parent::getValues($suppressArrayNotation);

        // Aggiunge il software id ai valori del form:
        $values['software_id'] = ($this->_software == null) ? null : $this->_software->id;

        return $values;
    }


    /**
     * Lista dei plugin
     *
     * @return array
     */
    public function getPlugins() {
        if ($this->_software_plugin != null) {
            $id = $this->_software_plugin->id;
            $descrizione = $this->_software_plugin->name;
            return array($id => $descrizione);
        }

        $software_id = null;
        if ($this->_software != null) {
            $software_id = $this->_software->software_tipo_id;
        }

        $plugins = Software_Plugin::getListaForSelect($software_id);

        return array("" => "-- Scegli --") +
               $plugins;
    }


    /**
     * Lista dei software
     *
     * @return array
     */
    public function getSoftwares() {
        if ($this->_software != null) {
            $id = $this->_software->id;
            $descrizione = $this->_software->getDescrizione();

            return array($id => $descrizione);
        }

        // Tutti i software:
        $softwares = Software::getAllForSelect();

        return array("" => "-- Scegli --") +
               $softwares;
    }


    /**
     * Inizializzazione del form
     *
     * @see Zend_Form::init()
     */
	public function init() {
		$this->setMethod('post');
		$this->setAction("#");

		$this->addElement("select", "software_id", array(
		    'label' 		=> "Software:",
		    'required'   	=> true,
		    'multiOptions' 	=> $this->getSoftwares(),
		    'validators' 	=> array(
		        'Int'
		    ),
		    'class'         => "chosen-select"
		));

		$this->addElement("select", "software_plugin_id", array(
			'label' 		=> "Plugin:",
			'required'   	=> true,
			'multiOptions' 	=> $this->getPlugins(),
			'validators' 	=> array(
	    		'Int'
    		),
		    'class'         => "chosen-select"
    	));

    	$this->addElement("text", "versione", array(
    	    'label'      => "Versione:",
    	    'required'   => false,
    	    'filters'    => array("StringTrim")
    	));

    	$this->addElement("select", "status", array(
    	    'label' 		=> "Stato del plugin:",
    	    'required'   	=> true,
    	    'multiOptions' 	=> array("A" => "Attivo", "D" => "Non attivo"),
    	    'class'         => "chosen-select"
    	));

    	$this->addElement("textarea", "note", array(
    	    'label' 		=> "Note:",
    	    'filters'    	=> array("StringTrim"),
    	    'validators' 	=> array(

    	    )
    	));

    	$this->addElement("button", "salva", array(
			'label'  => "Salva",
    	    'type'   => 'submit'
    	));
	}
}
