<?php

class Clients extends Zend_Db_Table_Abstract {
	protected $_name = 'projekte';
	protected $_primary = 'ID';
	protected $_schema = 'agenda';

	const PROGETTI_FERMATI = 5;
	const PROGETTI_FINITI = 4;

	// Class custom per la riga sul db:
	protected $_rowClass = "Clients_Row";

	protected $_referenceMap = array();

    protected $_dependentTables = array('Dns', 'Domains', 'Ftp', 'MailDomains', 'Servers', 'SupportMail', 'Database');

    protected function _setupDatabaseAdapter() {
    	$multiDb = Zend_Registry::get("multidb");
    	$this->_db = $multiDb->getDb($this->_schema);
    }

    public function getFermati() {
    	$sel = $this->select();

    	$sel->from($this, array("ID", "name"))
    		->where("kategorie = ?", self::PROGETTI_FERMATI)
    		->where("parent = '0'")
    		->order("name ASC");

    	return $this->fetchAll($sel);
    }


	public function getAttivi() {
    	$sel = $this->select();

    	$sel->from($this, array("ID", "name"))
    		->where("kategorie != ?", self::PROGETTI_FERMATI)
    		->where("parent = '0'")
    		->order("name ASC");

    	return $this->fetchAll($sel);
    }


    public function getIdFermati() {
    	$fermati = $this->getFermati();
    	$ret = array();

    	if (count($fermati) > 0) {
    		foreach ($fermati as $row) {
    			$ret[] = $row->ID;
    		}
    	}

    	return $ret;
    }

    public static function getListaPerSelect() {
    	$model = new self();

    	$selClientiAttivi = $model->select()
    							->from($model, array("ID", "name"))
    							->where("kategorie != ?", self::PROGETTI_FERMATI)
    							->where("parent = '0'")
    							->order("name ASC");
    	$listaClientiAttivi = $model->fetchAll($selClientiAttivi);
    	$cAttivi = array();

		if (count($listaClientiAttivi) > 0) {
			foreach ($listaClientiAttivi as $c) {
				$cAttivi[$c->ID] = $c->name;
			}
		}

		$selClientiFermati = $model->select()
								->from($model, array("ID", "name"))
								->where("kategorie = ?", self::PROGETTI_FERMATI)
								->where("parent = '0'")
								->order("name ASC");
		$listaClientiFermati = $model->fetchAll($selClientiFermati);
		$cFermati = array();

    	if (count($listaClientiFermati) > 0) {
			foreach ($listaClientiFermati as $c) {
				$cFermati[$c->ID] = $c->name;
			}
		}

		return array(
			"Clienti attivi" => $cAttivi,
			"Clienti fermati" => $cFermati
		);
    }

	public static function getListaNetmktgPerSelect() {
    	$model = new self();
    	$adapter = $model->getAdapter();

    	// Conserva il vecchio mode:
    	$mode = $adapter->getFetchMode();

    	// Setta il nuovo mode:
    	$adapter->setFetchMode(Zend_Db::FETCH_OBJ);

    	$selClientiAttivi = $adapter->select()
    							->from(array("q" => $model->_name), array("ID", "name"))
    							->joinLeft(array("p" => $model->_name), "q.parent = p.ID", array())
    							->where("p.kategorie != ?", self::PROGETTI_FERMATI)
    							->where("q.kategorie != ?", self::PROGETTI_FERMATI)
    							->where("q.name LIKE '%-m-%'")
    							->order("q.name ASC");
    	$listaClientiAttivi = $adapter->fetchAll($selClientiAttivi);
    	$cAttivi = array();

		if (count($listaClientiAttivi) > 0) {
			foreach ($listaClientiAttivi as $c) {
				$cAttivi[$c->ID] = $c->name;
			}
		}

		$selClientiFermati = $adapter->select()
    							->from(array("q" => $model->_name), array("ID", "name"))
    							->joinLeft(array("p" => $model->_name), "q.parent = p.ID", array())
    							->where("p.kategorie = ?", self::PROGETTI_FERMATI)
    							->where("q.kategorie = ?", self::PROGETTI_FERMATI)
    							->where("q.name LIKE '%-m-%'")
    							->order("q.name ASC");
		$listaClientiFermati = $adapter->fetchAll($selClientiFermati);
		$cFermati = array();

    	if (count($listaClientiFermati) > 0) {
			foreach ($listaClientiFermati as $c) {
				$cFermati[$c->ID] = $c->name;
			}
		}

		// Ripristina il vecchio mode:
		$adapter->setFetchMode($mode);

		return array(
			"Progetti attivi" => $cAttivi,
			"Progetti fermati" => $cFermati
		);
    }

    public static function getAll() {
    	$model = new self();
    	$sel = $model->select();

    	$sel->from($model, array("ID", "name"))
    		->where("parent = '0'")
    		->order("name ASC");

    	return $model->fetchAll($sel);
    }

    public function findProgettoNetmktg($id) {
    	$select = $this->select()->where("ID = ? ", $id)->where("name LIKE '%-m-%'");
    	$ris = $this->fetchAll($select);

    	if (count($ris)>0) {
    		return $ris->current();
    	}

    	return null;
    }
}
