<?php

class Domains extends Zend_Db_Table_Abstract {
    const IMMESSO_AUTOMATICO = "A";
    const IMMESSO_MANUALE = "M";

	protected $_name = 'domains';
	protected $_dependentTables = array('Domains');

	// Filtri di ricerca:
	protected $_filtriRicerca = null;

	protected $_referenceMap    = array(
		'Parent' => array(
            'columns'           => 'parent_id',
            'refTableClass'     => 'Domains',
            'refColumns'        => 'id'
        ),

        'Server' => array(
            'columns'           => 'server_id',
            'refTableClass'     => 'Servers',
            'refColumns'        => 'id'
        ),

        'Clients' => array(
            'columns'           => 'project_id',
            'refTableClass'     => 'Clients',
            'refColumns'        => 'ID'
        )
	);

	/**
	 * Prende tutti i dati che saranno visualizzati
	 * in una pagina.
	 *
	 * @param int $numPage - pagina corrente (default: 1).
	 * @param int $maxPerPage - numero massimo di record per pagina (default = 25).
	 * @return mixed
	 */
	public function getPage($numPage = 1, $maxPerPage = 25) {
		$select = $this->select()->from($this, array("*", "new_id"=>"IF(parent_id IS NULL,id,parent_id)"))
				 ->order(array("new_id ASC", "parent_id ASC", "name ASC"));

		if ($numPage >= 0 && $maxPerPage !== null) {
			$select->limitPage($numPage, $maxPerPage);
		}

		// Applica i filtri di ricerca:
		if (count($this->_filtriRicerca) > 0) {
			foreach ($this->_filtriRicerca as $f) {
				$select->where($f);
			}
		}

		return $this->fetchAll($select);
	}

	/**
	 * Conta in numero di record.
	 *
	 * @return int
	 */
	public function count() {
		$select = $this->select();
		$select->from($this, array("num" => "COUNT(id)"));

		// Applica i filtri di ricerca:
		if (count($this->_filtriRicerca) > 0) {
			foreach ($this->_filtriRicerca as $f) {
				$select->where($f);
			}
		}

		$rows = $this->fetchAll($select);

		if (count($rows)>0) {
			return (int)$rows->current()->num;
		}
		return 0;
	}


	/**
	 * Setta i filtri per la lista dei domini.
	 */
	public function setFiltri($filtriRicerca) {
		$f = array();

		if ($filtriRicerca->ID > 0) {
			$f[] = $this->_db->quoteInto("id = ?", $filtriRicerca->ID);
		}
		if ($filtriRicerca->server_id > 0) {
			$f[] = $this->_db->quoteInto("server_id = ?", $filtriRicerca->server_id);
		}
		if ($filtriRicerca->client_id != 0) {
			if ($filtriRicerca->client_id == -1) {
				$f[] = "project_id IS NULL OR project_id = 0";
			} else if ($filtriRicerca->client_id == -2) {
				$clients = new Clients();
				$f[] = "project_id IN ('" . implode("', '", $clients->getIdFermati()) . "')";
			} else {
				$f[] = $this->_db->quoteInto("project_id = ?", $filtriRicerca->client_id);
			}
		}
		if ($filtriRicerca->stato != "") {
			switch ($filtriRicerca->stato) {
				case "A":
					$f[] = "status='A'";
					break;
				case "X":
					$f[] = "status='X'";
					break;
				case "XA":
					$f[] = "status='X'";
					$f[] = "alert_disabled='A'";
					break;
				case "XD":
					$f[] = "status='X'";
					$f[] = "alert_disabled='D'";
					break;
			}
		}
		if ($filtriRicerca->stato_update != "") {
			$f[] = $this->_db->quoteInto("update_status= ?", $filtriRicerca->stato_update);
		}
		if ($filtriRicerca->name != "") {
			$f[] = $this->_db->quoteInto("name LIKE ?", "%" . $filtriRicerca->name . "%");
		}
		if ($filtriRicerca->mostra != "") {
			$f[] = "parent_id IS NULL";
		}

		if ($filtriRicerca->nota != "") {
			if ($filtriRicerca->nota == "A") {
				$f[] = "note != ''";
			} else {
				$f[] = "note = ''";
			}
		}

		if (!empty($filtriRicerca->immesso)) {
		    $f[] = $this->_db->quoteInto("immesso = ?", $filtriRicerca->immesso);
		}

		$this->_filtriRicerca = $f;
	}

 	public function insert(array $data)
    {
		try {
			$id = parent::insert($data);
		} catch	(Exception $ex) {
			// Salva un msg di errore nello stack dei msg:
			Neikos_Systemmessage::push("E' occorso un errore nel salvataggio del dominio.<br />" . $ex->__toString(), Neikos_Systemmessage::MSG_ERRORE);
			return false;
		}

		// Salva un messaggio nel log:
		Neikos_Log::Write(sprintf("Nuovo dominio: (%s)", $id));

		// Salva un msg di OK nello stack dei msg positivi:
		Neikos_Systemmessage::push("Il dominio &egrave; stato salvato con successo.");

		return $id;
    }

    public function update(array $data, $where)
    {
    	try {
    		$oldDati = $this->fetchAll($where);

			if (count($oldDati) > 0) {
				$stringa = array();
				foreach ($oldDati as $oldData) {
					$stringa[] = sprintf("Modifica dominio: (%s), %s, %s, %s, %s, '%s'", $oldData->id, $oldData->name, $oldData->project_id, $oldData->parent_id, $oldData->server_id, base64_encode($oldData->note));
				}
    		}
    	} catch (Exception $ex) {
    		// Nessuna eccezione mostrata...
    	}

		try {
			$numRows = parent::update($data, $where);
		} catch(Exception $ex) {
			// Salva un msg di errore nello stack dei msg:
			Neikos_Systemmessage::push("Errore nella modifica dei record.<br />" . $ex->__toString(), Neikos_Systemmessage::MSG_ERRORE);

			return false;
		}

		// Scrive sul file di log:
		Neikos_Log::Write($stringa);

		return $numRows;
    }

    public function delete($where)
    {
        try {
    		$oldDati = $this->fetchAll($where);

			if (count($oldDati) > 0) {
    			$stringa = array();
				foreach ($oldDati as $oldData) {
    				$stringa[] = sprintf("Eliminazione dominio: (%s), %s, %s, %s, %s, '%s'", $oldData->id, $oldData->name, $oldData->project_id, $oldData->parent_id, $oldData->server_id, base64_encode($oldData->note));
				}
    		}
    	} catch (Exception $ex) {
    		// Nessuna eccezione mostrata...
    	}

		try {
			$numRows = parent::delete($where);
		} catch(Exception $ex) {
			// Salva un msg di errore nello stack dei msg:
			Neikos_Systemmessage::push("Errore nell'eliminazione dei record.<br />" . $ex->__toString(), Neikos_Systemmessage::MSG_ERRORE);

			return false;
		}

		// Scrive nel log:
		Neikos_Log::Write($stringa);

		// Salva un msg di OK nello stack dei msg positivi:
		Neikos_Systemmessage::push(sprintf("L'eliminazione &egrave; stata efettuata con successo. Record eliminati: %d", $numRows));

		return $numRows;
    }
}

?>