<?php

class Ftp extends Zend_Db_Table_Abstract {
	protected $_name = 'ftp';

	protected $_referenceMap    = array(
		'Server' => array(
            'columns'           => 'server_id',
            'refTableClass'     => 'Servers',
            'refColumns'        => 'id'
        ),

        'Clients' => array(
            'columns'           => 'project_id',
            'refTableClass'     => 'Clients',
            'refColumns'        => 'ID'
        )
	);

	// Filtri di ricerca:
	protected $_filtriRicerca = null;

	/**
	 * Setta i filtri per la lista dei domini.
	 */
	public function setFiltri($filtriRicerca) {
		$f = array();

		if (!empty($filtriRicerca->name)) {
			$f[] = $this->_db->quoteInto("p.server_path LIKE ?", "%" . $filtriRicerca->name . "%") .
				" OR " .
				$this->_db->quoteInto("p.note LIKE ?", "%" . $filtriRicerca->name . "%") .
				" OR " .
				$this->_db->quoteInto("p.host LIKE ?", "%" . $filtriRicerca->name . "%") .
				" OR " .
				$this->_db->quoteInto("p.url LIKE ?", "%" . $filtriRicerca->name . "%");
		}
		if (!empty($filtriRicerca->user)) {
			$f[] = $this->_db->quoteInto("p.user LIKE ?", "%" . $filtriRicerca->user . "%");
		}
		if ($filtriRicerca->client_id != 0) {
			if ($filtriRicerca->client_id == -1) {
				$f[] = "p.project_id IS NULL OR p.project_id = 0";
			} else if ($filtriRicerca->client_id == -2) {
				$clients = new Clients();
				$f[] = "p.project_id IN ('" . implode("', '", $clients->getIdFermati()) . "')";
			} else {
				$f[] = $this->_db->quoteInto("p.project_id = ?", $filtriRicerca->client_id);
			}
		}
		if ($filtriRicerca->server_id > 0) {
			$f[] = $this->_db->quoteInto("p.server_id = ?", $filtriRicerca->server_id);
		}

		$this->_filtriRicerca = $f;
	}


	/**
	 * Prende tutti i dati che saranno visualizzati
	 * in una pagina.
	 *
	 * @param int $numPage - pagina corrente (default: 1).
	 * @param int $maxPerPage - numero massimo di record per pagina (default = 25).
	 * @return mixed
	 */
	public function getPage($numPage = 1, $maxPerPage = 25) {
		$adapter = $this->getAdapter();

		$clients = new Clients();
		$cInfo = $clients->info();
		$cName = $cInfo[Zend_Db_Table_Abstract::SCHEMA] . "." . $cInfo[Zend_Db_Table_Abstract::NAME];

		$select = $this->select()
				->from(array("p" => $this->_name))
		     	->setIntegrityCheck(false)
			   	->joinLeft(array("q" => $cName), "p.project_id = q.ID", array())
			   	->order(array("q.name ASC", "p.user ASC"));

		if ($numPage >= 0 && $maxPerPage !== null) {
			$select->limitPage($numPage, $maxPerPage);
		}

		// Applica i filtri di ricerca:
		if (count($this->_filtriRicerca) > 0) {
			foreach ($this->_filtriRicerca as $f) {
				$select->where($f);
			}
		}

		return $this->fetchAll($select);
	}

	/**
	 * Conta in numero di record.
	 *
	 * @return int
	 */
	public function count() {
		$adapter = $this->getAdapter();

		$clients = new Clients();
		$cInfo = $clients->info();
		$cName = $cInfo[Zend_Db_Table_Abstract::SCHEMA] . "." . $cInfo[Zend_Db_Table_Abstract::NAME];

		$select = $this->select()
				->from(array("p" => $this->_name), array("num" => "COUNT(p.id)"))
		     	->setIntegrityCheck(false)
			   	->joinLeft(array("q" => $cName), "p.project_id = q.ID", array())
			   	->order(array("q.name ASC", "p.user ASC"));

		// Applica i filtri di ricerca:
		if (count($this->_filtriRicerca) > 0) {
			foreach ($this->_filtriRicerca as $f) {
				$select->where($f);
			}
		}

		$rows = $this->fetchAll($select);

		if (count($rows)>0) {
			return (int)$rows->current()->num;
		}
		return 0;
	}


	public function insert(array $data)	{
		try {
			// Setta le date di inserimento e modifica:
			$data["data_ins"] = $data["data_mod"] = date("Y-m-d H:i:s");

			$id = parent::insert($data);
		} catch (Exception $ex) {
			// Segna l'errore nello stack dei msg di errore:
			Neikos_Systemmessage::push("E' occorso un errore nel salvataggio dell'account FTP. <br />" . $ex->__toString(), Neikos_Systemmessage::MSG_ERRORE);
			return false;
		}

		// Scrive sul log:
		Neikos_Log::Write(sprintf("Nuovo account FTP: (%s)", $id));

		// Scrive nello stack dei messaggi:
		Neikos_Systemmessage::push("L'account FTP &egrave; stato salvato con successo.");

		return $id;
	}

	public function update(array $data, $where)
	{
		try {
			$oldDati = $this->fetchAll($where);

			if (count($oldDati) > 0) {
				$stringa = array();
				foreach ($oldDati as $oldData) {
					$stringa[] = sprintf("Modifica account FTP: (%s), %s, %s, %s, %s, %s, %s, %s", $oldData->id, $oldData->user, base64_encode($oldData->pw), $oldData->host, $oldData->url, $oldData->quota_ass, $oldData->server_id, base64_encode($oldData->note));
				}
			}
		} catch (Exception $ex) {
			// Nessuna eccezione mostrata...
		}

		try {
			// Setta la data di ultima modifica:
			$data["data_mod"] = date("Y-m-d H:i:s");

			$numRows = parent::update($data, $where);
		} catch(Exception $ex) {
			// Salva un msg di errore nello stack dei msg:
			Neikos_Systemmessage::push("Errore nella modifica dei record.<br />" . $ex->__toString(), Neikos_Systemmessage::MSG_ERRORE);

			return false;
		}

		// Scrive sul file di log:
		Neikos_Log::Write($stringa);

		// Scrive nello stack dei messaggi:
		Neikos_Systemmessage::push("L'account FTP &egrave; stato modificato con successo.");

		return $numRows;
	}

	public function delete($where)
	{
		try {
			$oldDati = $this->fetchAll($where);

			if (count($oldDati) > 0) {
				$stringa = array();
				foreach ($oldDati as $oldData) {
					$stringa[] = sprintf("Eliminazione account FTP: (%s), %s, %s, %s, %s, %s, %s, %s", $oldData->id, $oldData->user, base64_encode($oldData->pw), $oldData->host, $oldData->url, $oldData->quota_ass, $oldData->server_id, base64_encode($oldData->note));
				}
			}
		} catch (Exception $ex) {
			// Nessuna eccezione mostrata...
		}

		try {
			$numRows = parent::delete($where);
		} catch(Exception $ex) {
			// Salva un msg di errore nello stack dei msg:
			Neikos_Systemmessage::push("Errore nell'eliminazione dei record.<br />" . $ex->__toString(), Neikos_Systemmessage::MSG_ERRORE);

			return false;
		}

		// Scrive nel log:
		Neikos_Log::Write($stringa);

		// Salva un msg di OK nello stack dei msg positivi:
		Neikos_Systemmessage::push(sprintf("L'eliminazione &egrave; stata efettuata con successo. Record eliminati: %d", $numRows));

		return $numRows;
	}
}

?>