<?php

class Mail extends Zend_Db_Table_Abstract {
	protected $_name = 'mail';
	protected $_dependentTables = array();

	protected $_referenceMap    = array(
		'Servers' => array(
            'columns'           => 'server_id',
            'refTableClass'     => 'Servers',
            'refColumns'        => 'id'
        ),

        'MailDomains' => array(
            'columns'           => 'mail_domains_id',
            'refTableClass'     => 'MailDomains',
            'refColumns'        => 'id'
        )
	);


	const STATUS_ATTIVO = "A";
	const STATUS_SOSPESO = "S";
	const STATUS_NON_CONFIGURATO = "N";

    const TYPE_ACCOUNT = "A";
    const TYPE_LISTA_DISTRIBUZIONE = "L";


	/**
	 * Prende tutti i dati che saranno visualizzati
	 * in una pagina.
	 *
	 * @param int $numPage - pagina corrente (default: 1).
	 * @param int $maxPerPage - numero massimo di record per pagina (default = 25).
	 * @return mixed
	 */
	public function getPage($numPage = 1, $maxPerPage = 25) {
		$select = $this->select()->from($this)
				 ->limitPage($numPage, $maxPerPage)->order(array("mail_domains_id ASC", "user ASC"));

		// Applica i filtri di ricerca:
		if (is_array($this->_filtriRicerca)) {
			foreach ($this->_filtriRicerca as $f) {
				$select->where($f);
			}
		}

		return $this->fetchAll($select);
	}

	/**
	 * Conta in numero di record.
	 *
	 * @return int
	 */
	public function count() {
		$select = $this->select();
		$select->from($this, array("num" => "COUNT(id)"));

		// Applica i filtri di ricerca:
		if (is_array($this->_filtriRicerca)) {
			foreach ($this->_filtriRicerca as $f) {
				$select->where($f);
			}
		}

		$rows = $this->fetchAll($select);

		if (count($rows)>0) {
			return (int)$rows->current()->num;
		}
		return 0;
	}

	// Filtri di ricerca:
	protected $_filtriRicerca = null;

	/**
	 * Setta i filtri per la lista dei domini.
	 */
	public function setFiltri($filtriRicerca) {
		$f = array();

		if ($filtriRicerca->server_id > 0) {
			$f[] = $this->_db->quoteInto("server_id = ?", $filtriRicerca->server_id);
		}
		if ($filtriRicerca->client_id > 0) {
			$f[] = $this->_db->quoteInto("0 NOT IN (SELECT COUNT(d.id) FROM mail_domains AS d WHERE d.id=mail_domains_id AND d.project_id = ?)", $filtriRicerca->client_id);
		}
		if ($filtriRicerca->mail_domains_id > 0) {
			$f[] = $this->_db->quoteInto("mail_domains_id = ?", $filtriRicerca->mail_domains_id);
		}

		$this->_filtriRicerca = $f;
	}

 	public function insert(array $data)
    {
		return null;
    }

    public function update(array $data, $where)
    {
        // Permette solo la modifica della password:
        $newData = array(
            'pw' => $data['pw']
        );

    	try {
			$oldDati = $this->fetchAll($where);

			if (count($oldDati) > 0) {
				$stringa = array();
				foreach ($oldDati as $oldData) {
					$stringa[] = sprintf("Modifica mail: (%s), %s", $oldData->id, base64_encode($oldData->pw));
				}
			}
		} catch (Exception $ex) {
			// Nessuna eccezione mostrata...
		}

		try {
			$numRows = parent::update($newData, $where);
		} catch(Exception $ex) {
			// Salva un msg di errore nello stack dei msg:
			Neikos_Systemmessage::push("Errore nella modifica dei record.<br />" . $ex->__toString(), Neikos_Systemmessage::MSG_ERRORE);

			return false;
		}

		// Scrive sul file di log:
		Neikos_Log::Write($stringa);

		return $numRows;
    }

    public function delete($where) {
    	return null;
    }
}
