<?php

class MailDomains extends Zend_Db_Table_Abstract {
	protected $_name = 'mail_domains';
	protected $_dependentTables = array('Servers', 'MailDomainsAliases');

	protected $_referenceMap    = array(
		'Server' => array(
            'columns'           => 'server_id',
            'refTableClass'     => 'Servers',
            'refColumns'        => 'id'
        ),

        'Clients' => array(
            'columns'           => 'project_id',
            'refTableClass'     => 'Clients',
            'refColumns'        => 'ID'
        )
	);

	// Classe custom per la riga sul db:
	protected $_rowClass = "MailDomains_Row";


	/**
	 * Ottiene un record in funzione del suo id
	 *
	 * @param int $id
	 *
	 * @return Zend_Db_Table_Row_Abstract|boolean
	 */
	public static function getRowById($id) {
	    $model = new self();

	    $rowset = $model->find($id);
	    if (count($rowset) > 0) {
	        return $rowset->current();
	    }

	    return false;
	}

    /**
	 * Prende tutti i dati che saranno visualizzati
	 * in una pagina.
	 *
	 * @param int $numPage - pagina corrente (default: 1).
	 * @param int $maxPerPage - numero massimo di record per pagina (default = 25).
	 * @return mixed
	 */
	public function getPage($numPage = 1, $maxPerPage = 25) {
		$select = $this->select()->
				 limitPage($numPage, $maxPerPage)->order(array("mail_domains.name ASC"));

		// Applica i filtri di ricerca:
		if (is_array($this->_filtriRicerca)) {
			foreach ($this->_filtriRicerca as $f) {
				$select->where($f);
			}
		}

		return $this->fetchAll($select);
	}

	/**
	 * Conta in numero di record.
	 *
	 * @return int
	 */
	public function count() {
		$select = $this->select();
		$select->from($this, array("num" => "COUNT(mail_domains.id)"));

		// Applica i filtri di ricerca:
		if (is_array($this->_filtriRicerca)) {
			foreach ($this->_filtriRicerca as $f) {
				$select->where($f);
			}
		}

		$rows = $this->fetchAll($select);

		if (count($rows)>0) {
			return (int)$rows->current()->num;
		}
		return 0;
	}

	// Filtri di ricerca:
	protected $_filtriRicerca = null;

	/**
	 * Setta i filtri per la lista dei domini.
	 */
	public function setFiltri($filtriRicerca) {
		$f = array();

		if ($filtriRicerca->server_id > 0) {
			$f[] = $this->_db->quoteInto("mail_domains.server_id = ?", $filtriRicerca->server_id);
		}
		if (!empty($filtriRicerca->q)) {
			$f[] = $this->_db->quoteInto("mail_domains.name LIKE ?", "%" . $filtriRicerca->q . "%") . " OR " .
				   $this->_db->quoteInto("(0) NOT IN (SELECT COUNT(mda.id) FROM mail_domains_aliases as mda WHERE mda.mail_domains_id=mail_domains.id AND mda.name LIKE ?)", "%" . $filtriRicerca->q . "%");
		}
		if ($filtriRicerca->project_id > 0) {
			$f[] = $this->_db->quoteInto("mail_domains.project_id = ?", $filtriRicerca->project_id);
		} else if ($filtriRicerca->project_id == -1) {
			$f[] = "mail_domains.project_id IS NULL OR mail_domains.project_id = 0";
		} else if ($filtriRicerca->project_id == -2) {
			$clients = new Clients();
			$f[] = "mail_domains.project_id IN ('" . implode("', '", $clients->getIdFermati()) . "')";
		}

		$this->_filtriRicerca = $f;
	}

	public function insert(array $data)
    {
		return null;
    }

 	public function update(array $data, $where)
    {
    	try {
    		$select = $this->select()->where($where);
    		$oldDati = $this->fetchAll($select);

			if (count($oldDati) > 0) {
				$stringa = array();
				foreach ($oldDati as $oldData) {
					$stringa[] = sprintf("Modifica dominio di posta: (%s), %s, %s", $oldData->id, $oldData->name, $oldData->project_id);
				}
    		}
    	} catch (Exception $ex) {
    		// Nessuna eccezione mostrata...
    	}

		try {
			$numRows = parent::update($data, $where);
		} catch(Exception $ex) {
			// Salva un msg di errore nello stack dei msg:
			Neikos_Systemmessage::push("Errore nella modifica dei record.<br />" . $ex->__toString(), Neikos_Systemmessage::MSG_ERRORE);

			return false;
		}

		// Scrive sul file di log:
		Neikos_Log::Write($stringa);

    	return $numRows;
    }

    public function delete($where) {
    	return null;
    }
}
