<?php

class Servers extends Zend_Db_Table_Abstract {
	protected $_name = 'servers';
	protected $_dependentTables = array('Dns', 'Domains', 'Ftp', 'Mail', 'MailDomains', 'MailDomainsAliases', 'Software', 'SupportMail', 'Updates', 'Database', 'DatabaseUser');
	protected $_referenceMap    = array(
      	'Clients' => array(
     		'columns'           => 'project_id',
            'refTableClass'     => 'Clients',
            'refColumns'        => 'ID'
     	),
	    'Servers_Group' => array(
	        'columns'           => 'servers_group_id',
	        'refTableClass'     => 'Servers_Group',
	        'refColumns'        => 'id'
	    )
	);

	// Classe custom per la riga sul db:
	protected $_rowClass = "Servers_Row";

	const STATO_ATTIVO = "A";
	const STATO_NON_ATTIVO = "D";

	const SERVER_NEIKOS = "S";
	const SERVER_ESTERNO = "N";

	const AGGIORNABILE_SI = "S";
	const AGGIORNABILE_NO = "N";


	public static function getLista($where = null) {
		$model = new self();

		$sel = $model->select();
		$sel->setIntegrityCheck(false)
		    ->from(array("s" => "servers"))
		    ->joinLeft(array("sg" => "servers_group"), "sg.id = s.servers_group_id", array("group_name" => "name"))
		    ->order(array("sg.position ASC"))
			->order(array("s.name ASC", "s.id ASC"));

		if (!empty($where)) {
			$sel->where($where);
		}

		return $model->fetchAll($sel);
	}


	public static function getListaPerSelect($where = null) {
		$ris = self::getLista($where);
		$ret = array();

		if (count($ris) > 0) {
			foreach ($ris as $row) {
				$key = "Server Neikos";
				$kp = "";
				if ($row->is_neikos != self::SERVER_NEIKOS) {
					$key = "Server esterno";

					// Nome del proprietario:
					$p = $row->findParentRow("Clients");
					if ($p !== null) {
						$kp = " (" . $p->name . ")";
					}
				}

				$ret[$key][$row->id] = $row->name . $kp;
			}
		}

		return $ret;
	}


	public function insert(array $data)
	{
		try {
			$id = parent::insert($data);
		} catch (Exception $ex) {
			// Segna l'errore nello stack dei msg di errore:
			Neikos_Systemmessage::push("E' occorso un errore nel salvataggio del server. <br />" . $ex->__toString(), Neikos_Systemmessage::MSG_ERRORE);
			return false;
		}

		// Scrive sul log:
		Neikos_Log::Write(sprintf("Nuovo server: (%s)", $id));

		// Scrive nello stack dei messaggi:
		Neikos_Systemmessage::push("Il server &egrave; stato salvato con successo.");

		return $id;
	}


	public function update(array $data, $where)
	{
		try {
			$oldDati = $this->fetchAll($where);

			if (count($oldDati) > 0) {
				$stringa = array();
				foreach ($oldDati as $oldData) {
					$stringa[] = sprintf("Modifica server: (%s), %s, %s, %s, %s, '%s', '%s'", $oldData->id, $oldData->name, $oldData->servers_group_id, $oldData->user, base64_encode($oldData->pw), implode(";", $oldData->ip), base64_encode($oldData->note));
				}
			}
		} catch (Exception $ex) {
			// Nessuna eccezione mostrata...
		}

		try {
			$numRows = parent::update($data, $where);
		} catch(Exception $ex) {
			// Salva un msg di errore nello stack dei msg:
			Neikos_Systemmessage::push("Errore nella modifica dei record.<br />" . $ex->__toString(), Neikos_Systemmessage::MSG_ERRORE);

			return false;
		}

		// Scrive sul file di log:
		Neikos_Log::Write($stringa);

		return $numRows;
	}


	public function delete($where)
	{
		try {
			$oldDati = $this->fetchAll($where);

			if (count($oldDati) > 0) {
				$stringa = array();
				foreach ($oldDati as $oldData) {
					$stringa[] = sprintf("Eliminazione server: (%s), %s, %s, %s, %s, '%s', '%s'", $oldData->id, $oldData->name, $oldData->servers_group_id, $oldData->user, base64_encode($oldData->pw), implode(";", $oldData->ip), base64_encode($oldData->note));
				}
			}
		} catch (Exception $ex) {
			// Nessuna eccezione mostrata...
		}

		try {
			$numRows = parent::delete($where);
		} catch(Exception $ex) {
			// Salva un msg di errore nello stack dei msg:
			Neikos_Systemmessage::push("Errore nell'eliminazione dei record.<br />" . $ex->__toString(), Neikos_Systemmessage::MSG_ERRORE);

			return false;
		}

		// Scrive nel log:
		Neikos_Log::Write($stringa);

		// Salva un msg di OK nello stack dei msg positivi:
		Neikos_Systemmessage::push(sprintf("L'eliminazione &egrave; stata efettuata con successo. Record eliminati: %d", $numRows));

		return $numRows;
	}
}
