<?php

class Servers_Group extends Zend_Db_Table_Abstract {
    protected $_name = 'servers_group';
    protected $_dependentTables = array('Servers');

    /**
     * Lista gruppi server.
     *
     * @param int $tipo_id
     * @return Zend_Db_Table_Rowset
     */
    public static function getAll() {
        $model = new self();
        $sel = $model->select();
        $sel->order("position ASC");

        return $model->fetchAll($sel);
    }

    /**
     * Lista gruppi server per un select.
     *
     * @param int $tipo_id
     * @return Zend_Db_Table_Rowset
     */
    public static function getAllForSelect() {
        $rowset = self::getAll();
        $ret = array();

        if (count($rowset) > 0) {
            foreach ($rowset as $row) {
                $ret[$row->id] = $row->name;
            }
        }

        return $ret;
    }
}