<?php

class Servers_Row extends Zend_Db_Table_Row {
    /**
     * Retrieve row field value
     *
     * @param  string $columnName The user-specified column name.
     * @return string             The corresponding column value.
     * @throws Zend_Db_Table_Row_Exception if the $columnName is not a column in the row.
     */
    public function __get($columnName)
    {
        $value = parent::__get($columnName);

        if ($columnName == "allowed_updates" || $columnName == "ip") {
            $value = explode(";", $value);
        }

        return $value;
    }

    /**
     * Set row field value
     *
     * @param  string $columnName The column key.
     * @param  mixed  $value      The value for the property.
     * @return void
     * @throws Zend_Db_Table_Row_Exception
     */
    public function __set($columnName, $value)
    {
        if ($columnName == "allowed_updates" || $columnName == "ip") {
            if (is_array($value)) {
                $value = implode(";", $value);
            }
        }

        parent::__set($columnName, $value);
    }

    /**
     * Returns the column/value data as an array.
     *
     * @return array
     */
    public function toArray() {
        $data = (array)$this->_data;
        $data['ip'] = $this->ip;
        $data['allowed_updates'] = $this->allowed_updates;

        return $data;
    }

    /**
     * Verifica se un server è cancellabile.
     *
     * @return boolean
     */
    public function canBeDeleted()
    {
        // E' cancellabile se non ci sono record associati:
        foreach ($this->getTable()->getDependentTables() as $table) {
            if (count($this->findDependentRowset($table)) > 0) {
                return false;
            }
        }

        return true;
    }


    /**
     * Nome della tipologia di server.
     *
     * @return string|null
     */
    public function getNomeTipoligia() {
        $group = $this->findParentRow('Servers_Group');
        if (!empty($group)) {
            return $group->name;
        }

        return null;
    }
}