<?php

class Software_Tipo extends Zend_Db_Table_Abstract {
	protected $_name = 'software_tipo';
	protected $_dependentTables = array("Software", "Software_Plugin");

	// Class custom per la riga sul db:
	protected $_rowClass = "Software_Tipo_Row";


	/**
	 * Nome del tipo
	 *
	 * @param int $id
	 *
	 * @return null|string
	 */
	public static function getNome($id) {
	    $model = new self();
	    $rowset = $model->find($id);

	    if (count($rowset) > 0) {
	        $row = $rowset->current();
	        return $row->tipo;
	    }

	    return null;
	}


	/**
	 * Genera una lista di tipi software per select.
	 *
	 * @param bool $showNumSoftare  Se settato a true, il nome del software conterrà tra parentesi
	 * il numero di software associato.
	 */
	public static function getListaPerSelect($showNumSoftare = false) {
		$model = new self();

		$ris = $model->fetchAll($model->select()->order(array("tipo ASC")));
		$ret = array();

		if (count($ris)>0) {
			foreach ($ris as $row) {
				$nomeTipo = $row->tipo;

				if ($showNumSoftare) {
					// Calcola il numero di software associato:
					$numSoftware = Software::getNumByTipo($row->id);
					$nomeTipo .= " (" . $numSoftware . ")";
				}

				$ret[$row->id] = $nomeTipo;
			}
		}

		return $ret;
	}

	public function insert(array $data)	{
		try {
			// Setta le date di inserimento e modifica:
			$data["data_ins"] = $data["data_mod"] = date("Y-m-d H:i:s");

			$id = parent::insert($data);
		} catch (Exception $ex) {
			// Segna l'errore nello stack dei msg di errore:
			Neikos_Systemmessage::push("E' occorso un errore nel salvataggio del tipo software. <br />" . $ex->__toString(), Neikos_Systemmessage::MSG_ERRORE);
			return false;
		}

		// Scrive sul log:
		Neikos_Log::Write(sprintf("Nuovo tipo software: (%s)", $id));

		// Scrive nello stack dei messaggi:
		Neikos_Systemmessage::push("Il tipo software &egrave; stato salvato con successo.");

		return $id;
	}

	public function update(array $data, $where)
	{
		try {
			$oldDati = $this->fetchAll($where);

			if (count($oldDati) > 0) {
				$stringa = array();
				foreach ($oldDati as $oldData) {
					$stringa[] = sprintf("Modifica tipo software: (%s), %s", $oldData->id, $oldData->tipo);
				}
			}
		} catch (Exception $ex) {
			// Nessuna eccezione mostrata...
		}

		try {
			// Setta la data di ultima modifica:
			$data["data_mod"] = date("Y-m-d H:i:s");

			$numRows = parent::update($data, $where);
		} catch(Exception $ex) {
			// Salva un msg di errore nello stack dei msg:
			Neikos_Systemmessage::push("Errore nella modifica dei record.<br />" . $ex->__toString(), Neikos_Systemmessage::MSG_ERRORE);

			return false;
		}

		// Scrive sul file di log:
		Neikos_Log::Write($stringa);

		// Scrive nello stack dei messaggi:
		Neikos_Systemmessage::push("Il tipo software &egrave; stato modificato con successo.");

		return $numRows;
	}

	public function delete($where)
	{
		try {
			$oldDati = $this->fetchAll($where);

			if (count($oldDati) > 0) {
				$stringa = array();
				foreach ($oldDati as $oldData) {
					// Lista di id software associati:
					$softwareListId = "";
					$softwareList = Software::getSoftwareByTipo($tipo_id);
					if (count($softwareList) > 0) {
						foreach ($softwareList as $s) {
							if ($softwareListId != "") $softwareListId .= ",";
							$softwareListId .= $s->id;
						}
					}

					$stringa[] = sprintf("Eliminazione software: (%s), %s, %s", $oldData->id, $oldData->user, base64_encode($softwareListId));
				}
			}
		} catch (Exception $ex) {
			// Nessuna eccezione mostrata...
		}

		try {
			$numRows = parent::delete($where);
		} catch(Exception $ex) {
			// Salva un msg di errore nello stack dei msg:
			Neikos_Systemmessage::push("Errore nell'eliminazione dei record.<br />" . $ex->__toString(), Neikos_Systemmessage::MSG_ERRORE);

			return false;
		}

		// Scrive nel log:
		Neikos_Log::Write($stringa);

		// Salva un msg di OK nello stack dei msg positivi:
		Neikos_Systemmessage::push(sprintf("L'eliminazione &egrave; stata efettuata con successo. Record eliminati: %d", $numRows));

		return $numRows;
	}
}
