<?php

class Software_To_Plugin extends Zend_Db_Table_Abstract {
    protected $_name = 'software_to_plugin';
    protected $_primary = array('software_id', 'software_plugin_id');

    protected $_referenceMap    = array(
        'Software' => array(
            'columns'           => array('software_id'),
            'refTableClass'     => 'Software',
            'refColumns'        => array('id')
        ),
        'Software_Plugin' => array(
            'columns'           => array('software_plugin_id'),
            'refTableClass'     => 'Software_Plugin',
            'refColumns'        => array('id')
        )
    );


    public function insert(array $data)	{
        try {
            // Setta la data di inserimento:
            $data["data_ins"] = date("Y-m-d H:i:s");

            $id = parent::insert($data);
        } catch (Exception $ex) {
            // Segna l'errore nello stack dei msg di errore:
            Neikos_Systemmessage::push("E' occorso un errore nel salvataggio dell'associazione tra plugin e software. <br />" . $ex->__toString(), Neikos_Systemmessage::MSG_ERRORE);
            return false;
        }

        // Scrive sul log:
        Neikos_Log::Write(sprintf("Nuova associazione plugin / software: (%s)", implode("-", $id)));

        // Scrive nello stack dei messaggi:
        Neikos_Systemmessage::push("Il plugin &egrave; stato aggiunto al software con successo.");

        return $id;
    }


    public function update(array $data, $where)
    {
        try {
            $oldDati = $this->fetchAll($where);

            if (count($oldDati) > 0) {
                $stringa = array();
                foreach ($oldDati as $oldData) {
                    $stringa[] = sprintf("Modifica associazione plugin / software: (%s-%s), %s, %s", $oldData->software_id, $oldData->software_plugin_id, $oldData->versione, base64_encode($oldData->note));
                }
            }
        } catch (Exception $ex) {
            // Nessuna eccezione mostrata...
        }

        try {
            $numRows = parent::update($data, $where);
        } catch(Exception $ex) {
            // Salva un msg di errore nello stack dei msg:
            Neikos_Systemmessage::push("Errore nella modifica dei record.<br />" . $ex->__toString(), Neikos_Systemmessage::MSG_ERRORE);

            return false;
        }

        // Scrive sul file di log:
        Neikos_Log::Write($stringa);

        // Scrive nello stack dei messaggi:
        Neikos_Systemmessage::push($numRows . " " . ($numRows == 1 ? "associazione" : "associazionei") . " plugin / software " . ($numRows == 1 ? "modificata" : "modificate") . " con successo.");

        return $numRows;
    }

    public function delete($where)
    {
        try {
            $oldDati = $this->fetchAll($where);

            if (count($oldDati) > 0) {
                $stringa = array();
                foreach ($oldDati as $oldData) {
                    $stringa[] = sprintf("Eliminazione associazione plugin / software: (%s-%s), %s, %s", $oldData->software_id, $oldData->software_plugin_id, $oldData->versione, base64_encode($oldData->note));
                }
            }
        } catch (Exception $ex) {
            // Nessuna eccezione mostrata...
        }

        try {
            $numRows = parent::delete($where);
        } catch(Exception $ex) {
            // Salva un msg di errore nello stack dei msg:
            Neikos_Systemmessage::push("Errore nell'eliminazione dei record.<br />" . $ex->__toString(), Neikos_Systemmessage::MSG_ERRORE);

            return false;
        }

        // Scrive nel log:
        Neikos_Log::Write($stringa);

        // Salva un msg di OK nello stack dei msg positivi:
        Neikos_Systemmessage::push(sprintf("L'eliminazione &egrave; stata efettuata con successo. Record eliminati: %d", $numRows));

        return $numRows;
    }
}