<?php

class Updates extends Zend_Db_Table_Abstract {
	protected $_name = 'updates';

	protected static $_update_types = array(
		"D" 	=> "Hosting",
		"Db"	=> "Database",
		"M" 	=> "Posta",
		"Dns" 	=> "Dns / Domini Gestiti",
	    "S"     => "Software"
	);

	public static function getUpdateTypes() {
	    return self::$_update_types;
	}

	protected $_referenceMap    = array(
        'Servers' => array(
            'columns'           => 'server_id',
            'refTableClass'     => 'Servers',
            'refColumns'        => 'id'
        )
    );

	public function insert(array $data)
    {
    	try {
			$id = parent::insert($data);
    	} catch (Exception $ex) {
    		// Salva un msg di errore nello stack dei msg:
			Neikos_Systemmessage::push("E' occorso un errore nel salvataggio dell'aggiornamento.<br />" . $ex->__toString(), Neikos_Systemmessage::MSG_ERRORE);
    		return false;
    	}

		try {
			$select = $this->select($this, array("data_ins"))->where("id = ?", $id);
			$ris = $this->fetchAll($select);

			if (count($ris)>0) {
				$newData = $ris->current();
			} else {
				throw new Exception();
			}
		} catch (Exception $ex) {
			// Nessuna eccezione mostrata.
			return false;
		}

    	// Scrive nel log:
		Neikos_Log::Write(sprintf("Aggiornamento manuale: (%s), %s, %s", $newData->data_ins, $data["server_id"], $data["modulo"]));

		// Nome del server:
		$serverModel = new Servers();
		$serverRowset = $serverModel->find($data["server_id"]);
		$serverName = "<em>Unknown</em>";
		if (count($serverRowset) > 0) {
		     $serverRow = $serverRowset->current();
		     $serverName = $serverRow->name;
		}

		// Salva un msg di OK nello stack dei msg positivi:
		$updateTypes = Updates::getUpdateTypes();
		Neikos_Systemmessage::push(sprintf("La richiesta di aggiornamento del modulo %s sul server #%d - %s &egrave; stata salvata con successo.", $updateTypes[$data["modulo"]], $data["server_id"], $serverName));

		return $id;
    }

    public function delete($where)
    {
        try {
    		$oldDati = $this->fetchAll($where);

			if (count($oldDati) > 0) {
    			$stringa = array();
				foreach ($oldDati as $oldData) {
    				$stringa[] = sprintf("Eliminazione aggiornamento: (%s), %s, %s", $oldData->data_ins, $oldData->server_id, $oldData->modulo);
				}
    		}
    	} catch (Exception $ex) {
    		// Nessuna eccezione mostrata...
    	}

		try {
			$numRows = parent::delete($where);
		} catch(Exception $ex) {
			// Salva un msg di errore nello stack dei msg:
			Neikos_Systemmessage::push("Errore nell'eliminazione dei record.<br />" . $ex->__toString(), Neikos_Systemmessage::MSG_ERRORE);

			return false;
		}

		// Scrive nel log:
		Neikos_Log::Write($stringa);

		// Salva un msg di OK nello stack dei msg positivi:
		Neikos_Systemmessage::push(sprintf("L'eliminazione &egrave; stata efettuata con successo. Record eliminati: %d", $numRows));

        return $numRows;
    }

    /**
     * Disattiva l'update del record.
     */
   	public function update(array $data, $where) {
   		return false;
   	}
}
