<?php

class Users extends Zend_Db_Table_Abstract {
	protected $_name = 'users';
	protected $_primary = 'ID';
	protected $_schema = 'agenda';
	protected $_dependentTables = array('SupportMail');

	const ERROR_CODE_INVALID_CREDENTIAL = 1;
	const ERROR_CODE_ROLE_NOT_VALID = 2;


	protected function _setupDatabaseAdapter() {
	    $multiDb = Zend_Registry::get("multidb");
	    $this->_db = $multiDb->getDb($this->_schema);
	}


	/**
	 * Controlla le credenziali di un utente e restituisce i suoi dati.
	 *
	 * @param string $username
	 * @param string $password
	 * @param array $userData
	 * @param int $errorCode
	 *
	 * @return false
	 */
	public static function checkCredenziali($username, $password, &$userData = null, &$errorCode = 0) {
		// Azzera i valori:
		$userData = array();
		$errorCode = 0;

		// Gli utenti autorizzati:
		$users = new self();

		//  Controlla che le credenziali di accesso correnti siano corrette:
		$select = $users->select()->from($users, array('ID', 'pw', 'vorname', 'nachname', 'kurz', 'loginname', 'role'))
						->where("loginname = ?", $username)->where("pw = ?", $password);
		$result = $users->fetchAll($select);

		if (count($result) == 0) {
			$errorCode = self::ERROR_CODE_INVALID_CREDENTIAL;
			return false;
		}

		$userData = $result[0]->toArray();
		$cleanRole = Zend_Registry::get('clean_role');

		if (!in_array($userData['role'], $cleanRole)) {
			$errorCode = self::ERROR_CODE_ROLE_NOT_VALID;
			return false;
		}

		return true;
	}
}
